/*
 * Decompiled with CFR 0.152.
 */
package das_proto.das2Stream;

import das_proto.das2Stream.SkeletonDescriptor;
import das_proto.das2Stream.StreamDescriptor;
import das_proto.data.DataSet;
import das_proto.data.Datum;
import das_proto.data.LocationUnits;
import das_proto.data.Units;
import das_proto.data.UnitsConverter;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.util.ArrayList;
import org.w3c.dom.Node;

public class StreamXDescriptor
implements SkeletonDescriptor {
    Datum baseTime;
    ArrayList records = new ArrayList();
    double current;
    UnitsConverter uc;
    Units offsetUnits;
    String name = "";

    StreamXDescriptor(Node node, StreamDescriptor streamDescriptor) {
        Object object;
        this.baseTime = streamDescriptor.getStartTime();
        this.offsetUnits = null;
        Node node2 = node.getAttributes().getNamedItem("units");
        if (node2 != null) {
            object = node2.getNodeValue();
            if (!((String)object).equals("seconds")) {
                throw new IllegalStateException("X units are not seconds!!!");
            }
            this.offsetUnits = Units.seconds;
        }
        this.name = (node2 = (object = node.getAttributes()).getNamedItem("name")) != null ? node2.getNodeValue() : "";
        this.uc = this.baseTime != null ? UnitsConverter.getConverter(this.offsetUnits, ((LocationUnits)this.baseTime.getUnits()).getOffsetUnits()) : null;
    }

    public int getSizeBytes() {
        return 8;
    }

    public int getNumRecords() {
        return this.records.size();
    }

    public void read(byte[] byArray, int n, int n2) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        DoubleBuffer doubleBuffer = byteBuffer.asDoubleBuffer();
        doubleBuffer.position(n / 8);
        this.current = doubleBuffer.get();
        this.records.add(this.baseTime.add(this.current, Units.seconds));
    }

    public DataSet asDataSet(Datum[] datumArray) {
        return null;
    }

    public Datum[] getValues() {
        return this.records.toArray(new Datum[this.records.size()]);
    }

    public String getName() {
        return this.name;
    }
}

