/*
 * Decompiled with CFR 0.152.
 */
package das_proto.das2Stream;

import das_proto.das2Stream.SkeletonDescriptor;
import das_proto.das2Stream.StreamDescriptor;
import das_proto.data.DataSet;
import das_proto.data.Datum;
import das_proto.data.TimeDatum;
import das_proto.data.UnitsConverter;
import das_proto.data.XMultiY;
import das_proto.data.XMultiYDataSet;
import das_proto.data.XMultiYDataSetDescriptor;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.util.ArrayList;
import java.util.Hashtable;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import util.pwDate;

public class StreamMultiYDescriptor
extends XMultiYDataSetDescriptor
implements SkeletonDescriptor {
    int nitems;
    ArrayList records;
    StreamDescriptor stream;
    String name;

    public StreamMultiYDescriptor(Node node, StreamDescriptor streamDescriptor) {
        super((Hashtable)null);
        this.stream = streamDescriptor;
        if (node.getNodeName() != "YMulti") {
            throw new IllegalArgumentException("xml tree root node is not the right type");
        }
        NamedNodeMap namedNodeMap = node.getAttributes();
        Node node2 = namedNodeMap.getNamedItem("nitems");
        if (node2 != null) {
            this.nitems = Integer.parseInt(node2.getNodeValue());
        }
        this.name = (node2 = namedNodeMap.getNamedItem("name")) != null ? node2.getNodeValue() : "";
    }

    public int getSizeBytes() {
        return this.nitems * 8;
    }

    public void read(byte[] byArray, int n, int n2) {
        double[] dArray = new double[this.nitems];
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        DoubleBuffer doubleBuffer = byteBuffer.asDoubleBuffer();
        doubleBuffer.position(n / 8);
        doubleBuffer.get(dArray);
        this.records.add(new XMultiY(-1.0E31, dArray));
    }

    public int getNumRecords() {
        return this.records.size();
    }

    public DataSet asDataSet(Datum[] datumArray) {
        XMultiYDataSet xMultiYDataSet = new XMultiYDataSet(this, pwDate.create((TimeDatum)this.stream.getStartTime()), pwDate.create((TimeDatum)this.stream.getEndTime()));
        xMultiYDataSet.data = this.records.toArray(new XMultiY[this.records.size()]);
        UnitsConverter unitsConverter = datumArray[0].getUnits().getConverter(this.getXUnits());
        int n = 0;
        while (n < xMultiYDataSet.data.length) {
            xMultiYDataSet.data[n].x = datumArray[n].convertTo(this.getXUnits()).getValue();
            ++n;
        }
        xMultiYDataSet.setName(this.name);
        return xMultiYDataSet;
    }

    public String getName() {
        return this.name;
    }
}

