/*
 * Decompiled with CFR 0.152.
 */
package das_proto.das2Stream;

import das_proto.client.DasIOException;
import das_proto.data.Datum;
import das_proto.data.TimeDatum;
import java.io.IOException;
import java.io.StringBufferInputStream;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class StreamDescriptor {
    NamedNodeMap attrNode;

    public StreamDescriptor(Node node) {
        this.attrNode = node.getAttributes();
    }

    public String getAttribute(String string) {
        String string2 = "";
        if (this.attrNode.getNamedItem(string) != null) {
            string2 = this.attrNode.getNamedItem(string).getNodeValue();
        }
        return string2;
    }

    public Datum getStartTime() {
        return TimeDatum.create(this.getAttribute("startTime"));
    }

    public Datum getEndTime() {
        return TimeDatum.create(this.getAttribute("endTime"));
    }

    public boolean isCompressed() {
        return this.getAttribute("compression").equals("gzip");
    }

    public static Document parseHeader(String string) throws DasIOException {
        DocumentBuilder documentBuilder;
        try {
            documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new IllegalStateException(parserConfigurationException.getMessage());
        }
        Document document = null;
        try {
            document = documentBuilder.parse(new StringBufferInputStream(string));
        }
        catch (SAXException sAXException) {
            System.out.println(sAXException);
            throw new DasIOException(sAXException.getMessage());
        }
        catch (IOException iOException) {
            throw new DasIOException(iOException.getMessage());
        }
        return document;
    }

    public static String createHeader(Document document) throws DasIOException {
        StringWriter stringWriter = new StringWriter();
        OutputFormat outputFormat = new OutputFormat();
        outputFormat.setOmitXMLDeclaration(true);
        outputFormat.setEncoding("UTF-8");
        XMLSerializer xMLSerializer = new XMLSerializer((Writer)stringWriter, outputFormat);
        try {
            xMLSerializer.serialize(document);
        }
        catch (IOException iOException) {
            throw new DasIOException(iOException.getMessage());
        }
        String string = stringWriter.toString();
        return string;
    }
}

