/*
 * Decompiled with CFR 0.152.
 */
package das_proto.das2Stream;

import das_proto.DasException;
import das_proto.client.DasIOException;
import das_proto.client.NoSuchDataSetException;
import das_proto.client.StandardDataStreamSource;
import das_proto.das2Stream.DasStreamFormatException;
import das_proto.das2Stream.SkeletonDescriptor;
import das_proto.das2Stream.StreamDescriptor;
import das_proto.das2Stream.StreamMultiYDescriptor;
import das_proto.das2Stream.StreamXDescriptor;
import das_proto.das2Stream.StreamYScanDescriptor;
import das_proto.data.DataRequestor;
import das_proto.data.DataSet;
import das_proto.data.DataSetDescriptor;
import das_proto.data.Datum;
import das_proto.data.TimeDatum;
import das_proto.data.XTaggedYScanDataSet;
import das_proto.data.XTaggedYScanDataSetDescriptor;
import das_proto.data.rebinDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.io.StringBufferInputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.zip.GZIPInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import util.StreamTool;
import util.pwDate;

public class MultiPlanarDataSet {
    private ArrayList dataSets = new ArrayList();
    StreamDescriptor streamDescriptor = null;

    public String[] getDataSetNames() {
        String[] stringArray = new String[this.dataSets.size()];
        int n = 0;
        while (n < this.dataSets.size()) {
            stringArray[n] = ((DataSet)this.dataSets.get(n)).getName();
            ++n;
        }
        return stringArray;
    }

    public DataSet getDataSet(String string) throws NoSuchDataSetException {
        DataSet dataSet = null;
        String[] stringArray = this.getDataSetNames();
        int n = 0;
        while (n < this.dataSets.size()) {
            if (string.equals(stringArray[n])) {
                dataSet = (DataSet)this.dataSets.get(n);
            }
            ++n;
        }
        if (dataSet == null) {
            throw new NoSuchDataSetException("MultiPlanarDataSet does not contain '" + string + "'");
        }
        return dataSet;
    }

    public void addDataSet(DataSet dataSet) {
        this.dataSets.add(dataSet);
    }

    private ArrayList createSkeleton(String string) throws DasException {
        DocumentBuilder documentBuilder;
        ArrayList<SkeletonDescriptor> arrayList = new ArrayList<SkeletonDescriptor>();
        try {
            documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new IllegalStateException(parserConfigurationException.getMessage());
        }
        Document document = null;
        try {
            document = documentBuilder.parse(new StringBufferInputStream(string));
        }
        catch (SAXException sAXException) {
            System.out.println(sAXException);
            throw new DasIOException(sAXException.getMessage());
        }
        catch (IOException iOException) {
            throw new DasIOException(iOException.getMessage());
        }
        Element element = document.getDocumentElement();
        this.streamDescriptor = new StreamDescriptor(element);
        if (!element.getNodeName().equals("dataSet")) {
            element.toString();
        } else {
            NamedNodeMap namedNodeMap = element.getAttributes();
            NodeList nodeList = element.getChildNodes();
            int n = 0;
            while (n < nodeList.getLength()) {
                Node node = nodeList.item(n);
                if (node.getNodeType() == 1) {
                    DataSetDescriptor dataSetDescriptor;
                    String string2 = node.getNodeName();
                    if (string2.equals("X")) {
                        arrayList.add(new StreamXDescriptor(node, this.streamDescriptor));
                    } else if (string2.equals("YScan")) {
                        dataSetDescriptor = new StreamYScanDescriptor(node, this.streamDescriptor);
                        arrayList.add((SkeletonDescriptor)((Object)dataSetDescriptor));
                    } else if (string2.equals("MultiY")) {
                        dataSetDescriptor = new StreamMultiYDescriptor(node, this.streamDescriptor);
                        arrayList.add((SkeletonDescriptor)((Object)dataSetDescriptor));
                    } else {
                        node.toString();
                    }
                }
                ++n;
            }
        }
        return arrayList;
    }

    public void read(InputStream inputStream) throws DasException {
        this.read(inputStream, null);
    }

    public void read(InputStream inputStream, DataRequestor dataRequestor) throws DasException {
        boolean bl;
        MultiPlanarDataSet multiPlanarDataSet = this;
        PushbackInputStream pushbackInputStream = new PushbackInputStream(inputStream);
        ArrayList arrayList = new ArrayList();
        String string = null;
        int n = 0;
        try {
            byte[] byArray;
            boolean bl2 = false;
            bl = false;
            String string2 = "das2\u007f\u007f";
            try {
                byArray = StreamTool.advanceTo(pushbackInputStream, string2.getBytes());
            }
            catch (StreamTool.DelimeterNotFoundException delimeterNotFoundException) {
                throw new DasStreamFormatException("Stream does not appear to be a das2 stream");
            }
            try {
                byArray = StreamTool.advanceTo(pushbackInputStream, "\u007f\u007f".getBytes());
            }
            catch (StreamTool.DelimeterNotFoundException delimeterNotFoundException) {
                throw new DasStreamFormatException("Stream does not appear to be a das2 stream");
            }
            string = new String(byArray);
        }
        catch (IOException iOException) {
            throw new DasIOException(iOException.getMessage());
        }
        ArrayList arrayList2 = this.createSkeleton(string);
        if (this.streamDescriptor.isCompressed()) {
            try {
                inputStream = new GZIPInputStream(inputStream);
            }
            catch (IOException iOException) {
                throw new DasIOException("Error in gzip input stream");
            }
        }
        bl = true;
        int n2 = 0;
        int n3 = 0;
        while (n3 < arrayList2.size()) {
            n2 += ((SkeletonDescriptor)arrayList2.get(n3)).getSizeBytes();
            ++n3;
        }
        byte[] byArray = new byte[n2];
        long l = System.currentTimeMillis();
        if (dataRequestor != null) {
            dataRequestor.currentByteCount(-1);
        }
        int n4 = 0;
        while (bl) {
            int n5 = 0;
            int n6 = 0;
            while (n6 != -1 && n5 < n2) {
                try {
                    n6 = inputStream.read(byArray, n5, n2 - n5);
                    if (n6 == -1) continue;
                    n5 += n6;
                    n += n6;
                    if (dataRequestor == null) continue;
                    dataRequestor.currentByteCount(n);
                }
                catch (IOException iOException) {
                    throw new DasIOException(iOException.getMessage());
                }
            }
            if (n6 == -1) {
                bl = false;
                continue;
            }
            ++n4;
            int n7 = 0;
            int n8 = 0;
            while (n8 < arrayList2.size()) {
                SkeletonDescriptor skeletonDescriptor = (SkeletonDescriptor)arrayList2.get(n8);
                int n9 = skeletonDescriptor.getSizeBytes();
                skeletonDescriptor.read(byArray, n7, n9);
                n7 += n9;
                ++n8;
            }
        }
        this.createDataSets(arrayList2);
    }

    public DataSet getPrimaryDataSet() {
        String[] stringArray = this.getDataSetNames();
        String string = "";
        try {
            return this.getDataSet(string);
        }
        catch (NoSuchDataSetException noSuchDataSetException) {
            try {
                return this.getDataSet(stringArray[0]);
            }
            catch (NoSuchDataSetException noSuchDataSetException2) {
                throw new IllegalStateException("MultiPlanarDataSet fails to find primaryDataSet");
            }
        }
    }

    public DataSet getWeightsDataSet(String string) throws NoSuchDataSetException {
        if (string.equals("")) {
            return this.getDataSet("weights");
        }
        return this.getDataSet(string + ".weights");
    }

    public DataSet getPeaksDataSet(String string) throws NoSuchDataSetException {
        if (string.equals("")) {
            return this.getDataSet("peaks");
        }
        return this.getDataSet(string + ".peaks");
    }

    public DataSet getErrorsDataSet(String string) throws NoSuchDataSetException {
        if (string.equals("")) {
            return this.getDataSet("errors");
        }
        return this.getDataSet(string + ".errors");
    }

    public DataSet getVarianceDataSet(String string) throws NoSuchDataSetException {
        if (string.equals("")) {
            return this.getDataSet("variance");
        }
        return this.getDataSet(string + ".variance");
    }

    private void createDataSets(ArrayList arrayList) {
        block7: {
            Object object;
            int n = ((SkeletonDescriptor)arrayList.get(0)).getNumRecords();
            Datum[] datumArray = null;
            Object var4_4 = null;
            int n2 = 0;
            while (n2 < arrayList.size()) {
                object = (SkeletonDescriptor)arrayList.get(n2);
                if (object instanceof StreamXDescriptor) {
                    datumArray = ((StreamXDescriptor)object).getValues();
                } else {
                    this.addDataSet(object.asDataSet(datumArray));
                }
                ++n2;
            }
            object = this.getPrimaryDataSet();
            String string = ((DataSet)object).getName();
            if (!(object instanceof XTaggedYScanDataSet)) break block7;
            XTaggedYScanDataSet xTaggedYScanDataSet = (XTaggedYScanDataSet)object;
            XTaggedYScanDataSet xTaggedYScanDataSet2 = null;
            try {
                xTaggedYScanDataSet2 = (XTaggedYScanDataSet)this.getWeightsDataSet(string);
                xTaggedYScanDataSet.setWeights(xTaggedYScanDataSet2.data);
            }
            catch (NoSuchDataSetException noSuchDataSetException) {
                // empty catch block
            }
            try {
                XTaggedYScanDataSet xTaggedYScanDataSet3 = (XTaggedYScanDataSet)this.getPeaksDataSet(string);
                xTaggedYScanDataSet.setPeaks(xTaggedYScanDataSet3.data);
            }
            catch (NoSuchDataSetException noSuchDataSetException) {}
        }
    }

    private static boolean test1() {
        try {
            URL uRL = new URL("http://www-pw.physics.uiowa.edu/~jbf/compressedDas2Stream");
            InputStream inputStream = uRL.openStream();
            PushbackInputStream pushbackInputStream = new PushbackInputStream(inputStream, 100);
            System.out.println(MultiPlanarDataSet.isMultiPlanarDataSetStream(pushbackInputStream));
            MultiPlanarDataSet multiPlanarDataSet = new MultiPlanarDataSet();
            multiPlanarDataSet.read(pushbackInputStream, null);
            String[] stringArray = multiPlanarDataSet.getDataSetNames();
            int n = 0;
            while (n < stringArray.length) {
                System.out.println(stringArray[n]);
                ++n;
            }
            XTaggedYScanDataSet xTaggedYScanDataSet = (XTaggedYScanDataSet)multiPlanarDataSet.getPrimaryDataSet();
            xTaggedYScanDataSet.visualize();
            return true;
        }
        catch (MalformedURLException malformedURLException) {
            System.out.println(malformedURLException);
            return false;
        }
        catch (IOException iOException) {
            System.out.println(iOException);
            return false;
        }
        catch (DasException dasException) {
            System.out.println(dasException);
            return false;
        }
    }

    private static boolean test2() {
        try {
            XTaggedYScanDataSetDescriptor xTaggedYScanDataSetDescriptor = (XTaggedYScanDataSetDescriptor)DataSetDescriptor.create("http://www-pw.physics.uiowa.edu/das/dasServerTest1?das2/demo/sa-4s-sd_jbf");
            StandardDataStreamSource standardDataStreamSource = xTaggedYScanDataSetDescriptor.getStandardDataStreamSource();
            InputStream inputStream = standardDataStreamSource.getReducedInputStream(xTaggedYScanDataSetDescriptor, null, new pwDate("1979-3-1"), new pwDate("1979-3-2"), 120.0);
            MultiPlanarDataSet multiPlanarDataSet = new MultiPlanarDataSet();
            multiPlanarDataSet.read(inputStream);
            XTaggedYScanDataSet xTaggedYScanDataSet = (XTaggedYScanDataSet)multiPlanarDataSet.getPrimaryDataSet();
            xTaggedYScanDataSet.visualize();
            rebinDescriptor rebinDescriptor2 = new rebinDescriptor(TimeDatum.create(xTaggedYScanDataSet.getStartTime()), TimeDatum.create(xTaggedYScanDataSet.getEndTime()), 100, false);
            XTaggedYScanDataSet xTaggedYScanDataSet2 = xTaggedYScanDataSet.binAverageX(rebinDescriptor2);
            xTaggedYScanDataSet2.visualize();
            try {
                xTaggedYScanDataSet.dumpToStream(new FileOutputStream("/home/jbf/xxx.dat"));
                xTaggedYScanDataSet2.dumpToStream(new FileOutputStream("/home/jbf/xxx2.dat"));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            System.out.println("" + xTaggedYScanDataSet);
            return true;
        }
        catch (DasException dasException) {
            System.out.println("" + dasException);
            return false;
        }
    }

    public static void main(String[] stringArray) {
        System.out.println(MultiPlanarDataSet.test1());
    }

    public static boolean isMultiPlanarDataSetStream(PushbackInputStream pushbackInputStream) throws DasIOException {
        byte[] byArray = "das2\u007f\u007f".getBytes();
        int n = byArray.length;
        byte[] byArray2 = new byte[n];
        int n2 = 0;
        int n3 = 0;
        try {
            while (n2 < n && n3 != -1) {
                n3 = pushbackInputStream.read(byArray2, n2, n - n2);
                n2 += n3;
            }
            boolean bl = true;
            if (n2 == n) {
                int n4 = 0;
                while (n4 < n) {
                    if (byArray[n4] != byArray2[n4]) {
                        bl = false;
                    }
                    ++n4;
                }
            } else {
                bl = false;
            }
            pushbackInputStream.unread(byArray2);
            return bl;
        }
        catch (IOException iOException) {
            throw new DasIOException(iOException.getMessage());
        }
    }
}

