/*
 * Decompiled with CFR 0.152.
 */
package das_proto.client;

import das_proto.DasException;
import das_proto.client.Authenticator;
import das_proto.client.DasIOException;
import das_proto.client.DasServerException;
import das_proto.client.Key;
import das_proto.client.MeteredInputStream;
import das_proto.client.NoSuchDataSetException;
import das_proto.client.StandardDataStreamSource;
import das_proto.data.AccessDeniedException;
import das_proto.data.DataSetDescriptor;
import das_proto.data.NoDataInIntervalException;
import das_proto.data.NoKeyProvidedException;
import das_proto.data.XTaggedYScanDataSetDescriptor;
import das_proto.server.DasServer;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.Properties;
import javax.swing.JOptionPane;
import util.DasExceptionHandler;
import util.pwDate;
import util.pwDie;

public class WebStandardDataStreamSource
implements StandardDataStreamSource {
    private Key key;
    private DasServer server;
    private MeteredInputStream min;

    public WebStandardDataStreamSource(DasServer dasServer) {
        this.server = dasServer;
    }

    private Key getKey() {
        return this.getStoredKey();
    }

    private Key getStoredKey() {
        String string = System.getProperty("user.home") + System.getProperty("file.separator") + ".das2rc";
        File file = new File(string);
        Properties properties = new Properties();
        if (file.canRead()) {
            try {
                FileInputStream fileInputStream = new FileInputStream(file);
                properties.load(fileInputStream);
                ((InputStream)fileInputStream).close();
            }
            catch (IOException iOException) {
                DasExceptionHandler.handle(iOException);
            }
        } else {
            String string2 = JOptionPane.showInputDialog(null, "Enter temporary key: ", "Need a key", 3);
            properties.put("keyHack", string2);
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                properties.store(fileOutputStream, "");
                ((OutputStream)fileOutputStream).close();
            }
            catch (IOException iOException) {
                DasExceptionHandler.handle(iOException);
            }
        }
        if (properties.containsKey("keyHack")) {
            return new Key((String)properties.get("keyHack"));
        }
        return null;
    }

    public InputStream getInputStream(DataSetDescriptor dataSetDescriptor, Object object, pwDate pwDate2, pwDate pwDate3) throws DasException {
        String string = "dataset";
        String string2 = "server=" + string;
        InputStream inputStream = this.openURLConnection(dataSetDescriptor, object, pwDate2, pwDate3, string2);
        MeteredInputStream meteredInputStream = new MeteredInputStream(inputStream);
        meteredInputStream.setSpeedLimit(3300.0);
        return meteredInputStream;
    }

    public InputStream getReducedInputStream(XTaggedYScanDataSetDescriptor xTaggedYScanDataSetDescriptor, Object object, pwDate pwDate2, pwDate pwDate3, double d) throws DasException {
        String string = "compactdataset";
        String string2 = "server=" + string;
        string2 = string2 + "&resolution=" + d;
        string2 = string2 + "&nitems=" + (xTaggedYScanDataSetDescriptor.y_coordinate.length + 1);
        boolean bl = true;
        if (this.min != null) {
            pwDie.println(pwDie.DEBUG, "last transfer speed (byte/sec)= " + this.min.calcTransmitSpeed());
            pwDie.println(pwDie.DEBUG, "   time to transfer (sec)= " + this.min.calcTransmitTime());
            pwDie.println(pwDie.DEBUG, "   total kbytes transferred= " + this.min.totalBytesTransmitted() / 1024L);
        }
        if (this.min != null && this.min.calcTransmitSpeed() > 30000.0) {
            bl = false;
        }
        if (xTaggedYScanDataSetDescriptor.isDas2Stream() && bl) {
            pwDie.println(pwDie.DEBUG, "compressing data stream");
            string2 = string2 + "&compress=true";
        } else {
            pwDie.println(pwDie.DEBUG, "NOT compressing data stream");
        }
        InputStream inputStream = this.openURLConnection(xTaggedYScanDataSetDescriptor, object, pwDate2, pwDate3, string2);
        this.min = new MeteredInputStream(inputStream);
        return this.min;
    }

    protected synchronized InputStream openURLConnection(DataSetDescriptor dataSetDescriptor, Object object, pwDate pwDate2, pwDate pwDate3, String string) throws DasException {
        String string2 = dataSetDescriptor.getDataSetID();
        String[] stringArray = string2.split("\\?", 2);
        if (stringArray.length > 1) {
            string2 = stringArray[1];
        }
        try {
            String string3 = "dataset=" + URLEncoder.encode(string2, "UTF-8");
            string3 = string3 + "&start_time=" + URLEncoder.encode((object == null ? "" : object + " ") + pwDate2.toString(), "UTF-8");
            string3 = string3 + "&end_time=" + URLEncoder.encode(pwDate3.toString(), "UTF-8");
            if (dataSetDescriptor.isRestrictedAccess() || this.key != null) {
                if (this.key == null) {
                    this.authenticate();
                }
                if (this.key != null) {
                    string3 = string3 + "&key=" + URLEncoder.encode(this.key.toString(), "UTF-8");
                }
            }
            string3 = string3 + "&" + string;
            URL uRL = this.server.getURL(string3);
            pwDie.println(pwDie.VERBOSE, uRL.toString());
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.connect();
            String string4 = uRLConnection.getContentType();
            if (!string4.equalsIgnoreCase("application/octet-stream")) {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
                String string5 = bufferedReader.readLine();
                String string6 = "";
                while (string5 != null) {
                    string6 = string6.concat(string5);
                    string5 = bufferedReader.readLine();
                }
                throw new DasIOException(string6);
            }
            InputStream inputStream = uRL.openStream();
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            bufferedInputStream.mark(Integer.MAX_VALUE);
            String string7 = this.readServerResponse(bufferedInputStream);
            if (string7.equals("")) {
                return bufferedInputStream;
            }
            if (string7.equals("<noDataInInterval/>")) {
                throw new NoDataInIntervalException("no data in interval");
            }
            String string8 = "error";
            if (string7.startsWith("<" + string8 + ">")) {
                int n = string7.indexOf("</" + string8 + ">");
                String string9 = string7.substring(string8.length() + 2, string7.length() - (string8.length() + 3));
                pwDie.println("error=" + string9);
                if (string9.equals("<needKey/>")) {
                    this.authenticate();
                    throw new NoKeyProvidedException("");
                }
                if (string9.equals("<accessDenied/>")) {
                    throw new AccessDeniedException("");
                }
                if (string9.equals("<invalidKey/>")) {
                    throw new NoKeyProvidedException("invalid Key");
                }
                if (string9.equals("<noSuchDataSet/>")) {
                    throw new NoSuchDataSetException("");
                }
                throw new DasServerException("Error response from server: " + string9);
            }
            return bufferedInputStream;
        }
        catch (IOException iOException) {
            throw new DasIOException(iOException.getMessage());
        }
    }

    private String readServerResponse(InputStream inputStream) {
        String string;
        block5: {
            byte[] byArray = new byte[4096];
            int n = -1;
            int n2 = 0;
            try {
                int n3 = inputStream.read(byArray, n2, 4096 - n2);
                String string2 = "das2Response";
                if (n3 < string2.length() + 2) {
                    n2 += n3;
                    n3 = inputStream.read(byArray, n2, 4096 - n2);
                }
                if (new String(byArray, 0, 14, "UTF-8").equals("<" + string2 + ">")) {
                    while (new String(byArray, 0, n2, "UTF-8").indexOf("</" + string2 + ">") == -1 && n2 < 4096) {
                        n3 = inputStream.read(byArray, n2 += n3, 4096 - n2);
                    }
                    int n4 = new String(byArray, 0, n2, "UTF-8").indexOf("</" + string2 + ">");
                    string = new String(byArray, 14, n4 - 14);
                    pwDie.println("das2Response=" + string);
                    inputStream.reset();
                    inputStream.skip(string.length() + 2 * string2.length() + 5);
                    break block5;
                }
                inputStream.reset();
                string = "";
            }
            catch (IOException iOException) {
                string = "";
            }
        }
        return string;
    }

    public void reset() {
    }

    public void authenticate() {
        Authenticator authenticator = new Authenticator(this.server);
        this.key = authenticator.authenticate();
    }
}

