/*
 * Decompiled with CFR 0.152.
 */
package das_proto.client;

import java.io.IOException;
import java.io.InputStream;

public class MeteredInputStream
extends InputStream {
    InputStream in;
    int totalBytesRead;
    long birthTimeMilli;
    long deathTimeMilli;
    double speedLimit;

    public MeteredInputStream(InputStream inputStream) {
        this.in = inputStream;
        this.totalBytesRead = 0;
        this.birthTimeMilli = System.currentTimeMillis();
        this.deathTimeMilli = -1L;
        this.speedLimit = 0.0;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        block3: {
            n3 = this.in.read(byArray, n, n2);
            this.totalBytesRead += n3;
            if (!(this.speedLimit > 0.0)) break block3;
            try {
                while (this.calcTransmitSpeed() > this.speedLimit) {
                    Thread.sleep(50L);
                }
            }
            catch (InterruptedException interruptedException) {}
        }
        return n3;
    }

    public int read() throws IOException {
        int n = this.in.read();
        ++this.totalBytesRead;
        return n;
    }

    public void close() throws IOException {
        this.deathTimeMilli = System.currentTimeMillis();
        this.in.close();
    }

    public double calcTransmitSpeed() {
        long l = this.deathTimeMilli > -1L ? this.deathTimeMilli - this.birthTimeMilli : System.currentTimeMillis() - this.birthTimeMilli;
        if (l == 0L) {
            return Double.POSITIVE_INFINITY;
        }
        return (long)(1000 * this.totalBytesRead) / l;
    }

    public double calcTransmitTime() {
        long l = this.deathTimeMilli > -1L ? this.deathTimeMilli - this.birthTimeMilli : System.currentTimeMillis() - this.birthTimeMilli;
        return (double)l / 1000.0;
    }

    public long totalBytesTransmitted() {
        return this.totalBytesRead;
    }

    public double getSpeedLimit() {
        return this.speedLimit;
    }

    public void setSpeedLimit(double d) {
        this.speedLimit = d;
    }
}

