/*
 * Decompiled with CFR 0.152.
 */
package das_proto.client;

import das_proto.DasException;
import das_proto.client.StandardDataStreamSource;
import das_proto.data.DataSetDescriptor;
import das_proto.data.XTaggedYScanDataSetDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import util.pwDate;

public class FakeStandardDataStreamSource
implements StandardDataStreamSource {
    public InputStream getInputStream(DataSetDescriptor dataSetDescriptor, Object object, pwDate pwDate2, pwDate pwDate3) throws DasException {
        double d = 1.0 / dataSetDescriptor.x_sample_width;
        int n = (int)(pwDate3.subtract(pwDate2) * d);
        if (!(dataSetDescriptor instanceof XTaggedYScanDataSetDescriptor)) {
            throw new IllegalArgumentException("Only XTYSDSD's please!");
        }
        int n2 = ((XTaggedYScanDataSetDescriptor)dataSetDescriptor).y_coordinate.length;
        FakeInputStream fakeInputStream = new FakeInputStream(n, d, n2);
        return fakeInputStream;
    }

    public InputStream getReducedInputStream(XTaggedYScanDataSetDescriptor xTaggedYScanDataSetDescriptor, Object object, pwDate pwDate2, pwDate pwDate3, double d) throws DasException {
        return this.getInputStream(xTaggedYScanDataSetDescriptor, object, pwDate2, pwDate3);
    }

    public void reset() {
    }

    class FakeInputStream
    extends InputStream {
        int nitems;
        long nRecs;
        double recsPerSecond;
        long floatCount;
        long byteCount;
        long recCount;
        long recSize;
        float currentFloat;
        byte[] iCurrentFloat;
        ByteBuffer buff;
        FloatBuffer fbuff;
        double transferRateBps;
        long transferBirthMilli;

        FakeInputStream(long l, double d, int n) {
            this.nitems = n;
            this.nRecs = l;
            this.recsPerSecond = d;
            this.buff = ByteBuffer.allocate(4 * (n + 1));
            this.fbuff = this.buff.asFloatBuffer();
            this.buff.position(this.buff.limit());
            this.floatCount = 0L;
            this.byteCount = 0L;
            this.recCount = 0L;
            this.recSize = (n + 1) * 4;
            this.iCurrentFloat = new byte[4];
            this.transferRateBps = 210000.0;
            this.transferBirthMilli = System.currentTimeMillis();
        }

        public int read() throws IOException {
            try {
                while ((double)(this.byteCount * 1000L / (1L + (System.currentTimeMillis() - this.transferBirthMilli))) > this.transferRateBps) {
                    Thread.sleep(10L);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!this.buff.hasRemaining()) {
                this.buff.position(0);
                this.fbuff.put(0, (float)((double)this.recCount / this.recsPerSecond));
                int n = 1;
                while (n <= this.nitems) {
                    float f = (float)Math.random();
                    this.fbuff.put(n, f);
                    ++n;
                }
                ++this.recCount;
            }
            if (this.recCount > this.nRecs) {
                return -1;
            }
            int n = this.buff.get() & 0xFF;
            ++this.byteCount;
            return n;
        }
    }
}

