/*
 * Decompiled with CFR 0.152.
 */
package das_proto.client;

import das_proto.DasException;
import das_proto.client.DasIOException;
import das_proto.client.StandardDataStreamCache;
import das_proto.client.WebStandardDataStreamSource;
import das_proto.data.DataSetDescriptor;
import das_proto.data.XTaggedYScanDataSetDescriptor;
import das_proto.server.DasServer;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipException;
import java.util.zip.ZipInputStream;
import util.pwDate;
import util.pwDie;

public class CachedWebStandardDataStreamSource
extends WebStandardDataStreamSource {
    private StandardDataStreamCache dataCache = new StandardDataStreamCache();
    private double transferSeconds = 0.0;
    private long bytesTransferred = 0L;
    private long uncompressedBytesTransferred = 0L;
    private long sessionBirthTime;
    private boolean compress;

    public CachedWebStandardDataStreamSource(DasServer dasServer) {
        super(dasServer);
        this.dataCache.setDisabled(true);
        this.sessionBirthTime = System.currentTimeMillis();
        this.compress = false;
    }

    public InputStream getInputStream(DataSetDescriptor dataSetDescriptor, Object object, pwDate pwDate2, pwDate pwDate3) throws DasException {
        InputStream inputStream = null;
        if (this.dataCache.haveStored(dataSetDescriptor, pwDate2, pwDate3, dataSetDescriptor.x_sample_width, object)) {
            pwDie.println("----- Buffer Hit ----\n");
            byte[] byArray = this.dataCache.retrieve(dataSetDescriptor, pwDate2, pwDate3, dataSetDescriptor.x_sample_width, object);
            inputStream = new ByteArrayInputStream(byArray);
        } else {
            pwDie.println("------- Miss --------\n");
            String string = "server=dataset";
            double d = dataSetDescriptor.x_sample_width;
            try {
                inputStream = this.transferURLInputStream(dataSetDescriptor, object, pwDate2, pwDate3, d, string);
            }
            catch (IOException iOException) {
                throw new DasIOException(iOException.getMessage());
            }
        }
        this.selfAdjustParameters();
        return inputStream;
    }

    public InputStream getReducedInputStream(XTaggedYScanDataSetDescriptor xTaggedYScanDataSetDescriptor, Object object, pwDate pwDate2, pwDate pwDate3, double d) throws DasException {
        double d2;
        InputStream inputStream = null;
        double d3 = d2 = d > xTaggedYScanDataSetDescriptor.x_sample_width ? d : xTaggedYScanDataSetDescriptor.x_sample_width;
        if (this.dataCache.haveStored(xTaggedYScanDataSetDescriptor, pwDate2, pwDate3, d2, object)) {
            byte[] byArray = this.dataCache.retrieve(xTaggedYScanDataSetDescriptor, pwDate2, pwDate3, d2, object);
            inputStream = new ByteArrayInputStream(byArray);
        } else {
            double d4 = d;
            double d5 = pwDate3.subtract(pwDate2);
            pwDate pwDate4 = pwDate2;
            pwDate pwDate5 = pwDate3;
            d4 = d4 > xTaggedYScanDataSetDescriptor.x_sample_width ? d4 : xTaggedYScanDataSetDescriptor.x_sample_width;
            String string = "compactdataset";
            String string2 = "server=" + string;
            string2 = string2 + "&resolution=" + d4;
            string2 = string2 + "&nitems=" + (xTaggedYScanDataSetDescriptor.y_coordinate.length + 1);
            double d6 = d4;
            try {
                inputStream = this.transferURLInputStream(xTaggedYScanDataSetDescriptor, object, pwDate4, pwDate5, d6, string2);
            }
            catch (IOException iOException) {
                throw new DasIOException(iOException.getMessage());
            }
        }
        this.selfAdjustParameters();
        return inputStream;
    }

    private InputStream transferURLInputStream(DataSetDescriptor dataSetDescriptor, Object object, pwDate pwDate2, pwDate pwDate3, double d, String string) throws IOException, DasException {
        Object object2;
        if (this.compress) {
            string = string + "&compress=true";
        }
        InputStream inputStream = this.openURLConnection(dataSetDescriptor, object, pwDate2, pwDate3, string);
        long l = System.currentTimeMillis();
        byte[] byArray = dataSetDescriptor.readBytes(inputStream, object, pwDate2, pwDate3);
        this.transferSeconds += (double)((System.currentTimeMillis() - l) / 1000L);
        this.bytesTransferred += (long)byArray.length;
        if (this.compress) {
            object2 = byArray;
            ZipInputStream zipInputStream = new ZipInputStream(new ByteArrayInputStream(byArray));
            try {
                pwDie.println(zipInputStream.getNextEntry().getName());
                byArray = dataSetDescriptor.readBytes(zipInputStream, object, pwDate2, pwDate3);
            }
            catch (ZipException zipException) {
                throw new IOException("Error in compressed stream");
            }
        }
        this.uncompressedBytesTransferred += (long)byArray.length;
        this.dataCache.store(dataSetDescriptor, pwDate2, pwDate3, d, object, byArray);
        object2 = new ByteArrayInputStream(byArray);
        return object2;
    }

    public void printStats() {
        pwDie.println("------ Cached Web Data Source ------");
        pwDie.println("Average Transfer Rate: " + this.getAverageTransferRate() + " bytes/second");
        pwDie.println("Total Transfer Time: " + this.transferSeconds);
        pwDie.println("Total Bytes Transferred: " + this.bytesTransferred);
        pwDie.println("Total Uncompressed Bytes Transferred: " + this.uncompressedBytesTransferred);
        pwDie.println("Average Compression: " + (this.uncompressedBytesTransferred - this.bytesTransferred) * 100L / this.uncompressedBytesTransferred + "%");
        pwDie.println("Compression: " + (this.compress ? "On" : "Off"));
        pwDie.println("------------------------------------");
    }

    private void selfAdjustParameters() {
        this.compress = this.getAverageTransferRate() < 100000.0;
        this.printStats();
    }

    public double getAverageTransferRate() {
        return (double)this.bytesTransferred / this.transferSeconds;
    }

    public void reset() {
        pwDie.println("Resetting buffer");
        this.dataCache.reset();
    }
}

