/*
 * Decompiled with CFR 0.152.
 */
package components;

import das_proto.data.TimeDatum;
import event.TimeRangeSelectionEvent;
import event.TimeRangeSelectionListener;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.EventListenerList;
import util.pwDate;

public class dasTimeRangeSelector
extends JPanel
implements ActionListener,
TimeRangeSelectionListener {
    private pwDate startTime = null;
    private pwDate endTime = null;
    JTextField idStart = null;
    JTextField idStop = null;
    private EventListenerList listenerList = null;
    TimeRangeSelectionEvent lastEventProcessed = null;
    static /* synthetic */ Class class$event$TimeRangeSelectionListener;

    public dasTimeRangeSelector() {
        this.buildComponents();
    }

    private void buildComponents() {
        this.setLayout(new FlowLayout(2));
        JButton jButton = new JButton("<<");
        jButton.addActionListener(this);
        jButton.setActionCommand("previous");
        jButton.setToolTipText("Scan back in time");
        this.add(jButton);
        this.idStart = new JTextField("");
        this.idStart.setSize(18, 1);
        this.idStart.addActionListener(this);
        this.idStart.setActionCommand("startTime");
        this.add(this.idStart);
        this.idStop = new JTextField("");
        this.idStop.setSize(18, 1);
        this.idStop.addActionListener(this);
        this.idStop.setActionCommand("endTime");
        this.add(this.idStop);
        jButton = new JButton(">>");
        jButton.addActionListener(this);
        jButton.setActionCommand("next");
        jButton.setToolTipText("Scan forward in time");
        this.add(jButton);
    }

    public dasTimeRangeSelector(pwDate pwDate2, pwDate pwDate3) {
        this();
        this.setStartTime(pwDate2);
        this.update();
        this.setEndTime(pwDate3);
        this.update();
    }

    public pwDate getStartTime() {
        pwDate pwDate2;
        try {
            pwDate2 = new pwDate(this.idStart.getText());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            pwDate2 = null;
        }
        return pwDate2;
    }

    public pwDate getEndTime() {
        pwDate pwDate2;
        try {
            pwDate2 = new pwDate(this.idStop.getText());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            pwDate2 = null;
        }
        return pwDate2;
    }

    private void update() {
        if (this.startTime != null) {
            this.idStart.setText(this.startTime.toString());
        }
        if (this.endTime != null) {
            this.idStop.setText(this.endTime.toString());
        }
    }

    public void setStartTime(pwDate pwDate2) {
        this.startTime = pwDate2;
        this.endTime = this.getEndTime();
        if (this.endTime != null && this.startTime.compareTo(this.endTime) == 1) {
            this.endTime = new pwDate(this.startTime.toString());
        }
        this.update();
    }

    public void setEndTime(pwDate pwDate2) {
        this.endTime = pwDate2;
        this.startTime = this.getStartTime();
        if (this.startTime != null && this.startTime.compareTo(this.endTime) == 1) {
            this.startTime = new pwDate(this.endTime.toString());
        }
        this.update();
    }

    public boolean isWithin(pwDate pwDate2, pwDate pwDate3) {
        pwDate pwDate4 = this.getStartTime();
        pwDate pwDate5 = this.getEndTime();
        return pwDate2.compareTo(pwDate4) <= 0 && pwDate5.compareTo(pwDate3) <= 0;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("previous")) {
            double d = this.getEndTime().subtract(this.getStartTime());
            this.setStartTime(this.getStartTime().subtract(d));
            this.setEndTime(this.getEndTime().subtract(d));
            this.fireTimeRangeSelectionListenerTimeRangeSelected(new TimeRangeSelectionEvent(this, TimeDatum.create(this.startTime), TimeDatum.create(this.endTime)));
        } else if (string.equals("next")) {
            double d = this.getEndTime().subtract(this.getStartTime());
            this.setStartTime(this.getStartTime().add(d));
            this.setEndTime(this.getEndTime().add(d));
            this.fireTimeRangeSelectionListenerTimeRangeSelected(new TimeRangeSelectionEvent(this, TimeDatum.create(this.startTime), TimeDatum.create(this.endTime)));
        } else if (string.equals("startTime")) {
            this.setStartTime(this.getStartTime());
            this.fireTimeRangeSelectionListenerTimeRangeSelected(new TimeRangeSelectionEvent(this, TimeDatum.create(this.startTime), TimeDatum.create(this.endTime)));
        } else if (string.equals("endTime")) {
            this.setEndTime(this.getEndTime());
            this.fireTimeRangeSelectionListenerTimeRangeSelected(new TimeRangeSelectionEvent(this, TimeDatum.create(this.startTime), TimeDatum.create(this.endTime)));
        }
    }

    public void TimeRangeSelected(TimeRangeSelectionEvent timeRangeSelectionEvent) {
        if (!timeRangeSelectionEvent.equals(this.lastEventProcessed)) {
            this.lastEventProcessed = timeRangeSelectionEvent;
            this.setStartTime(pwDate.create(timeRangeSelectionEvent.getStartTime()));
            this.setEndTime(pwDate.create(timeRangeSelectionEvent.getEndTime()));
            this.fireTimeRangeSelectionListenerTimeRangeSelected(timeRangeSelectionEvent);
        }
    }

    public synchronized void addTimeRangeSelectionListener(TimeRangeSelectionListener timeRangeSelectionListener) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.add(class$event$TimeRangeSelectionListener == null ? (class$event$TimeRangeSelectionListener = dasTimeRangeSelector.class$("event.TimeRangeSelectionListener")) : class$event$TimeRangeSelectionListener, timeRangeSelectionListener);
    }

    public synchronized void removeTimeRangeSelectionListener(TimeRangeSelectionListener timeRangeSelectionListener) {
        this.listenerList.remove(class$event$TimeRangeSelectionListener == null ? (class$event$TimeRangeSelectionListener = dasTimeRangeSelector.class$("event.TimeRangeSelectionListener")) : class$event$TimeRangeSelectionListener, timeRangeSelectionListener);
    }

    private void fireTimeRangeSelectionListenerTimeRangeSelected(TimeRangeSelectionEvent timeRangeSelectionEvent) {
        if (this.listenerList == null) {
            return;
        }
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$event$TimeRangeSelectionListener == null ? dasTimeRangeSelector.class$("event.TimeRangeSelectionListener") : class$event$TimeRangeSelectionListener)) {
                ((TimeRangeSelectionListener)objectArray[n + 1]).TimeRangeSelected(timeRangeSelectionEvent);
            }
            n -= 2;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

