/*
 * Decompiled with CFR 0.152.
 */
package components;

import das_proto.data.DataSet;
import das_proto.data.Datum;
import das_proto.data.XMultiYDataSet;
import das_proto.data.XTaggedYScanDataSet;
import das_proto.data.XTaggedYScanDataSetConsumer;
import event.DataPointSelectionEvent;
import event.DataPointSelectionListener;
import graph.pwAxis;
import graph.pwCanvas;
import graph.pwColumn;
import graph.pwPlot;
import graph.pwRow;
import graph.pwSymbolPlot;
import graph.pwZAxisPlot;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class VerticalSpectrogramSlicer
extends pwSymbolPlot
implements DataPointSelectionListener {
    private JFrame popupWindow;
    private Datum yValue;
    private int lastTagIndex = 1;
    private long eventBirthMilli;

    private VerticalSpectrogramSlicer(pwAxis pwAxis2, pwAxis pwAxis3, pwRow pwRow2, pwColumn pwColumn2) {
        super((XMultiYDataSet)null, pwAxis2, pwAxis3, pwRow2, pwColumn2);
    }

    public static VerticalSpectrogramSlicer createSlicer(pwPlot pwPlot2, XTaggedYScanDataSetConsumer xTaggedYScanDataSetConsumer, pwRow pwRow2, pwColumn pwColumn2) {
        pwAxis pwAxis2 = pwPlot2.getYAxis();
        pwAxis pwAxis3 = xTaggedYScanDataSetConsumer.getZAxis();
        pwAxis pwAxis4 = pwAxis2.createAttachedAxis(pwRow2, pwColumn2, 2);
        pwAxis pwAxis5 = pwAxis3.createAttachedAxis(pwRow2, pwColumn2, 3);
        return new VerticalSpectrogramSlicer(pwAxis4, pwAxis5, pwRow2, pwColumn2);
    }

    public static VerticalSpectrogramSlicer createPopupSlicer(pwZAxisPlot pwZAxisPlot2, int n, int n2) {
        return VerticalSpectrogramSlicer.createPopupSlicer((pwPlot)((Object)pwZAxisPlot2), pwZAxisPlot2, n, n2);
    }

    public static VerticalSpectrogramSlicer createPopupSlicer(pwPlot pwPlot2, XTaggedYScanDataSetConsumer xTaggedYScanDataSetConsumer, int n, int n2) {
        pwCanvas pwCanvas2 = new pwCanvas(n, n2);
        pwRow pwRow2 = new pwRow(pwCanvas2, 0.1, 0.9);
        pwColumn pwColumn2 = new pwColumn(pwCanvas2, 0.1, 0.9);
        final VerticalSpectrogramSlicer verticalSpectrogramSlicer = VerticalSpectrogramSlicer.createSlicer(pwPlot2, xTaggedYScanDataSetConsumer, pwRow2, pwColumn2);
        pwCanvas2.add(verticalSpectrogramSlicer);
        pwCanvas2.add(verticalSpectrogramSlicer.getXAxis());
        pwCanvas2.add(verticalSpectrogramSlicer.getYAxis());
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        BoxLayout boxLayout = new BoxLayout(jPanel2, 0);
        JButton jButton = new JButton("Hide Window");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                verticalSpectrogramSlicer.popupWindow.setVisible(false);
            }
        });
        jPanel2.setLayout(boxLayout);
        jPanel2.add(Box.createHorizontalGlue());
        jPanel2.add(jButton);
        jPanel.add((Component)pwCanvas2, "Center");
        jPanel.add((Component)jPanel2, "South");
        verticalSpectrogramSlicer.popupWindow = new JFrame("Vertical Slicer");
        verticalSpectrogramSlicer.popupWindow.setDefaultCloseOperation(1);
        verticalSpectrogramSlicer.popupWindow.setContentPane(jPanel);
        verticalSpectrogramSlicer.popupWindow.pack();
        return verticalSpectrogramSlicer;
    }

    protected void drawContent(Graphics2D graphics2D) {
        long l = System.currentTimeMillis() - this.eventBirthMilli;
        super.drawContent(graphics2D);
        int n = (int)this.getXAxis().transform(this.yValue);
        pwRow pwRow2 = this.getRow();
        int n2 = (int)pwRow2.getDMinimum();
        int n3 = (int)pwRow2.getDMaximum();
        graphics2D.drawLine(n + 3, n2, n, n2 + 3);
        graphics2D.drawLine(n - 3, n2, n, n2 + 3);
        graphics2D.drawLine(n + 3, n3, n, n3 - 3);
        graphics2D.drawLine(n - 3, n3, n, n3 - 3);
        l = System.currentTimeMillis() - this.eventBirthMilli;
    }

    public void DataPointSelected(DataPointSelectionEvent dataPointSelectionEvent) {
        long[] lArray = new long[]{0L, 0L, 0L, 0L};
        lArray[0] = System.currentTimeMillis() - dataPointSelectionEvent.birthMilli;
        DataSet dataSet = dataPointSelectionEvent.getDataSet();
        if (dataSet == null || !(dataSet instanceof XTaggedYScanDataSet)) {
            return;
        }
        XTaggedYScanDataSet xTaggedYScanDataSet = (XTaggedYScanDataSet)dataSet;
        double[] dArray = new double[xTaggedYScanDataSet.y_coordinate.length];
        System.arraycopy(xTaggedYScanDataSet.y_coordinate, 0, dArray, 0, xTaggedYScanDataSet.y_coordinate.length);
        double[] dArray2 = new double[xTaggedYScanDataSet.y_coordinate.length];
        Datum datum = dataPointSelectionEvent.getX();
        this.setTitle("x: " + datum);
        if (xTaggedYScanDataSet.getXUnits() != datum.getUnits()) {
            datum.convertTo(xTaggedYScanDataSet.getXUnits());
        }
        double d = Double.MAX_VALUE;
        lArray[1] = System.currentTimeMillis() - dataPointSelectionEvent.birthMilli;
        int n = 0;
        int n2 = 0;
        while (n2 < xTaggedYScanDataSet.data.length) {
            double d2 = Math.abs(datum.getValue() - xTaggedYScanDataSet.data[n2].x);
            if (d2 < d) {
                d = d2;
                n = n2;
            }
            ++n2;
        }
        int n3 = 0;
        while (n3 < dArray2.length) {
            dArray2[n3] = xTaggedYScanDataSet.data[n].z[n3];
            ++n3;
        }
        this.yValue = dataPointSelectionEvent.getY();
        lArray[2] = System.currentTimeMillis() - dataPointSelectionEvent.birthMilli;
        this.addData(XMultiYDataSet.create(dArray, xTaggedYScanDataSet.getYUnits(), dArray2, xTaggedYScanDataSet.getZUnits()));
        if (this.popupWindow != null && !this.popupWindow.isVisible()) {
            this.popupWindow.setVisible(true);
        } else {
            this.repaint();
        }
        lArray[3] = System.currentTimeMillis() - dataPointSelectionEvent.birthMilli;
        this.eventBirthMilli = dataPointSelectionEvent.birthMilli;
    }
}

