/*
 * Decompiled with CFR 0.152.
 */
package components;

import das_proto.data.DataSet;
import das_proto.data.Datum;
import das_proto.data.XMultiYDataSet;
import das_proto.data.XTaggedYScan;
import das_proto.data.XTaggedYScanDataSet;
import das_proto.data.XTaggedYScanDataSetConsumer;
import event.DataRangeSelectionEvent;
import event.DataRangeSelectionListener;
import graph.pwAxis;
import graph.pwCanvas;
import graph.pwColumn;
import graph.pwPlot;
import graph.pwRow;
import graph.pwSymbolPlot;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class VerticalSpectrogramAverager
extends pwSymbolPlot
implements DataRangeSelectionListener {
    private JFrame popupWindow;
    private Datum yValue;

    private VerticalSpectrogramAverager(pwAxis pwAxis2, pwAxis pwAxis3, pwRow pwRow2, pwColumn pwColumn2) {
        super((XMultiYDataSet)null, pwAxis2, pwAxis3, pwRow2, pwColumn2);
    }

    public static VerticalSpectrogramAverager createAverager(pwPlot pwPlot2, XTaggedYScanDataSetConsumer xTaggedYScanDataSetConsumer, pwRow pwRow2, pwColumn pwColumn2) {
        pwAxis pwAxis2 = pwPlot2.getYAxis();
        pwAxis pwAxis3 = pwAxis2.createAttachedAxis(pwRow2, pwColumn2, 2);
        pwAxis pwAxis4 = xTaggedYScanDataSetConsumer.getZAxis().createAttachedAxis(pwRow2, pwColumn2, 3);
        return new VerticalSpectrogramAverager(pwAxis3, pwAxis4, pwRow2, pwColumn2);
    }

    public static VerticalSpectrogramAverager createPopupAverager(pwPlot pwPlot2, XTaggedYScanDataSetConsumer xTaggedYScanDataSetConsumer, int n, int n2) {
        pwCanvas pwCanvas2 = new pwCanvas(n, n2);
        pwRow pwRow2 = new pwRow(pwCanvas2, 0.1, 0.9);
        pwColumn pwColumn2 = new pwColumn(pwCanvas2, 0.1, 0.9);
        final VerticalSpectrogramAverager verticalSpectrogramAverager = VerticalSpectrogramAverager.createAverager(pwPlot2, xTaggedYScanDataSetConsumer, pwRow2, pwColumn2);
        pwCanvas2.add(verticalSpectrogramAverager);
        pwCanvas2.add(verticalSpectrogramAverager.getXAxis());
        pwCanvas2.add(verticalSpectrogramAverager.getYAxis());
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        BoxLayout boxLayout = new BoxLayout(jPanel2, 0);
        JButton jButton = new JButton("Hide Window");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                verticalSpectrogramAverager.popupWindow.setVisible(false);
            }
        });
        jPanel2.setLayout(boxLayout);
        jPanel2.add(Box.createHorizontalGlue());
        jPanel2.add(jButton);
        jPanel.add((Component)pwCanvas2, "Center");
        jPanel.add((Component)jPanel2, "South");
        verticalSpectrogramAverager.popupWindow = new JFrame("Vertical Averager");
        verticalSpectrogramAverager.popupWindow.setDefaultCloseOperation(1);
        verticalSpectrogramAverager.popupWindow.setContentPane(jPanel);
        verticalSpectrogramAverager.popupWindow.pack();
        return verticalSpectrogramAverager;
    }

    protected void drawContent(Graphics2D graphics2D) {
        super.drawContent(graphics2D);
    }

    public void DataRangeSelected(DataRangeSelectionEvent dataRangeSelectionEvent) {
        int n;
        DataSet dataSet = dataRangeSelectionEvent.getDataSet();
        if (dataSet == null || !(dataSet instanceof XTaggedYScanDataSet)) {
            return;
        }
        XTaggedYScanDataSet xTaggedYScanDataSet = (XTaggedYScanDataSet)dataSet;
        double[] dArray = new double[xTaggedYScanDataSet.y_coordinate.length];
        System.arraycopy(xTaggedYScanDataSet.y_coordinate, 0, dArray, 0, xTaggedYScanDataSet.y_coordinate.length);
        double[] dArray2 = new double[xTaggedYScanDataSet.y_coordinate.length];
        double[] dArray3 = new double[xTaggedYScanDataSet.y_coordinate.length];
        Datum datum = dataRangeSelectionEvent.getMinimum();
        Datum datum2 = dataRangeSelectionEvent.getMaximum();
        this.setTitle("" + datum + " - " + datum2);
        if (xTaggedYScanDataSet.getXUnits() != datum.getUnits()) {
            datum.convertTo(xTaggedYScanDataSet.getXUnits());
        }
        if (xTaggedYScanDataSet.getXUnits() != datum2.getUnits()) {
            datum2.convertTo(xTaggedYScanDataSet.getXUnits());
        }
        double d = datum.getValue();
        double d2 = datum2.getValue();
        double d3 = Double.MAX_VALUE;
        boolean bl = false;
        XTaggedYScan[] xTaggedYScanArray = xTaggedYScanDataSet.getWeights();
        int n2 = 0;
        while (n2 < xTaggedYScanDataSet.data.length) {
            if (d < xTaggedYScanDataSet.data[n2].x && xTaggedYScanDataSet.data[n2].x < d2) {
                n = 0;
                while (n < dArray2.length) {
                    int n3 = n;
                    dArray2[n3] = dArray2[n3] + (double)(xTaggedYScanDataSet.data[n2].z[n] * xTaggedYScanArray[n2].z[n]);
                    int n4 = n;
                    dArray3[n4] = dArray3[n4] + (double)xTaggedYScanArray[n2].z[n];
                    ++n;
                }
            }
            ++n2;
        }
        n = 0;
        while (n < dArray2.length) {
            if (dArray3[n] > 0.0) {
                int n5 = n;
                dArray2[n5] = dArray2[n5] / dArray3[n];
            } else {
                dArray2[n] = -1.0E31;
            }
            ++n;
        }
        XMultiYDataSet xMultiYDataSet = XMultiYDataSet.create(dArray, xTaggedYScanDataSet.getYUnits(), dArray2, xTaggedYScanDataSet.getZUnits());
        xMultiYDataSet.y_fill = -1.0E31;
        this.addData(xMultiYDataSet);
        if (this.popupWindow != null && !this.popupWindow.isVisible()) {
            this.popupWindow.setVisible(true);
        } else {
            this.repaint();
        }
    }
}

