/*
 * Decompiled with CFR 0.152.
 */
package components;

import das_proto.data.XMultiYDataSetDescriptor;
import das_proto.data.XTaggedYScanDataSetDescriptor;
import graph.SpectrogramRenderer;
import graph.SymbolLineRenderer;
import graph.dnd.TransferableCanvas;
import graph.dnd.TransferableCanvasComponent;
import graph.dnd.TransferableRenderer;
import graph.pwAxis;
import graph.pwCanvas;
import graph.pwColorBar;
import graph.pwPlot;
import graph.pwTimeAxis;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.image.BufferedImage;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import xml.FormButton;
import xml.FormCheckBox;
import xml.FormChoice;
import xml.FormList;
import xml.FormPanel;
import xml.FormRadioButton;
import xml.FormRadioButtonGroup;
import xml.FormTab;
import xml.FormText;
import xml.FormTextField;
import xml.FormWindow;
import xml.TransferableFormComponent;

public class Toolbox
extends JTabbedPane {
    private static final int FORM_TAB = 0;
    private static final int FORM_WINDOW = 1;
    private static final int FORM_PANEL = 2;
    private static final int FORM_TEXT = 3;
    private static final int FORM_TEXTFIELD = 4;
    private static final int FORM_BUTTON = 5;
    private static final int FORM_CHECKBOX = 6;
    private static final int FORM_RADIOBUTTONGROUP = 7;
    private static final int FORM_RADIOBUTTON = 8;
    private static final int FORM_CHOICE = 9;
    private static final int FORM_LIST = 10;
    private static final int GRAPH_CANVAS = 0;
    private static final int GRAPH_PLOT = 1;
    private static final int GRAPH_AXIS = 2;
    private static final int GRAPH_TIME_AXIS = 3;
    private static final int GRAPH_COLORBAR = 4;
    private static final int GRAPH_SPECTROGRAM_RENDERER = 5;
    private static final int GRAPH_LINEPLOT_RENDERER = 6;
    private static final int GRAPH_SPECTROGRAM_PLOT = 7;
    private Icon[] formIcons;
    private Icon[] graphIcons;
    private static final Cursor DRAG_CURSOR = new Cursor(12);

    public Toolbox() {
        this.initIcons();
        this.initFormBox();
        this.initGraphBox();
    }

    private void initIcons() {
        this.formIcons = new Icon[12];
        this.formIcons[0] = Toolbox.createStringIcon("Form");
        this.formIcons[1] = new ImageIcon(this.getClass().getResource("/images/toolbox/window.gif"));
        this.formIcons[2] = new ImageIcon(this.getClass().getResource("/images/toolbox/panel.png"));
        this.formIcons[3] = new ImageIcon(this.getClass().getResource("/images/toolbox/text.png"));
        this.formIcons[4] = new ImageIcon(this.getClass().getResource("/images/toolbox/textfield.png"));
        this.formIcons[5] = new ImageIcon(this.getClass().getResource("/images/toolbox/button.png"));
        this.formIcons[6] = new ImageIcon(this.getClass().getResource("/images/toolbox/checkbox.png"));
        this.formIcons[7] = new ImageIcon(this.getClass().getResource("/images/toolbox/buttongroup.png"));
        this.formIcons[8] = new ImageIcon(this.getClass().getResource("/images/toolbox/radiobutton.png"));
        this.formIcons[9] = new ImageIcon(this.getClass().getResource("/images/toolbox/choice.png"));
        this.formIcons[10] = Toolbox.createStringIcon("List");
        this.graphIcons = new Icon[8];
        this.graphIcons[0] = new ImageIcon(this.getClass().getResource("/images/toolbox/canvas.png"));
        this.graphIcons[1] = Toolbox.createStringIcon("Plot");
        this.graphIcons[2] = new ImageIcon(this.getClass().getResource("/images/toolbox/axis.png"));
        this.graphIcons[3] = new ImageIcon(this.getClass().getResource("/images/toolbox/taxis.png"));
        this.graphIcons[4] = new ImageIcon(this.getClass().getResource("/images/toolbox/colorbar.png"));
        this.graphIcons[5] = new ImageIcon(this.getClass().getResource("/images/toolbox/spectrogram.png"));
        this.graphIcons[6] = new ImageIcon(this.getClass().getResource("/images/toolbox/line.png"));
        this.graphIcons[7] = new ImageIcon(this.getClass().getResource("/images/toolbox/spectrogram_plot.png"));
    }

    private void initFormBox() {
        JList jList = new JList();
        jList.setModel(new AbstractListModel(){

            public int getSize() {
                return 11;
            }

            public Object getElementAt(int n) {
                switch (n) {
                    case 0: {
                        return Toolbox.this.formIcons[0];
                    }
                    case 1: {
                        return Toolbox.this.formIcons[1];
                    }
                    case 2: {
                        return Toolbox.this.formIcons[2];
                    }
                    case 3: {
                        return Toolbox.this.formIcons[3];
                    }
                    case 4: {
                        return Toolbox.this.formIcons[4];
                    }
                    case 5: {
                        return Toolbox.this.formIcons[5];
                    }
                    case 6: {
                        return Toolbox.this.formIcons[6];
                    }
                    case 7: {
                        return Toolbox.this.formIcons[7];
                    }
                    case 8: {
                        return Toolbox.this.formIcons[8];
                    }
                    case 9: {
                        return Toolbox.this.formIcons[9];
                    }
                    case 10: {
                        return Toolbox.this.formIcons[10];
                    }
                }
                throw new RuntimeException(Integer.toString(n));
            }
        });
        jList.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        jList.setTransferHandler(null);
        DragSource dragSource = DragSource.getDefaultDragSource();
        dragSource.createDefaultDragGestureRecognizer(jList, 1, new ToolboxDragGestureListener());
        jList.setLayoutOrientation(2);
        jList.setVisibleRowCount(2);
        this.add("Form", jList);
    }

    private void initGraphBox() {
        JList jList = new JList();
        jList.setModel(new AbstractListModel(){

            public int getSize() {
                return Toolbox.this.graphIcons.length;
            }

            public Object getElementAt(int n) {
                return Toolbox.this.graphIcons[n];
            }
        });
        jList.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        jList.setTransferHandler(null);
        DragSource dragSource = DragSource.getDefaultDragSource();
        dragSource.createDefaultDragGestureRecognizer(jList, 1, new ToolboxDragGestureListener());
        jList.setLayoutOrientation(2);
        jList.setVisibleRowCount(2);
        this.add("Graph", jList);
    }

    private Transferable createTransferable(Icon icon) {
        if (icon.equals(this.formIcons[0])) {
            return new TransferableFormComponent(new FormTab(null, "label"));
        }
        if (icon.equals(this.formIcons[1])) {
            return new TransferableFormComponent(new FormWindow(null, "title", 640, 480));
        }
        if (icon.equals(this.formIcons[2])) {
            return new TransferableFormComponent(new FormPanel());
        }
        if (icon.equals(this.formIcons[3])) {
            return new TransferableFormComponent(new FormText());
        }
        if (icon.equals(this.formIcons[4])) {
            return new TransferableFormComponent(new FormTextField(null));
        }
        if (icon.equals(this.formIcons[5])) {
            return new TransferableFormComponent(new FormButton(null, "label"));
        }
        if (icon.equals(this.formIcons[6])) {
            return new TransferableFormComponent(new FormCheckBox(null, "label"));
        }
        if (icon.equals(this.formIcons[7])) {
            return new TransferableFormComponent(new FormRadioButtonGroup());
        }
        if (icon.equals(this.formIcons[8])) {
            return new TransferableFormComponent(new FormRadioButton(null, "label"));
        }
        if (icon.equals(this.formIcons[9])) {
            return new TransferableFormComponent(new FormChoice(null));
        }
        if (icon.equals(this.formIcons[10])) {
            return new TransferableFormComponent(new FormList(null));
        }
        if (icon.equals(this.graphIcons[0])) {
            return new TransferableCanvas(pwCanvas.createFormCanvas(null, 640, 480));
        }
        if (icon.equals(this.graphIcons[1])) {
            return new TransferableCanvasComponent(pwPlot.createNamedPlot(null));
        }
        if (icon.equals(this.graphIcons[2])) {
            return new TransferableCanvasComponent(pwAxis.createNamedAxis(null));
        }
        if (icon.equals(this.graphIcons[3])) {
            return new TransferableCanvasComponent(pwTimeAxis.createNamedTimeAxis(null));
        }
        if (icon.equals(this.graphIcons[5])) {
            pwColorBar pwColorBar2 = pwColorBar.createNamedColorBar(null);
            return new TransferableRenderer(new SpectrogramRenderer((XTaggedYScanDataSetDescriptor)null, pwColorBar2));
        }
        if (icon.equals(this.graphIcons[6])) {
            return new TransferableRenderer(new SymbolLineRenderer((XMultiYDataSetDescriptor)null));
        }
        if (icon.equals(this.graphIcons[7])) {
            pwPlot pwPlot2 = pwPlot.createNamedPlot(null);
            pwColorBar pwColorBar3 = pwColorBar.createNamedColorBar(pwPlot2.getName() + "_colorbar");
            SpectrogramRenderer spectrogramRenderer = new SpectrogramRenderer((XTaggedYScanDataSetDescriptor)null, pwColorBar3);
            pwPlot2.addRenderer(spectrogramRenderer);
            return new TransferableCanvasComponent(pwPlot2);
        }
        throw new RuntimeException();
    }

    public static Icon createStringIcon(String string) {
        Font font = new Font("MonoSpace", 0, 8);
        FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(font);
        int n = fontMetrics.stringWidth(string);
        int n2 = fontMetrics.getHeight();
        int n3 = fontMetrics.getAscent();
        BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
        Graphics graphics = bufferedImage.getGraphics();
        graphics.setColor(Color.BLACK);
        graphics.setFont(font);
        graphics.drawString(string, 0, n3);
        graphics.dispose();
        return new ImageIcon(bufferedImage);
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        jFrame.getContentPane().add((Component)new Toolbox(), "Center");
        jFrame.getContentPane().add((Component)new JTextArea(10, 10), "West");
        jFrame.pack();
        jFrame.setDefaultCloseOperation(3);
        jFrame.setVisible(true);
    }

    private class ToolboxDragGestureListener
    implements DragGestureListener,
    DragSourceListener {
        private ToolboxDragGestureListener() {
        }

        public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
            JList jList = (JList)dragGestureEvent.getComponent();
            Icon icon = (Icon)jList.getSelectedValue();
            Transferable transferable = Toolbox.this.createTransferable(icon);
            dragGestureEvent.startDrag(DRAG_CURSOR, transferable, this);
        }

        public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
        }

        public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
        }

        public void dragExit(DragSourceEvent dragSourceEvent) {
        }

        public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
        }

        public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
        }
    }
}

