/*
 * Decompiled with CFR 0.152.
 */
package components;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.border.BevelBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultEditorKit;

public class TextEditor
extends JFrame
implements DocumentListener {
    private JFileChooser fileChooser = new JFileChooser();
    private File currentFile = new File(this.fileChooser.getCurrentDirectory(), "untitled.xml");
    private boolean needsSaved = false;
    private boolean isNewFile = true;
    private static boolean standalone = false;
    private JLabel lineNumberLabel;
    private JTextArea contentArea;
    private JLabel columnNumberLabel;
    private JLabel columnLabel;
    private JMenuItem saveAsItem;

    public TextEditor() {
        this.initComponents();
    }

    private void initComponents() {
        JToolBar jToolBar = new JToolBar();
        JScrollPane jScrollPane = new JScrollPane();
        this.contentArea = new JTextArea();
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JLabel jLabel = new JLabel();
        this.lineNumberLabel = new JLabel();
        JPanel jPanel3 = new JPanel();
        this.columnLabel = new JLabel();
        this.columnNumberLabel = new JLabel();
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu();
        JMenuItem jMenuItem = new JMenuItem();
        JMenuItem jMenuItem2 = new JMenuItem();
        JSeparator jSeparator = new JSeparator();
        JMenuItem jMenuItem3 = new JMenuItem();
        this.saveAsItem = new JMenuItem();
        JSeparator jSeparator2 = new JSeparator();
        JMenuItem jMenuItem4 = new JMenuItem();
        JMenu jMenu2 = new JMenu();
        JMenuItem jMenuItem5 = new JMenuItem();
        JMenuItem jMenuItem6 = new JMenuItem();
        JMenuItem jMenuItem7 = new JMenuItem();
        this.setDefaultCloseOperation(0);
        this.setTitle("untitled.xml");
        this.setFont(new Font("", 0, 10));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                TextEditor.this.exitForm(windowEvent);
            }
        });
        jToolBar.setFloatable(false);
        jToolBar.setRollover(true);
        this.getContentPane().add((Component)jToolBar, "North");
        jScrollPane.setHorizontalScrollBarPolicy(32);
        jScrollPane.setVerticalScrollBarPolicy(22);
        jScrollPane.setViewportBorder(new BevelBorder(1));
        this.contentArea.setFont(new Font("Monospaced", 0, 12));
        this.contentArea.setTabSize(4);
        this.contentArea.setText("<?xml version=\"1.0\"?>\n");
        this.contentArea.setMargin(new Insets(5, 5, 5, 5));
        this.contentArea.getDocument().addDocumentListener(this);
        this.contentArea.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent caretEvent) {
                TextEditor.this.contentAreaCaretUpdate(caretEvent);
            }
        });
        jScrollPane.setViewportView(this.contentArea);
        this.getContentPane().add((Component)jScrollPane, "Center");
        jPanel.setLayout(new FlowLayout(0, 0, 0));
        jPanel2.setBorder(new BevelBorder(1));
        jLabel.setText("Line :");
        jPanel2.add(jLabel);
        this.lineNumberLabel.setText("0");
        jPanel2.add(this.lineNumberLabel);
        jPanel.add(jPanel2);
        jPanel3.setBorder(new BevelBorder(1));
        this.columnLabel.setText("Column: ");
        jPanel3.add(this.columnLabel);
        this.columnNumberLabel.setText("0");
        jPanel3.add(this.columnNumberLabel);
        jPanel.add(jPanel3);
        this.getContentPane().add((Component)jPanel, "South");
        jMenu.setMnemonic('f');
        jMenu.setText("File");
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        jMenuItem.setText("New");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TextEditor.this.newItemActionPerformed(actionEvent);
            }
        });
        jMenu.add(jMenuItem);
        jMenuItem2.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        jMenuItem2.setText("Open");
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TextEditor.this.openItemActionPerformed(actionEvent);
            }
        });
        jMenu.add(jMenuItem2);
        jMenu.add(jSeparator);
        jMenuItem3.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        jMenuItem3.setText("Save");
        jMenuItem3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TextEditor.this.saveItemActionPerformed(actionEvent);
            }
        });
        jMenu.add(jMenuItem3);
        this.saveAsItem.setAccelerator(KeyStroke.getKeyStroke(65, 2));
        this.saveAsItem.setText("Save As...");
        this.saveAsItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TextEditor.this.saveAsItemActionPerformed(actionEvent);
            }
        });
        jMenu.add(this.saveAsItem);
        jMenu.add(jSeparator2);
        jMenuItem4.setAccelerator(KeyStroke.getKeyStroke(115, 0));
        jMenuItem4.setText("Exit");
        jMenuItem4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TextEditor.this.exitMenuItemActionPerformed(actionEvent);
            }
        });
        jMenu.add(jMenuItem4);
        jMenuBar.add(jMenu);
        jMenu2.setMnemonic('e');
        jMenu2.setText("Edit");
        jMenuItem5.setAction(new DefaultEditorKit.CutAction());
        jMenu2.add(jMenuItem5);
        jMenuItem6.setAction(new DefaultEditorKit.CopyAction());
        jMenu2.add(jMenuItem6);
        jMenuItem7.setAction(new DefaultEditorKit.PasteAction());
        jMenu2.add(jMenuItem7);
        jMenuBar.add(jMenu2);
        this.setJMenuBar(jMenuBar);
        this.pack();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setSize(new Dimension(640, 478));
        this.setLocation((dimension.width - 640) / 2, (dimension.height - 478) / 2);
    }

    private void contentAreaCaretUpdate(CaretEvent caretEvent) {
        try {
            this.lineNumberLabel.setText(Integer.toString(this.contentArea.getLineOfOffset(caretEvent.getDot())));
            this.columnNumberLabel.setText(Integer.toString(caretEvent.getDot() - this.contentArea.getLineStartOffset(this.contentArea.getLineOfOffset(caretEvent.getDot()))));
        }
        catch (BadLocationException badLocationException) {}
    }

    private void saveAsItemActionPerformed(ActionEvent actionEvent) {
        this.saveFile(true);
    }

    private void saveItemActionPerformed(ActionEvent actionEvent) {
        this.saveFile(this.isNewFile);
    }

    private void openItemActionPerformed(ActionEvent actionEvent) {
        block3: {
            if (this.needsSaved()) {
                return;
            }
            int n = this.fileChooser.showOpenDialog(this);
            if (n != 0) break block3;
            try {
                File file = this.fileChooser.getSelectedFile();
                InputStreamReader inputStreamReader = new InputStreamReader(new FileInputStream(file));
                char[] cArray = new char[(int)file.length()];
                int n2 = inputStreamReader.read(cArray);
                this.contentArea.setText(new String(cArray, 0, n2));
                this.isNewFile = false;
                this.needsSaved = false;
                this.currentFile = file;
            }
            catch (IOException iOException) {
                Object[] objectArray = new Object[]{"Error loading file", iOException.getMessage()};
                JOptionPane.showMessageDialog(this, objectArray, "ERROR", 0);
            }
        }
    }

    private void newItemActionPerformed(ActionEvent actionEvent) {
        if (this.needsSaved()) {
            return;
        }
        this.currentFile = new File(this.currentFile.getParentFile(), "untitled.xml");
        this.setTitle("untitled.xml");
        this.contentArea.setText("<?xml version=\"1.0\"?>\n");
        this.needsSaved = false;
        this.isNewFile = true;
    }

    private void exitMenuItemActionPerformed(ActionEvent actionEvent) {
        this.exit();
    }

    private void exitForm(WindowEvent windowEvent) {
        this.exit();
    }

    public boolean needsSaved() {
        if (this.needsSaved) {
            Object[] objectArray = new Object[]{"You have unsaved changes.", "Would you like to save your changes now?"};
            int n = JOptionPane.showConfirmDialog(this, objectArray, "Unsaved changes", 1);
            if (n == 2) {
                return true;
            }
            if (n == 0) {
                this.saveFile(this.isNewFile);
            }
        }
        return false;
    }

    public void exit() {
        if (this.needsSaved()) {
            return;
        }
        if (standalone) {
            this.setVisible(false);
            System.exit(0);
        } else {
            this.setVisible(false);
        }
    }

    public void saveFile(boolean bl) {
        if (bl) {
            int n = this.fileChooser.showSaveDialog(this);
            if (n == 0) {
                this.currentFile = this.fileChooser.getSelectedFile();
            } else {
                return;
            }
        }
        try {
            PrintWriter printWriter = new PrintWriter(new FileOutputStream(this.currentFile));
            String string = this.contentArea.getText();
            String[] stringArray = string.split("\n");
            int n = 0;
            while (n < stringArray.length) {
                printWriter.println(stringArray[n]);
                ++n;
            }
            printWriter.close();
            this.needsSaved = false;
            this.setTitle(this.currentFile.getName());
        }
        catch (IOException iOException) {
            Object[] objectArray = new Object[]{"There was an error saving the file", iOException.getMessage()};
            JOptionPane.showMessageDialog(this, objectArray, "ERROR WRITING FILE", 0);
        }
    }

    public static void main(String[] stringArray) {
        standalone = true;
        new TextEditor().show();
    }

    public Reader getReader() {
        return new StringReader(this.contentArea.getText());
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        String string = this.getTitle();
        if (!string.endsWith(" (needs saved)")) {
            this.setTitle(string + " (needs saved)");
        }
        this.needsSaved = true;
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        String string = this.getTitle();
        if (!string.endsWith(" (needs saved)")) {
            this.setTitle(string + " (needs saved)");
        }
        this.needsSaved = true;
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        String string = this.getTitle();
        if (!string.endsWith(" (needs saved)")) {
            this.setTitle(string + " (needs saved)");
        }
        this.needsSaved = true;
    }

    public String getContent() {
        return this.contentArea.getText();
    }

    public void setContent(String string) {
        this.contentArea.setText(string);
    }

    public void loadFromURL(URL uRL) {
        block5: {
            try {
                if (this.needsSaved()) {
                    return;
                }
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream()));
                String string = "";
                String string2 = bufferedReader.readLine();
                while (string2 != null) {
                    string = string + string2 + "\n";
                    string2 = bufferedReader.readLine();
                }
                this.contentArea.setText(string);
                String string3 = uRL.getProtocol();
                if (string3.startsWith("file")) {
                    this.currentFile = new File(uRL.getPath());
                    this.setTitle(this.currentFile.getName());
                    this.needsSaved = false;
                    this.isNewFile = false;
                    break block5;
                }
                this.setTitle("untitled.xml (needs saved)");
                this.needsSaved = true;
                this.isNewFile = true;
            }
            catch (IOException iOException) {}
        }
    }
}

