/*
 * Decompiled with CFR 0.152.
 */
package components;

import das_proto.data.Datum;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.BeanInfo;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.EventListenerList;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DateFormatter;
import javax.swing.text.DocumentFilter;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import util.DasExceptionHandler;
import util.pwDate;
import xml.CommandBlockEditor;
import xml.OptionListEditor;

public class PropertyEditor
extends JPanel {
    private static DecimalFormat expFormat = new DecimalFormat("0.#######E0");
    private static Map enumerationMap = new HashMap();
    PropertyTable table;
    JButton closeButton;
    JDialog dialog;
    boolean globalHasChanged;
    private OptionListEditor optionListEditor;
    private CommandBlockEditor commandBlockEditor;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$awt$Window;
    static /* synthetic */ Class array$Lxml$ListOption;
    static /* synthetic */ Class class$xml$CommandBlock;
    static /* synthetic */ Class class$javax$swing$event$TableModelListener;

    private static Object[] getEnumerationList(Class clazz) {
        Object[] objectArray = (Object[])enumerationMap.get(clazz);
        if (objectArray != null) {
            return objectArray;
        }
        Field[] fieldArray = clazz.getFields();
        int n = 0;
        int n2 = 0;
        while (n2 < fieldArray.length) {
            if (fieldArray[n2].getType() == clazz && Modifier.isStatic(fieldArray[n2].getModifiers())) {
                ++n;
            }
            ++n2;
        }
        objectArray = new Object[n];
        int n3 = 0;
        int n4 = 0;
        while (n4 < fieldArray.length) {
            if (fieldArray[n4].getType() == clazz && Modifier.isStatic(fieldArray[n4].getModifiers())) {
                try {
                    objectArray[n3] = fieldArray[n4].get(null);
                    ++n3;
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
            ++n4;
        }
        enumerationMap.put(clazz, objectArray);
        return objectArray;
    }

    public PropertyEditor(Editable editable) {
        super(new BorderLayout());
        PropertyTreeTableModel propertyTreeTableModel = new PropertyTreeTableModel(editable);
        this.table = new PropertyTable(propertyTreeTableModel);
        this.add((Component)new JScrollPane(this.table, 20, 30), "Center");
        this.initButtonPanel();
        PropertyValueCellRenderer propertyValueCellRenderer = new PropertyValueCellRenderer();
        PropertyTreeRenderer propertyTreeRenderer = this.getPropertyTreeTableModel().getRenderer();
        PropertyCellEditor propertyCellEditor = new PropertyCellEditor(propertyTreeRenderer);
        Component component = propertyValueCellRenderer.getTableCellRendererComponent(null, "XXX", false, false, 0, 0);
        this.table.setRowHeight(component.getPreferredSize().height);
        propertyTreeRenderer.setRowHeight(component.getPreferredSize().height);
        propertyTreeRenderer.setCellRenderer(propertyValueCellRenderer);
        ((JComponent)((Object)propertyTreeRenderer.getCellRenderer())).setOpaque(false);
        this.table.getColumnModel().getColumn(0).setCellRenderer(propertyTreeRenderer);
        this.table.getColumnModel().getColumn(1).setCellRenderer(propertyValueCellRenderer);
        this.table.setDefaultEditor(class$java$lang$Object == null ? (class$java$lang$Object = PropertyEditor.class$("java.lang.Object")) : class$java$lang$Object, propertyCellEditor);
        this.table.addMouseListener(new PropertyTableMouseListener());
    }

    private void initButtonPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(2));
        final JButton jButton = new JButton("Apply Changes");
        this.closeButton = new JButton("Dismiss");
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getSource() == jButton) {
                    PropertyEditor.this.globalApplyChanges();
                } else if (actionEvent.getSource() == PropertyEditor.this.closeButton) {
                    PropertyEditor.this.dismissDialog();
                }
            }
        };
        jButton.addActionListener(actionListener);
        this.closeButton.addActionListener(actionListener);
        jPanel.add(jButton);
        jPanel.add(this.closeButton);
        this.add((Component)jPanel, "South");
    }

    private void globalApplyChanges() {
        ((PropertyTreeNode)this.getPropertyTreeTableModel().getRoot()).flushChanges();
        this.globalHasChanged = false;
    }

    private void dismissDialog() {
        if (this.globalHasChanged) {
            String[] stringArray = new String[]{"You have unsaved changes", "Would you like to apply them?"};
            int n = JOptionPane.showConfirmDialog(this, stringArray, "", 1, 3);
            if (n == 2) {
                return;
            }
            if (n == 0) {
                this.globalApplyChanges();
            }
        }
        this.dialog.setVisible(false);
        this.dialog.dispose();
    }

    public void showDialog(Component component) {
        if (this.dialog == null) {
            Container container;
            Container container2 = component == null ? null : (container = SwingUtilities.getAncestorOfClass(class$java$awt$Window == null ? (class$java$awt$Window = PropertyEditor.class$("java.awt.Window")) : class$java$awt$Window, component));
            this.dialog = container instanceof JFrame ? new JDialog((JFrame)container) : (container instanceof JDialog ? new JDialog((JDialog)container) : new JDialog());
            this.dialog.setDefaultCloseOperation(0);
            this.dialog.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    PropertyEditor.this.dismissDialog();
                }
            });
            this.dialog.setContentPane(this);
            this.dialog.pack();
        }
        if (component != null) {
            this.dialog.setLocationRelativeTo(component);
        }
        this.dialog.setVisible(true);
    }

    public void doLayout() {
        if (SwingUtilities.isDescendingFrom(this, this.dialog)) {
            this.closeButton.setVisible(true);
        } else {
            this.closeButton.setVisible(false);
        }
        super.doLayout();
    }

    private PropertyTreeTableModel getPropertyTreeTableModel() {
        return (PropertyTreeTableModel)this.table.getModel();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        String[] stringArray = new String[]{"beans", "sun.beans.infos"};
        Introspector.setBeanInfoSearchPath(stringArray);
    }

    private static class FloatingPointDocumentFilter
    extends DocumentFilter {
        private FloatingPointDocumentFilter() {
        }

        public void insertString(DocumentFilter.FilterBypass filterBypass, int n, String string, AttributeSet attributeSet) throws BadLocationException {
            if (string.length() == 1) {
                if (string.charAt(0) == '-') {
                    String string2 = filterBypass.getDocument().getText(0, filterBypass.getDocument().getLength());
                    int n2 = Math.max(string2.indexOf(101), string2.indexOf(69));
                    if (string2.length() == 0) {
                        super.insertString(filterBypass, 0, string, attributeSet);
                    } else if (n2 < 0 || n <= n2) {
                        if (string2.charAt(0) == '-') {
                            super.remove(filterBypass, 0, 1);
                        } else {
                            super.insertString(filterBypass, 0, string, attributeSet);
                        }
                    } else if (string2.length() == n2 + 1) {
                        super.insertString(filterBypass, n2 + 1, string, attributeSet);
                    } else if (string2.charAt(n2 + 1) == '-') {
                        super.remove(filterBypass, n2 + 1, 1);
                    } else {
                        super.insertString(filterBypass, n2 + 1, string, attributeSet);
                    }
                } else if (string.charAt(0) == '.') {
                    String string3 = filterBypass.getDocument().getText(0, filterBypass.getDocument().getLength());
                    int n3 = string3.indexOf(46);
                    if (n <= n3) {
                        super.replace(filterBypass, n, n3 - n + 1, string, attributeSet);
                    } else if (n3 < 0) {
                        super.insertString(filterBypass, n, string, attributeSet);
                    }
                } else if (string.charAt(0) == 'e' || string.charAt(0) == 'E') {
                    String string4 = filterBypass.getDocument().getText(0, filterBypass.getDocument().getLength());
                    int n4 = Math.max(string4.indexOf(101), string4.indexOf(69));
                    if (n <= n4) {
                        super.replace(filterBypass, n, n4 - n + 1, string, attributeSet);
                    } else if (n4 < 0) {
                        super.insertString(filterBypass, n, string, attributeSet);
                    }
                } else if (Character.isDigit(string.charAt(0))) {
                    super.insertString(filterBypass, n, string, attributeSet);
                }
            }
        }

        public void replace(DocumentFilter.FilterBypass filterBypass, int n, int n2, String string, AttributeSet attributeSet) throws BadLocationException {
            this.remove(filterBypass, n, n2);
            this.insertString(filterBypass, n, string, attributeSet);
        }
    }

    protected static class FloatingPointFormatter
    extends JFormattedTextField.AbstractFormatter {
        protected FloatingPointFormatter() {
        }

        public Object stringToValue(String string) throws ParseException {
            try {
                Double d = new Double(string);
                if (d == Double.NEGATIVE_INFINITY || d == Double.POSITIVE_INFINITY || d == Double.NaN) {
                    throw new ParseException("+/-infinity and NaN are not allowed", 0);
                }
                return d;
            }
            catch (NumberFormatException numberFormatException) {
                throw new ParseException(numberFormatException.getMessage(), 0);
            }
        }

        public String valueToString(Object object) throws ParseException {
            if (object instanceof Number) {
                double d = ((Number)object).doubleValue();
                if (d < 0.01 || d > 99.0) {
                    return expFormat.format(d);
                }
                return object.toString();
            }
            throw new ParseException("value must be of type Number", 0);
        }

        protected DocumentFilter getDocumentFilter() {
            return new FloatingPointDocumentFilter();
        }
    }

    private class PropertyTreeNode
    implements TreeNode {
        protected PropertyTreeNode parent;
        protected PropertyDescriptor property;
        boolean hasChanged;
        protected Object value;
        protected boolean valueInitialized = false;
        protected List childList;
        protected TreeModelListener listener;
        protected boolean isIndexed = false;
        protected int index;

        PropertyTreeNode(Editable editable) {
            this.parent = null;
            this.property = null;
            this.listener = null;
            this.value = editable;
            this.valueInitialized = true;
        }

        PropertyTreeNode(PropertyDescriptor propertyDescriptor, PropertyTreeNode propertyTreeNode, TreeModelListener treeModelListener) {
            this.parent = propertyTreeNode;
            this.property = propertyDescriptor;
            this.listener = treeModelListener;
        }

        PropertyTreeNode(PropertyDescriptor propertyDescriptor, PropertyTreeNode propertyTreeNode, int n, TreeModelListener treeModelListener) {
            this.parent = propertyTreeNode;
            this.property = propertyDescriptor;
            this.listener = treeModelListener;
            this.index = n;
            this.isIndexed = true;
        }

        private void maybeInitialize() {
            if (this.childList != null || this.isLeaf()) {
                return;
            }
            if (this.property instanceof IndexedPropertyDescriptor && !this.isIndexed) {
                int n = ((Object[])this.value).length;
                this.childList = new ArrayList(n);
                int n2 = 0;
                while (n2 < n) {
                    this.childList.add(new PropertyTreeNode(this.property, this, n2, this.listener));
                    ++n2;
                }
            } else {
                try {
                    BeanInfo beanInfo = Introspector.getBeanInfo(this.getValue().getClass());
                    PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
                    this.childList = new ArrayList(propertyDescriptorArray.length);
                    int n = 0;
                    while (n < propertyDescriptorArray.length) {
                        this.childList.add(new PropertyTreeNode(propertyDescriptorArray[n], this, this.listener));
                        ++n;
                    }
                }
                catch (IntrospectionException introspectionException) {
                    throw new RuntimeException(introspectionException);
                }
            }
        }

        public Class getPropertyType() {
            if (this.property == null) {
                return Void.TYPE;
            }
            if (this.isIndexed) {
                return ((IndexedPropertyDescriptor)this.property).getIndexedPropertyType();
            }
            return this.property.getPropertyType();
        }

        public PropertyDescriptor getPropertyDescriptor() {
            return this.property;
        }

        public Object getValue() {
            if (this.valueInitialized) {
                return this.value;
            }
            try {
                if (this.isIndexed) {
                    IndexedPropertyDescriptor indexedPropertyDescriptor = (IndexedPropertyDescriptor)this.property;
                    PropertyTreeNode propertyTreeNode = (PropertyTreeNode)this.parent.getParent();
                    Method method = indexedPropertyDescriptor.getIndexedReadMethod();
                    Object[] objectArray = new Object[]{new Integer(this.index)};
                    this.value = method.invoke(propertyTreeNode.getValue(), objectArray);
                } else {
                    Method method = this.property.getReadMethod();
                    Object object = this.parent.getValue();
                    this.value = method.invoke(object, null);
                }
                this.valueInitialized = true;
                return this.value;
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new RuntimeException(illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new RuntimeException(invocationTargetException);
            }
        }

        public java.util.Enumeration children() {
            this.maybeInitialize();
            return Collections.enumeration(this.childList);
        }

        public boolean getAllowsChildren() {
            return this.isLeaf();
        }

        public TreeNode getChildAt(int n) {
            this.maybeInitialize();
            if (this.isLeaf()) {
                return null;
            }
            return (PropertyTreeNode)this.childList.get(n);
        }

        public int getChildCount() {
            this.maybeInitialize();
            if (this.isLeaf()) {
                return 0;
            }
            return this.childList.size();
        }

        public int getIndex(TreeNode treeNode) {
            if (this.isLeaf()) {
                return -1;
            }
            int n = 0;
            while (n < this.childList.size()) {
                if (treeNode == this.childList.get(n)) {
                    return n;
                }
                ++n;
            }
            return -1;
        }

        public TreeNode getParent() {
            return this.parent;
        }

        public boolean isLeaf() {
            if (this.value == null) {
                return true;
            }
            if (this.value instanceof Editable) {
                return false;
            }
            return !(this.property instanceof IndexedPropertyDescriptor) || this.isIndexed;
        }

        public String getName() {
            if (this.property == null) {
                return "root";
            }
            if (this.isIndexed) {
                return this.property.getName() + "[" + this.index + "]";
            }
            return this.property.getName();
        }

        public void setValue(Object object) {
            this.value = object;
            this.hasChanged = true;
            PropertyEditor.this.globalHasChanged = true;
        }

        public void flushChanges() {
            try {
                Object[] objectArray;
                Object object;
                if (this.hasChanged) {
                    Object object2;
                    if (this.parent == null) {
                        return;
                    }
                    if (this.isIndexed) {
                        object = (PropertyTreeNode)this.parent.getParent();
                        objectArray = (IndexedPropertyDescriptor)this.property;
                        object2 = ((PropertyTreeNode)object).getValue();
                        Object[] objectArray2 = new Object[]{new Integer(this.index), this.value};
                        Method method = objectArray.getIndexedWriteMethod();
                        if (method == null) {
                            DasExceptionHandler.handle(new NullPointerException("<html><body>'" + this.getName() + "' is a read-only property<br>" + "Ed, find a better way to handle this!!!"));
                        }
                        method.invoke(object2, objectArray2);
                    } else {
                        object = this.parent.getValue();
                        objectArray = new Object[]{this.value};
                        object2 = this.property.getWriteMethod();
                        if (object2 == null) {
                            DasExceptionHandler.handle(new NullPointerException("<html><body>'" + this.getName() + "' is a read-only property<br>" + "Ed, find a better way to handle this!!!"));
                        }
                        ((Method)object2).invoke(object, objectArray);
                    }
                }
                if (this.childList != null) {
                    object = this.childList.iterator();
                    while (object.hasNext()) {
                        objectArray = (PropertyTreeNode)object.next();
                        objectArray.flushChanges();
                    }
                }
                this.childList = null;
                this.maybeInitialize();
                this.hasChanged = false;
                this.fireTreeStructureChanged();
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new RuntimeException(illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.getTargetException().printStackTrace();
                DasExceptionHandler.handle((Exception)invocationTargetException.getTargetException());
            }
        }

        public String toString() {
            return this.getName();
        }

        public boolean isEditable() {
            return this.property.getWriteMethod() != null;
        }

        private void setTreeModelListener(TreeModelListener treeModelListener) {
            this.listener = treeModelListener;
        }

        private void fireTreeStructureChanged() {
            TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, this.getPath());
            this.listener.treeStructureChanged(treeModelEvent);
        }

        Object[] getPath() {
            return this.getPath(1);
        }

        Object[] getPath(int n) {
            if (this.parent == null) {
                Object[] objectArray = new Object[n];
                objectArray[0] = this;
                return objectArray;
            }
            Object[] objectArray = this.parent.getPath(n + 1);
            objectArray[objectArray.length - n] = this;
            return objectArray;
        }
    }

    static class PropertyTreeRenderer
    extends JTree
    implements TableCellRenderer {
        private JTable table;
        private int visibleRow;

        public PropertyTreeRenderer(PropertyTreeTableModel propertyTreeTableModel) {
            super(propertyTreeTableModel);
            this.setRootVisible(false);
            this.setShowsRootHandles(true);
        }

        public void setBounds(int n, int n2, int n3, int n4) {
            super.setBounds(n, 0, n3, this.table.getRowHeight() * this.table.getRowCount());
        }

        public void paint(Graphics graphics) {
            graphics.translate(0, -this.visibleRow * this.getHeight() / this.getRowCount());
            super.paint(graphics);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.table = jTable;
            this.visibleRow = n;
            this.setBackground(bl ? Color.gray : Color.lightGray);
            return this;
        }
    }

    protected class PropertyCellEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener {
        private JFormattedTextField integerField = new JFormattedTextField(new Integer(0));
        private JFormattedTextField floatField;
        private JTextField stringField;
        private JFormattedTextField dateField;
        private JCheckBox booleanBox;
        private JButton editableButton;
        private JComboBox enumerationChoice;
        private static final int INTEGER = 1;
        private static final int LONG = 2;
        private static final int FLOAT = 4;
        private static final int DOUBLE = 8;
        private static final int STRING = 16;
        private static final int DATE = 32;
        private static final int BOOLEAN = 64;
        private static final int EDITABLE = 128;
        private static final int ENUMERATION = 256;
        private static final int DATUM = 512;
        private int editorState = 1;
        private Object currentValue = null;
        private int currentRow;
        private JTree propertyTree;

        public PropertyCellEditor(JTree jTree) {
            this.integerField.addActionListener(this);
            FloatingPointFormatter floatingPointFormatter = new FloatingPointFormatter();
            this.floatField = new JFormattedTextField(floatingPointFormatter);
            this.floatField.addActionListener(this);
            this.stringField = new JTextField();
            this.stringField.addActionListener(this);
            this.booleanBox = new JCheckBox();
            this.booleanBox.addActionListener(this);
            DateFormatter dateFormatter = new DateFormatter(new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS"));
            this.dateField = new JFormattedTextField(dateFormatter);
            this.dateField.addActionListener(this);
            this.editableButton = new JButton("Edit");
            this.editableButton.addActionListener(this);
            this.propertyTree = jTree;
            this.enumerationChoice = new JComboBox();
            this.enumerationChoice.setRenderer(new PropertyValueCellRenderer());
            this.enumerationChoice.addActionListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.fireEditingStopped();
            if (actionEvent.getSource() instanceof JButton) {
                if (this.propertyTree.isCollapsed(this.currentRow)) {
                    this.propertyTree.expandRow(this.currentRow);
                } else {
                    this.propertyTree.collapseRow(this.currentRow);
                }
            }
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.currentValue = object;
            this.currentRow = n;
            PropertyTreeTableModel propertyTreeTableModel = (PropertyTreeTableModel)jTable.getModel();
            if (!propertyTreeTableModel.isLeaf(n)) {
                this.editorState = 128;
                return this.editableButton;
            }
            if (object instanceof Enumeration) {
                this.editorState = 256;
                Object[] objectArray = PropertyEditor.getEnumerationList(object.getClass());
                this.enumerationChoice.setModel(new DefaultComboBoxModel<Object>(objectArray));
                this.enumerationChoice.setSelectedItem(object);
                return this.enumerationChoice;
            }
            if (object instanceof Integer) {
                this.editorState = 1;
                this.integerField.setValue(object);
                return this.integerField;
            }
            if (object instanceof Long) {
                this.editorState = 2;
                this.integerField.setValue(object);
                return this.integerField;
            }
            if (object instanceof Float) {
                this.editorState = 4;
                this.floatField.setValue(object);
                return this.floatField;
            }
            if (object instanceof Double) {
                this.editorState = 8;
                this.floatField.setValue(object);
                return this.floatField;
            }
            if (object instanceof Editable) {
                this.editorState = 128;
                return this.editableButton;
            }
            if (object instanceof Boolean) {
                this.editorState = 64;
                this.booleanBox.setSelected((Boolean)object);
                this.booleanBox.setText(object.toString());
                return this.booleanBox;
            }
            if (object instanceof pwDate) {
                this.editorState = 32;
                this.stringField.setText(object.toString());
                return this.stringField;
            }
            if (object instanceof Datum) {
                this.editorState = 512;
                this.stringField.setText(((Datum)object).format());
                return this.stringField;
            }
            this.editorState = 16;
            this.stringField.setText(object.toString());
            return this.stringField;
        }

        public Object getCellEditorValue() {
            if (this.editorState == 256) {
                return this.enumerationChoice.getSelectedItem();
            }
            if (this.editorState == 1) {
                Object object = this.integerField.getValue();
                if (object instanceof Integer) {
                    return object;
                }
                if (object instanceof Number) {
                    return new Integer(((Number)object).intValue());
                }
                throw new IllegalStateException("Value from textfield is not of type java.lang.Number");
            }
            if (this.editorState == 2) {
                Object object = this.integerField.getValue();
                if (object instanceof Long) {
                    return object;
                }
                if (object instanceof Number) {
                    return new Long(((Number)object).longValue());
                }
                throw new IllegalStateException("Value from textfield is not of type java.lang.Number");
            }
            if (this.editorState == 4) {
                Object object = this.floatField.getValue();
                if (object instanceof Float) {
                    return object;
                }
                if (object instanceof Number) {
                    return new Float(((Number)object).floatValue());
                }
                throw new IllegalStateException("Value from textfield is not of type java.lang.Number");
            }
            if (this.editorState == 8) {
                Object object = this.floatField.getValue();
                if (object instanceof Double) {
                    return object;
                }
                if (object instanceof Number) {
                    return new Double(((Number)object).doubleValue());
                }
                throw new IllegalStateException("Value from textfield is not of type java.lang.Number");
            }
            if (this.editorState == 128) {
                return this.currentValue;
            }
            if (this.editorState == 64) {
                return this.booleanBox.isSelected() ? Boolean.TRUE : Boolean.FALSE;
            }
            if (this.editorState == 32) {
                try {
                    return new pwDate(this.stringField.getText());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    DasExceptionHandler.handle(illegalArgumentException);
                    return this.currentValue;
                }
            }
            if (this.editorState == 512) {
                try {
                    return ((Datum)this.currentValue).parse(this.stringField.getText());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    DasExceptionHandler.handle(illegalArgumentException);
                    return this.currentValue;
                }
            }
            return this.stringField.getText();
        }
    }

    private class PropertyTreeTableModel
    extends DefaultTreeModel
    implements TableModel,
    TreeExpansionListener,
    TreeModelListener {
        PropertyTreeRenderer propertyTree;
        EventListenerList listenerList = new EventListenerList();

        PropertyTreeTableModel(Editable editable) {
            super(null);
            PropertyTreeNode propertyTreeNode = new PropertyTreeNode(editable);
            propertyTreeNode.setTreeModelListener(this);
            this.setRoot(propertyTreeNode);
            this.propertyTree = new PropertyTreeRenderer(this);
            this.propertyTree.addTreeExpansionListener(this);
        }

        public PropertyTreeRenderer getRenderer() {
            return this.propertyTree;
        }

        public int getRowCount() {
            return this.propertyTree.getRowCount();
        }

        public int getColumnCount() {
            return 2;
        }

        public boolean isCellEditable(int n, int n2) {
            PropertyTreeNode propertyTreeNode = (PropertyTreeNode)this.propertyTree.getPathForRow(n).getLastPathComponent();
            return n2 == 1 && propertyTreeNode.isLeaf();
        }

        public String getColumnName(int n) {
            return n == 0 ? "Property" : "Value";
        }

        public Class getColumnClass(int n) {
            return class$java$lang$Object == null ? (class$java$lang$Object = PropertyEditor.class$("java.lang.Object")) : class$java$lang$Object;
        }

        public Object getValueAt(int n, int n2) {
            if (n2 == 0) {
                return this.getPropertyName(n);
            }
            return this.getPropertyValue(n);
        }

        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 0) {
                throw new IllegalArgumentException("Can't edit property names");
            }
            PropertyTreeNode propertyTreeNode = (PropertyTreeNode)this.propertyTree.getPathForRow(n).getLastPathComponent();
            propertyTreeNode.setValue(object);
        }

        public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
            TreePath treePath = treeExpansionEvent.getPath();
            int n = this.propertyTree.getRowForPath(treePath);
            int n2 = this.propertyTree.getModel().getChildCount(treePath.getLastPathComponent());
            this.fireTableRowsDeleted(n + 1, n + n2);
        }

        public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
            TreePath treePath = treeExpansionEvent.getPath();
            int n = this.propertyTree.getRowForPath(treePath);
            int n2 = this.propertyTree.getModel().getChildCount(treePath.getLastPathComponent());
            this.fireTableRowsInserted(n + 1, n + n2);
        }

        public void toggleExpanded(int n) {
            if (this.propertyTree.isCollapsed(n)) {
                this.propertyTree.expandRow(n);
            } else {
                this.propertyTree.collapseRow(n);
            }
        }

        public void addTableModelListener(TableModelListener tableModelListener) {
            this.listenerList.add(class$javax$swing$event$TableModelListener == null ? (class$javax$swing$event$TableModelListener = PropertyEditor.class$("javax.swing.event.TableModelListener")) : class$javax$swing$event$TableModelListener, tableModelListener);
        }

        public void removeTableModelListener(TableModelListener tableModelListener) {
            this.listenerList.remove(class$javax$swing$event$TableModelListener == null ? (class$javax$swing$event$TableModelListener = PropertyEditor.class$("javax.swing.event.TableModelListener")) : class$javax$swing$event$TableModelListener, tableModelListener);
        }

        private void fireTableRowsInserted(int n, int n2) {
            this.fireTableChanged(new TableModelEvent(this, n, n2, -1, 1));
        }

        private void fireTableRowsDeleted(int n, int n2) {
            this.fireTableChanged(new TableModelEvent(this, n, n2, -1, -1));
        }

        private void fireTableChanged(TableModelEvent tableModelEvent) {
            Object[] objectArray = this.listenerList.getListenerList();
            int n = objectArray.length - 2;
            while (n >= 0) {
                if (objectArray[n] == (class$javax$swing$event$TableModelListener == null ? PropertyEditor.class$("javax.swing.event.TableModelListener") : class$javax$swing$event$TableModelListener)) {
                    ((TableModelListener)objectArray[n + 1]).tableChanged(tableModelEvent);
                }
                n -= 2;
            }
        }

        public void treeNodesChanged(TreeModelEvent treeModelEvent) {
            this.fireTreeNodesChanged(this, treeModelEvent.getPath(), treeModelEvent.getChildIndices(), treeModelEvent.getChildren());
        }

        public void treeNodesInserted(TreeModelEvent treeModelEvent) {
            this.fireTreeNodesInserted(this, treeModelEvent.getPath(), treeModelEvent.getChildIndices(), treeModelEvent.getChildren());
        }

        public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
            this.fireTreeNodesRemoved(this, treeModelEvent.getPath(), treeModelEvent.getChildIndices(), treeModelEvent.getChildren());
        }

        public void treeStructureChanged(TreeModelEvent treeModelEvent) {
            this.fireTreeStructureChanged(this, treeModelEvent.getPath(), treeModelEvent.getChildIndices(), treeModelEvent.getChildren());
        }

        public boolean isLeaf(int n) {
            PropertyTreeNode propertyTreeNode = (PropertyTreeNode)this.propertyTree.getPathForRow(n).getLastPathComponent();
            return propertyTreeNode.isLeaf();
        }

        public String getPropertyName(int n) {
            PropertyTreeNode propertyTreeNode = (PropertyTreeNode)this.propertyTree.getPathForRow(n).getLastPathComponent();
            return propertyTreeNode.getName();
        }

        public Object getPropertyValue(int n) {
            PropertyTreeNode propertyTreeNode = (PropertyTreeNode)this.propertyTree.getPathForRow(n).getLastPathComponent();
            return propertyTreeNode.getValue();
        }

        public Class getPropertyType(int n) {
            PropertyTreeNode propertyTreeNode = (PropertyTreeNode)this.propertyTree.getPathForRow(n).getLastPathComponent();
            return propertyTreeNode.getPropertyType();
        }

        public PropertyDescriptor getPropertyDescriptor(int n) {
            PropertyTreeNode propertyTreeNode = (PropertyTreeNode)this.propertyTree.getPathForRow(n).getLastPathComponent();
            return propertyTreeNode.getPropertyDescriptor();
        }
    }

    public static class PropertyValueCellRenderer
    extends JLabel
    implements TableCellRenderer,
    TreeCellRenderer,
    ListCellRenderer {
        JCheckBox booleanRenderer;

        public PropertyValueCellRenderer() {
            super("Label");
            this.setFont(this.getFont().deriveFont(0));
            this.setOpaque(true);
            this.setBorder(new EmptyBorder(5, 5, 5, 5));
            this.booleanRenderer = new JCheckBox();
            this.booleanRenderer.setBorder(new EmptyBorder(5, 5, 5, 5));
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            double d;
            PropertyTreeTableModel propertyTreeTableModel = null;
            if (jTable != null) {
                propertyTreeTableModel = (PropertyTreeTableModel)jTable.getModel();
            }
            if (object instanceof Enumeration) {
                Enumeration enumeration = (Enumeration)object;
                this.setIcon(enumeration.getListIcon());
            } else {
                this.setIcon(null);
            }
            if (object instanceof Boolean) {
                this.booleanRenderer.setSelected((Boolean)object);
                this.booleanRenderer.setText(object.toString());
                this.booleanRenderer.setBackground(bl ? Color.gray : Color.lightGray);
                return this.booleanRenderer;
            }
            if ((object instanceof Double || object instanceof Float) && ((d = ((Number)object).doubleValue()) < 0.01 || d >= 100.0)) {
                object = expFormat.format(d);
            }
            if (propertyTreeTableModel == null) {
                this.setText(object == null ? "null" : (object instanceof Editable ? "Click to expand/collapse" : object.toString()));
            } else {
                this.setText(object == null ? "null" : (propertyTreeTableModel.isLeaf(n) ? object.toString() : "Click to expand/collapse"));
            }
            this.setOpaque(true);
            this.setBackground(bl ? Color.gray : Color.lightGray);
            return this;
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            this.setText(object == null ? "null" : object.toString());
            this.setIcon(null);
            this.setOpaque(false);
            return this;
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (object instanceof Enumeration) {
                Enumeration enumeration = (Enumeration)object;
                this.setIcon(enumeration.getListIcon());
            } else {
                this.setIcon(null);
            }
            this.setText(object.toString());
            this.setOpaque(true);
            this.setBackground(bl ? Color.gray : Color.lightGray);
            return this;
        }
    }

    private class PropertyTable
    extends JTable {
        PropertyTable(PropertyTreeTableModel propertyTreeTableModel) {
            super(propertyTreeTableModel);
        }

        public TableCellEditor getCellEditor(int n, int n2) {
            if (n2 == 0) {
                return super.getCellEditor(n, n2);
            }
            PropertyTreeTableModel propertyTreeTableModel = PropertyEditor.this.getPropertyTreeTableModel();
            Class clazz = propertyTreeTableModel.getPropertyType(n);
            if (clazz.equals(array$Lxml$ListOption == null ? (array$Lxml$ListOption = PropertyEditor.class$("[Lxml.ListOption;")) : array$Lxml$ListOption)) {
                if (PropertyEditor.this.optionListEditor == null) {
                    PropertyEditor.this.optionListEditor = new OptionListEditor();
                }
                return PropertyEditor.this.optionListEditor;
            }
            if (clazz.equals(class$xml$CommandBlock == null ? (class$xml$CommandBlock = PropertyEditor.class$("xml.CommandBlock")) : class$xml$CommandBlock)) {
                if (PropertyEditor.this.commandBlockEditor == null) {
                    PropertyEditor.this.commandBlockEditor = new CommandBlockEditor();
                }
                return PropertyEditor.this.commandBlockEditor;
            }
            return super.getCellEditor(n, n2);
        }
    }

    private class PropertyTableMouseListener
    extends MouseAdapter {
        private PropertyTableMouseListener() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            Point point = mouseEvent.getPoint();
            int n = PropertyEditor.this.table.rowAtPoint(point);
            int n2 = PropertyEditor.this.table.columnAtPoint(point);
            PropertyTreeTableModel propertyTreeTableModel = PropertyEditor.this.getPropertyTreeTableModel();
            if (!propertyTreeTableModel.isLeaf(n)) {
                propertyTreeTableModel.toggleExpanded(n);
            }
        }
    }

    public static interface Enumeration {
        public String toString();

        public Icon getListIcon();
    }

    public static interface Editable {
    }
}

