/*
 * Decompiled with CFR 0.152.
 */
package components;

import das_proto.data.DataSet;
import das_proto.data.Datum;
import das_proto.data.XMultiYDataSet;
import das_proto.data.XTaggedYScanDataSet;
import das_proto.data.XTaggedYScanDataSetConsumer;
import event.DataPointSelectionEvent;
import event.DataPointSelectionListener;
import graph.pwAxis;
import graph.pwCanvas;
import graph.pwColumn;
import graph.pwPlot;
import graph.pwRow;
import graph.pwSymbolPlot;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class HorizontalSpectrogramSlicer
extends pwSymbolPlot
implements DataPointSelectionListener {
    private JFrame popupWindow;
    private Datum xValue;

    private HorizontalSpectrogramSlicer(pwAxis pwAxis2, pwAxis pwAxis3, pwRow pwRow2, pwColumn pwColumn2) {
        super((XMultiYDataSet)null, pwAxis2, pwAxis3, pwRow2, pwColumn2);
    }

    public static HorizontalSpectrogramSlicer createSlicer(pwPlot pwPlot2, XTaggedYScanDataSetConsumer xTaggedYScanDataSetConsumer, pwRow pwRow2, pwColumn pwColumn2) {
        pwAxis pwAxis2 = pwPlot2.getXAxis();
        pwAxis pwAxis3 = pwAxis2.createAttachedAxis(pwRow2, pwColumn2, 2);
        pwAxis pwAxis4 = xTaggedYScanDataSetConsumer.getZAxis().createAttachedAxis(pwRow2, pwColumn2, 3);
        return new HorizontalSpectrogramSlicer(pwAxis3, pwAxis4, pwRow2, pwColumn2);
    }

    public static HorizontalSpectrogramSlicer createPopupSlicer(pwPlot pwPlot2, XTaggedYScanDataSetConsumer xTaggedYScanDataSetConsumer, int n, int n2) {
        pwCanvas pwCanvas2 = new pwCanvas(n, n2);
        pwRow pwRow2 = new pwRow(pwCanvas2, 0.1, 0.9);
        pwColumn pwColumn2 = new pwColumn(pwCanvas2, 0.1, 0.9);
        final HorizontalSpectrogramSlicer horizontalSpectrogramSlicer = HorizontalSpectrogramSlicer.createSlicer(pwPlot2, xTaggedYScanDataSetConsumer, pwRow2, pwColumn2);
        pwCanvas2.add(horizontalSpectrogramSlicer);
        pwCanvas2.add(horizontalSpectrogramSlicer.getXAxis());
        pwCanvas2.add(horizontalSpectrogramSlicer.getYAxis());
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        BoxLayout boxLayout = new BoxLayout(jPanel2, 0);
        JButton jButton = new JButton("Hide Window");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                horizontalSpectrogramSlicer.popupWindow.setVisible(false);
            }
        });
        jPanel2.setLayout(boxLayout);
        jPanel2.add(Box.createHorizontalGlue());
        jPanel2.add(jButton);
        jPanel.add((Component)pwCanvas2, "Center");
        jPanel.add((Component)jPanel2, "South");
        horizontalSpectrogramSlicer.popupWindow = new JFrame("Horizontal Slicer");
        horizontalSpectrogramSlicer.popupWindow.setDefaultCloseOperation(1);
        horizontalSpectrogramSlicer.popupWindow.setContentPane(jPanel);
        horizontalSpectrogramSlicer.popupWindow.pack();
        return horizontalSpectrogramSlicer;
    }

    public void DataPointSelected(DataPointSelectionEvent dataPointSelectionEvent) {
        DataSet dataSet = dataPointSelectionEvent.getDataSet();
        if (dataSet == null || !(dataSet instanceof XTaggedYScanDataSet)) {
            return;
        }
        XTaggedYScanDataSet xTaggedYScanDataSet = (XTaggedYScanDataSet)dataSet;
        double[] dArray = new double[xTaggedYScanDataSet.data.length];
        double[] dArray2 = new double[xTaggedYScanDataSet.data.length];
        Datum datum = dataPointSelectionEvent.getY();
        this.xValue = dataPointSelectionEvent.getX();
        String string = "" + this.xValue;
        if (xTaggedYScanDataSet.getYUnits() != datum.getUnits()) {
            datum = datum.convertTo(xTaggedYScanDataSet.getYUnits());
        }
        double d = Double.MAX_VALUE;
        int n = 0;
        int n2 = 0;
        while (n2 < xTaggedYScanDataSet.y_coordinate.length) {
            double d2 = Math.abs(datum.getValue() - xTaggedYScanDataSet.y_coordinate[n2]);
            if (d2 < d) {
                d = d2;
                n = n2;
            }
            ++n2;
        }
        int n3 = 0;
        while (n3 < dArray.length) {
            dArray[n3] = xTaggedYScanDataSet.data[n3].x;
            ++n3;
        }
        int n4 = 0;
        while (n4 < dArray2.length) {
            dArray2[n4] = xTaggedYScanDataSet.data[n4].z[n];
            ++n4;
        }
        XMultiYDataSet xMultiYDataSet = XMultiYDataSet.create(dArray, xTaggedYScanDataSet.getXUnits(), dArray2, xTaggedYScanDataSet.getZUnits());
        xMultiYDataSet.y_fill = xTaggedYScanDataSet.getZFill();
        this.addData(xMultiYDataSet);
        this.setTitle("x: " + string);
        if (this.popupWindow != null && !this.popupWindow.isVisible()) {
            this.popupWindow.setVisible(true);
        } else {
            this.repaint();
        }
    }

    public void drawContent(Graphics2D graphics2D) {
        super.drawContent(graphics2D);
        int n = (int)this.getXAxis().transform(this.xValue);
        pwRow pwRow2 = this.getRow();
        int n2 = (int)pwRow2.getDMinimum();
        int n3 = (int)pwRow2.getDMaximum();
        graphics2D.drawLine(n + 3, n2, n, n2 + 3);
        graphics2D.drawLine(n - 3, n2, n, n2 + 3);
        graphics2D.drawLine(n + 3, n3, n, n3 - 3);
        graphics2D.drawLine(n - 3, n3, n, n3 - 3);
    }
}

