/*
 * Decompiled with CFR 0.152.
 */
package components;

import das_proto.data.DataRequestor;
import das_proto.data.DataSet;
import event.DasReaderEvent;
import event.DasReaderListener;
import event.ProgressIndicator;
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.WindowEvent;
import java.text.DecimalFormat;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class DasProgressPanel
extends JPanel
implements DasReaderListener,
DataRequestor,
ProgressIndicator {
    private long readerStartedTime;
    private int currentBytes;
    private int totalBytes;
    private DecimalFormat transferRateFormat;
    private JPanel bottomPanel;
    private JLabel kbLabel;
    private JProgressBar progressBar;

    public DasProgressPanel() {
        this.initComponents();
        this.transferRateFormat = new DecimalFormat();
        this.transferRateFormat.setMaximumFractionDigits(2);
        this.totalBytes = -1;
    }

    private void initComponents() {
        JLabel jLabel = new JLabel();
        this.bottomPanel = new JPanel();
        this.progressBar = new JProgressBar();
        this.kbLabel = new JLabel();
        this.setLayout(new GridLayout(0, 1));
        this.setName("progressDialog");
        jLabel.setBackground(new Color(240, 240, 240));
        jLabel.setFont(new Font("Dialog", 1, 18));
        jLabel.setHorizontalAlignment(0);
        jLabel.setText("Loading Data Set");
        jLabel.setOpaque(true);
        this.add(jLabel);
        this.bottomPanel.setLayout(new BoxLayout(this.bottomPanel, 1));
        this.bottomPanel.setBackground(new Color(240, 240, 240));
        this.progressBar.setBackground(new Color(240, 240, 240));
        this.progressBar.setMaximumSize(this.progressBar.getPreferredSize());
        this.progressBar.setMinimumSize(this.progressBar.getPreferredSize());
        this.bottomPanel.add(this.progressBar);
        this.kbLabel.setHorizontalAlignment(0);
        this.kbLabel.setText("0 kb");
        this.kbLabel.setAlignmentX(0.5f);
        this.kbLabel.setMaximumSize(this.progressBar.getPreferredSize());
        this.kbLabel.setMinimumSize(this.progressBar.getPreferredSize());
        this.kbLabel.setPreferredSize(this.progressBar.getPreferredSize());
        this.bottomPanel.add(this.kbLabel);
        this.add(this.bottomPanel);
    }

    private void closeDialog(WindowEvent windowEvent) {
    }

    public void readerUpdate(DasReaderEvent dasReaderEvent) {
        double d = System.currentTimeMillis() - this.readerStartedTime;
        if (d > 400.0) {
            this.setVisible(true);
        } else {
            this.setVisible(false);
        }
        int n = dasReaderEvent.getByteCount() / 1024;
        this.currentBytes = dasReaderEvent.getByteCount();
        if (this.totalBytes > 0) {
            this.progressBar.setValue(n * 100 / (this.totalBytes / 1024));
        } else {
            this.progressBar.setValue(n % 100);
        }
        String string = this.totalBytes > 0 ? "" + n + "/" + this.totalBytes / 1024 + "kb" : "" + n + "kb";
        if (d > 1000.0) {
            double d2 = (double)(dasReaderEvent.getByteCount() / 1024) / (d / 1000.0);
            this.kbLabel.setText(string + " (" + this.transferRateFormat.format(d2) + "kb/s)");
        } else {
            this.kbLabel.setText(string);
        }
        Toolkit.getDefaultToolkit().getSystemEventQueue();
        if (EventQueue.isDispatchThread()) {
            this.paintImmediately(0, 0, this.getWidth(), this.getHeight());
        } else {
            this.repaint();
        }
    }

    public void readerFinished(DasReaderEvent dasReaderEvent) {
        this.setVisible(false);
        this.kbLabel.setText("");
        this.totalBytes = -1;
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
    }

    public void readerStarted(DasReaderEvent dasReaderEvent) {
        this.readerStartedTime = System.currentTimeMillis();
        this.currentBytes = 0;
    }

    public void currentByteCount(int n) {
        if (n == -1) {
            DasReaderEvent dasReaderEvent = new DasReaderEvent(this, 0);
            this.readerStarted(dasReaderEvent);
        } else {
            DasReaderEvent dasReaderEvent = new DasReaderEvent(this, n);
            this.readerUpdate(dasReaderEvent);
        }
    }

    public void exception(Exception exception) {
    }

    public void finished(DataSet dataSet) {
        DasReaderEvent dasReaderEvent = new DasReaderEvent(this, 0);
        this.readerFinished(dasReaderEvent);
    }

    public void totalByteCount(int n) {
        this.totalBytes = n;
    }

    public void finished() {
    }

    public void setTaskProgress(int n) {
        DasReaderEvent dasReaderEvent = new DasReaderEvent(this, n);
        this.readerUpdate(dasReaderEvent);
    }

    public int getTaskProgress() {
        return this.currentBytes;
    }

    public void setTaskSize(int n) {
        this.totalByteCount(n);
    }

    public void started() {
        DasReaderEvent dasReaderEvent = new DasReaderEvent(this, 0);
        this.readerStarted(dasReaderEvent);
    }
}

