/*
 * Decompiled with CFR 0.152.
 */
package components;

import event.DasReaderEvent;
import event.DasReaderListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BoxLayout;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;

public class DasProgressDialog
extends JDialog
implements DasReaderListener {
    private JLabel kbLabel;
    private JProgressBar progressBar;
    private JPanel bottomPanel;

    public DasProgressDialog(Frame frame) {
        super(frame);
        this.initComponents();
    }

    public DasProgressDialog(Dialog dialog) {
        super(dialog);
        this.initComponents();
    }

    public DasProgressDialog() {
        this.initComponents();
    }

    public static DasProgressDialog dialogFor(Component component) {
        Window window = SwingUtilities.getWindowAncestor(component);
        if (window instanceof Dialog) {
            return new DasProgressDialog((Dialog)window);
        }
        if (window instanceof Frame) {
            return new DasProgressDialog((Frame)window);
        }
        return new DasProgressDialog();
    }

    private void initComponents() {
        JLabel jLabel = new JLabel();
        this.bottomPanel = new JPanel();
        this.progressBar = new JProgressBar();
        this.kbLabel = new JLabel();
        this.getContentPane().setLayout(new GridLayout(0, 1));
        this.setDefaultCloseOperation(0);
        this.setTitle("Loading Data Set");
        this.setLocationRelativeTo(this.getOwner());
        this.setName("progressDialog");
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                DasProgressDialog.this.closeDialog(windowEvent);
            }
        });
        jLabel.setBackground(new Color(240, 240, 240));
        jLabel.setFont(new Font("Dialog", 1, 18));
        jLabel.setForeground(Color.darkGray);
        jLabel.setHorizontalAlignment(0);
        jLabel.setText("Loading Data Set");
        this.getContentPane().add(jLabel);
        this.bottomPanel.setLayout(new BoxLayout(this.bottomPanel, 1));
        this.bottomPanel.setBackground(new Color(240, 240, 240));
        this.bottomPanel.setForeground(Color.darkGray);
        this.progressBar.setBackground(new Color(240, 240, 240));
        this.progressBar.setMaximumSize(this.progressBar.getPreferredSize());
        this.progressBar.setMinimumSize(this.progressBar.getPreferredSize());
        this.bottomPanel.add(this.progressBar);
        this.kbLabel.setHorizontalAlignment(0);
        this.kbLabel.setText("0 kb");
        this.kbLabel.setAlignmentX(0.5f);
        this.kbLabel.setMaximumSize(this.progressBar.getPreferredSize());
        this.kbLabel.setMinimumSize(this.progressBar.getPreferredSize());
        this.kbLabel.setPreferredSize(this.progressBar.getPreferredSize());
        this.bottomPanel.add(this.kbLabel);
        this.getContentPane().add(this.bottomPanel);
        this.pack();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setSize(new Dimension(404, 106));
        this.setLocation((dimension.width - 404) / 2, (dimension.height - 106) / 2);
    }

    private void closeDialog(WindowEvent windowEvent) {
    }

    public void readerUpdate(DasReaderEvent dasReaderEvent) {
        if (!this.isVisible()) {
            this.setVisible(true);
        }
        int n = dasReaderEvent.getByteCount();
        int n2 = n / 1024;
        this.progressBar.setValue(n2 % 100);
        this.kbLabel.setText(n2 + " kb");
        JPanel jPanel = (JPanel)this.getContentPane();
        jPanel.paintImmediately(0, 0, jPanel.getWidth(), jPanel.getHeight());
    }

    public void readerFinished(DasReaderEvent dasReaderEvent) {
        this.setVisible(false);
        this.dispose();
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
    }

    public void readerStarted(DasReaderEvent dasReaderEvent) {
    }
}

