/*
 * Decompiled with CFR 0.152.
 */
package beans;

import java.beans.BeanDescriptor;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.beans.SimpleBeanInfo;

public abstract class AccessLevelBeanInfo
extends SimpleBeanInfo {
    private Property[] properties;
    private Class beanClass;
    private static AccessLevel accessLevel;
    private static Object lockObject;

    public static AccessLevel getAccessLevel() {
        return accessLevel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setAccessLevel(AccessLevel accessLevel) {
        Object object = lockObject;
        synchronized (object) {
            AccessLevelBeanInfo.accessLevel = accessLevel;
        }
    }

    public static Object getLock() {
        return lockObject;
    }

    protected AccessLevelBeanInfo(Property[] propertyArray, Class clazz) {
        this.properties = propertyArray;
        this.beanClass = clazz;
    }

    public PropertyDescriptor[] getPropertyDescriptors() {
        Object object = lockObject;
        synchronized (object) {
            try {
                int n = 0;
                int n2 = 0;
                while (n2 < this.properties.length) {
                    if (accessLevel.compareTo(this.properties[n2].getLevel()) <= 0) {
                        ++n;
                    }
                    ++n2;
                }
                PropertyDescriptor[] propertyDescriptorArray = new PropertyDescriptor[n];
                int n3 = 0;
                int n4 = 0;
                while (n4 < this.properties.length) {
                    if (accessLevel.compareTo(this.properties[n4].getLevel()) <= 0) {
                        propertyDescriptorArray[n3] = this.properties[n4].getPropertyDescriptor(this.beanClass);
                        ++n3;
                    }
                    ++n4;
                }
                return propertyDescriptorArray;
            }
            catch (IntrospectionException introspectionException) {
                throw new IllegalStateException(introspectionException.getMessage());
            }
        }
    }

    public BeanDescriptor getBeanDescriptor() {
        return new BeanDescriptor(this.beanClass);
    }

    static {
        lockObject = new Object();
        String string = System.getProperty("edu.uiowa.physics.das.beans.AccessLevelBeanInfo.AccessLevel");
        accessLevel = string == null ? AccessLevel.ALL : (string.equals("ALL") ? AccessLevel.ALL : (string.equals("DASML") ? AccessLevel.DASML : (string.equals("END_USER") ? AccessLevel.END_USER : AccessLevel.ALL)));
    }

    protected static class Property {
        private final String name;
        private final AccessLevel level;
        private final String getter;
        private final String setter;
        private final String igetter;
        private final String isetter;
        private final Class editor;
        private final boolean indexed;

        public Property(String string, AccessLevel accessLevel, String string2, String string3, Class clazz) {
            this.name = string;
            this.level = accessLevel;
            this.getter = string2;
            this.setter = string3;
            this.igetter = null;
            this.isetter = null;
            this.editor = clazz;
            this.indexed = false;
        }

        public Property(String string, AccessLevel accessLevel, String string2, String string3, String string4, String string5, Class clazz) {
            this.name = string;
            this.level = accessLevel;
            this.getter = string2;
            this.setter = string3;
            this.igetter = string4;
            this.isetter = string5;
            this.editor = clazz;
            this.indexed = true;
        }

        public AccessLevel getLevel() {
            return this.level;
        }

        public PropertyDescriptor getPropertyDescriptor(Class clazz) throws IntrospectionException {
            PropertyDescriptor propertyDescriptor = this.indexed ? new IndexedPropertyDescriptor(this.name, clazz, this.getter, this.setter, this.igetter, this.isetter) : new PropertyDescriptor(this.name, clazz, this.getter, this.setter);
            if (this.editor != null) {
                propertyDescriptor.setPropertyEditorClass(this.editor);
            }
            return propertyDescriptor;
        }
    }

    public static class AccessLevel
    implements Comparable {
        public static final AccessLevel ALL = new AccessLevel("ALL", 0);
        public static final AccessLevel DASML = new AccessLevel("DASML", 1000);
        public static final AccessLevel END_USER = new AccessLevel("END_USER", 0x7FFF0000);
        private String str;
        private int order;

        private AccessLevel(String string, int n) {
            this.str = string;
            this.order = n;
        }

        public int compareTo(Object object) {
            return this.order - ((AccessLevel)object).order;
        }

        public String toString() {
            return this.str;
        }
    }
}

