/*
 * Decompiled with CFR 0.152.
 */
package apps.gllpws;

import das_proto.DasException;
import das_proto.client.DasIOException;
import das_proto.client.DataSetDescriptorNotAvailableException;
import das_proto.data.CachedXTaggedYScanDataSetDescriptor;
import das_proto.data.DataSet;
import das_proto.data.DataSetDescriptor;
import das_proto.data.Datum;
import das_proto.data.TimeDatum;
import das_proto.data.Units;
import das_proto.data.XTaggedYScan;
import das_proto.data.XTaggedYScanDataSet;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import util.IDLParser;
import util.pwDate;

public class SummaryDataSetDescriptor
extends CachedXTaggedYScanDataSetDescriptor {
    private static SortedMap E_DATE_MAP;
    private static SortedMap B_DATE_MAP;
    public static pwDate DATA_START;
    private SortedMap dateMap;
    private static final Charset CHARSET;
    private static String errorString;
    private static File tableFileDirectory;
    private static final Hashtable edsdf;
    private static final Hashtable mdsdf;
    static /* synthetic */ Class class$apps$gllpws$SummaryDataSetDescriptor;

    private static void parseTableFile(File file) throws IOException {
        E_DATE_MAP = new TreeMap();
        B_DATE_MAP = new TreeMap();
        FileInputStream fileInputStream = new FileInputStream(file);
        InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, CHARSET);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        String string = bufferedReader.readLine();
        SortedMap sortedMap = null;
        while (string != null) {
            if (string.equals("[ELEC]")) {
                sortedMap = E_DATE_MAP;
            } else if (string.equals("[MAG]")) {
                sortedMap = B_DATE_MAP;
            } else {
                StringTokenizer stringTokenizer = new StringTokenizer(string);
                String string2 = stringTokenizer.nextToken();
                String string3 = stringTokenizer.nextToken();
                pwDate pwDate2 = new pwDate(string2);
                if (DATA_START == null) {
                    DATA_START = pwDate2;
                }
                File file2 = new File(file.getParentFile(), string3);
                sortedMap.put(pwDate2, file2);
            }
            string = bufferedReader.readLine();
        }
    }

    private SummaryDataSetDescriptor(Hashtable hashtable) throws DataSetDescriptorNotAvailableException {
        super(hashtable);
        if (errorString != null) {
            throw new DataSetDescriptorNotAvailableException(errorString);
        }
    }

    public DataSet getDataSet(Object object, pwDate pwDate2, pwDate pwDate3) throws DasException {
        return this.getDataSet(object, pwDate2, pwDate3, 60.0);
    }

    public DataSet getDataSet(Object object, pwDate pwDate2, pwDate pwDate3, double d) throws DasException {
        boolean bl = d > 60.0;
        SortedMap sortedMap = this.dateMap.subMap(pwDate2.subtract(pwDate2.getSecondsSinceMidnight()), pwDate3);
        if (sortedMap.size() == 0) {
            throw new DasIOException("No data in interval");
        }
        XTaggedYScanDataSet xTaggedYScanDataSet = null;
        Iterator iterator = sortedMap.values().iterator();
        while (iterator.hasNext()) {
            File file = (File)iterator.next();
            try {
                XTaggedYScanDataSet xTaggedYScanDataSet2 = this.getDataSetForFile(file);
                if (bl) {
                    xTaggedYScanDataSet2 = xTaggedYScanDataSet2.binAverageX(Datum.create(d, Units.seconds));
                }
                if (xTaggedYScanDataSet == null) {
                    xTaggedYScanDataSet = xTaggedYScanDataSet2;
                    continue;
                }
                xTaggedYScanDataSet = xTaggedYScanDataSet.append(xTaggedYScanDataSet2);
            }
            catch (IOException iOException) {
                DasIOException dasIOException = new DasIOException(iOException.getMessage());
                dasIOException.initCause(iOException);
                throw dasIOException;
            }
        }
        return xTaggedYScanDataSet;
    }

    public static DataSetDescriptor newDataSetDescriptor(Map map) throws DataSetDescriptorNotAvailableException {
        String string = (String)map.get("dataset");
        if ("e".equals(string)) {
            SummaryDataSetDescriptor summaryDataSetDescriptor = new SummaryDataSetDescriptor(edsdf);
            summaryDataSetDescriptor.dateMap = E_DATE_MAP;
            return summaryDataSetDescriptor;
        }
        if ("b".equals(string)) {
            SummaryDataSetDescriptor summaryDataSetDescriptor = new SummaryDataSetDescriptor(mdsdf);
            summaryDataSetDescriptor.dateMap = B_DATE_MAP;
            return summaryDataSetDescriptor;
        }
        throw new DataSetDescriptorNotAvailableException("dataset must be either e or b");
    }

    private XTaggedYScanDataSet getDataSetForFile(File file) throws IOException {
        int n;
        XTaggedYScan[] xTaggedYScanArray;
        Object object;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
        ArrayList<XTaggedYScan[]> arrayList = new ArrayList<XTaggedYScan[]>();
        ArrayList<TimeDatum> arrayList2 = new ArrayList<TimeDatum>();
        String string = bufferedReader.readLine();
        while (string != null) {
            object = new StringTokenizer(string, " \t,");
            arrayList2.add(TimeDatum.create(((StringTokenizer)object).nextToken()));
            xTaggedYScanArray = (XTaggedYScan[])new float[this.y_coordinate.length];
            n = 0;
            while (n < this.y_coordinate.length) {
                xTaggedYScanArray[n] = (XTaggedYScan)Float.parseFloat(((StringTokenizer)object).nextToken());
                ++n;
            }
            arrayList.add(xTaggedYScanArray);
            string = bufferedReader.readLine();
        }
        object = new XTaggedYScan[arrayList2.size()];
        xTaggedYScanArray = new XTaggedYScan[arrayList2.size()];
        n = 0;
        while (n < arrayList2.size()) {
            TimeDatum timeDatum = (TimeDatum)arrayList2.get(n);
            double d = timeDatum.convertTo(Units.us2000).doubleValue();
            float[] fArray = (float[])arrayList.get(n);
            object[n] = new XTaggedYScan(d, fArray);
            float[] fArray2 = new float[this.y_coordinate.length];
            Arrays.fill(fArray2, 1.0f);
            xTaggedYScanArray[n] = new XTaggedYScan(d, fArray2);
            ++n;
        }
        XTaggedYScanDataSet xTaggedYScanDataSet = new XTaggedYScanDataSet(this);
        xTaggedYScanDataSet.x_sample_width = this.x_sample_width;
        xTaggedYScanDataSet.xSampleWidth = this.x_sample_width * 1000000.0;
        xTaggedYScanDataSet.y_coordinate = this.y_coordinate;
        xTaggedYScanDataSet.setZFill(-1.0E32f);
        xTaggedYScanDataSet.data = object;
        xTaggedYScanDataSet.setWeights(xTaggedYScanArray);
        return xTaggedYScanDataSet;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        CHARSET = Charset.forName("ISO-8859-1");
        IDLParser iDLParser = new IDLParser();
        edsdf = new Hashtable();
        edsdf.put("description", "Galileo PWS Summary E-Field Data(averaged and calibrated)");
        edsdf.put("form", "x_tagged_y_scan");
        edsdf.put("x_parameter", "time");
        edsdf.put("x_unit", "s");
        edsdf.put("x_sample_width", new Double(120.0));
        edsdf.put("y_parameter", "frequency");
        edsdf.put("y_unit", "Hz");
        edsdf.put("y_coordinate", iDLParser.parseIDLArray("[ 5.62, 7.50, 10.0, 13.3, 17.8, 23.7, 31.6, 42.2, 56.2, 75.0, 100, 133, 178, 237, 316, 422, 562, 750, 1.00e3, 1.33e3, 1.78e3, 2.37e3, 3.16e3, 4.22e3, 5.62e3, 7.50e3, 10.0e3, 13.3e3, 17.8e3, 23.7e3, 31.6e3, 42.2e3, 56.2e3, 75.0e3, 100e3, 133e3, 178e3, 237e3, 316e3, 422e3, 562e3, 750e3, 1.00e6, 1.33e6, 1.78e6, 2.37e6, 3.16e6, 4.22e6, 5.62e6 ]"));
        edsdf.put("z_parameter", "electric field");
        edsdf.put("z_unit", "V**2/m**2/Hz");
        edsdf.put("z_fill", new Float(-100.0));
        mdsdf = new Hashtable();
        mdsdf.put("description", "Galileo PWS Summary E-Field Data(averaged and calibrated)");
        mdsdf.put("form", "x_tagged_y_scan");
        mdsdf.put("x_parameter", "time");
        mdsdf.put("x_unit", "s");
        mdsdf.put("x_sample_width", new Double(120.0));
        mdsdf.put("y_parameter", "frequency");
        mdsdf.put("y_unit", "Hz");
        mdsdf.put("y_coordinate", iDLParser.parseIDLArray("[ 5.62, 7.50, 10.0, 13.3, 17.8, 23.7, 31.6, 42.2, 56.2, 75.0, 100, 133, 178, 237, 316, 422, 562, 750, 1.00e3, 1.33e3, 1.78e3, 2.37e3, 3.16e3, 4.22e3, 5.62e3, 7.50e3, 10.0e3, 13.3e3, 17.8e3, 23.7e3, 31.6e3, 42.2e3, 56.2e3, 75.0e3 ]"));
        mdsdf.put("z_parameter", "magnetic field");
        mdsdf.put("z_unit", "nT**2/Hz");
        mdsdf.put("z_fill", new Float(-100.0));
        URL uRL = (class$apps$gllpws$SummaryDataSetDescriptor == null ? (class$apps$gllpws$SummaryDataSetDescriptor = SummaryDataSetDescriptor.class$("apps.gllpws.SummaryDataSetDescriptor")) : class$apps$gllpws$SummaryDataSetDescriptor).getResource("SummaryDataSetDescriptor.class");
        String string = uRL.toExternalForm();
        Pattern pattern = Pattern.compile("jar:file:(.*)/.+?\\.(jar|JAR)!.*");
        Matcher matcher = pattern.matcher(string);
        if (!matcher.matches()) {
            errorString = "Could not resolve jar file location from URL: " + string;
        } else {
            String string2 = matcher.group(1);
            try {
                string2 = URLDecoder.decode(string2, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new RuntimeException(unsupportedEncodingException);
            }
            tableFileDirectory = new File(string2);
            File file = new File(tableFileDirectory, "SUMMARY.TXT");
            if (!file.exists()) {
                errorString = "No such file: " + file.getAbsolutePath();
            } else {
                try {
                    SummaryDataSetDescriptor.parseTableFile(file);
                }
                catch (IOException iOException) {
                    DATA_START = new pwDate("1995-12-03");
                    errorString = iOException.toString();
                }
            }
        }
    }
}

