/*
 * Decompiled with CFR 0.152.
 */
package apps.gllpws;

import apps.gllpws.SummaryDataSetDescriptor;
import components.dasTimeRangeSelector;
import das_proto.DasException;
import das_proto.data.Datum;
import das_proto.data.Units;
import event.TimeRangeSelectionEvent;
import event.TimeRangeSelectionListener;
import graph.DataRange;
import graph.SpectrogramRenderer;
import graph.TimeRangeLabel;
import graph.pwAxis;
import graph.pwCanvas;
import graph.pwColorBar;
import graph.pwColumn;
import graph.pwPlot;
import graph.pwRow;
import graph.pwTimeAxis;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.beans.PropertyChangeListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import util.DasExceptionHandler;
import util.Splash;
import util.pwDate;
import util.pwDie;

public class GLLPWS
extends JPanel
implements ActionListener,
TimeRangeSelectionListener {
    private pwCanvas canvas;
    pwTimeAxis bta;
    private dasTimeRangeSelector ts = null;
    private TimeRangeLabel timeRangeLabel;

    public GLLPWS() {
        super(new BorderLayout());
        pwDate pwDate2 = SummaryDataSetDescriptor.DATA_START;
        pwDate pwDate3 = SummaryDataSetDescriptor.DATA_START.add(86400.0);
        this.canvas = new pwCanvas(800, 600);
        this.add((Component)this.canvas, "Center");
        pwRow pwRow2 = new pwRow(this.canvas, 0.1, 0.546);
        pwRow pwRow3 = new pwRow(this.canvas, 0.616, 0.85);
        pwColumn pwColumn2 = new pwColumn(this.canvas, 0.12, 0.77);
        pwColumn pwColumn3 = new pwColumn(this.canvas, 0.8, 0.83);
        pwTimeAxis pwTimeAxis2 = new pwTimeAxis(pwDate2, pwDate3, pwRow2, pwColumn2, 2);
        pwTimeAxis2.setTickLabelsVisible(false);
        pwAxis pwAxis2 = new pwAxis(Datum.create(6.52, Units.dimensionless), Datum.create(6520000.0, Units.dimensionless), pwRow2, pwColumn2, 3, true);
        pwColorBar pwColorBar2 = new pwColorBar(new Datum(1.0E-17), new Datum(1.0E-6), pwRow2, pwColumn3, 4, true);
        pwPlot pwPlot2 = new pwPlot(pwTimeAxis2, pwAxis2, pwRow2, pwColumn2);
        pwPlot2.addRenderer(new SpectrogramRenderer(null, pwColorBar2));
        this.bta = new pwTimeAxis(pwDate2, pwDate3, pwRow3, pwColumn2, 2);
        this.bta.attachTo(pwTimeAxis2);
        pwAxis pwAxis3 = new pwAxis(Datum.create(6.52, Units.dimensionless), Datum.create(75000.0, Units.dimensionless), pwRow3, pwColumn2, 3, true);
        pwColorBar pwColorBar3 = new pwColorBar(new Datum(1.0E-11), new Datum(1.0E-5), pwRow3, pwColumn3, 4, true);
        pwPlot pwPlot3 = new pwPlot(this.bta, pwAxis3, pwRow3, pwColumn2);
        pwPlot3.addRenderer(new SpectrogramRenderer(null, pwColorBar3));
        pwPlot2.setTitle("Galileo PWS Summary Data!C!CElectric Field");
        pwColorBar2.setLabel("V!U2!Nm!U-2!NHz!U-1!N");
        pwAxis2.setLabel("Hz");
        pwPlot3.setTitle("Magnetic Field");
        pwColorBar3.setLabel("nT!U2!NHz!U-1!N");
        pwAxis3.setLabel("Hz");
        this.bta.setLabel("SCET");
        try {
            pwPlot2.getRenderer(0).setDataSetID("class:apps.gllpws.SummaryDataSetDescriptor?dataset=e");
            pwPlot3.getRenderer(0).setDataSetID("class:apps.gllpws.SummaryDataSetDescriptor?dataset=b");
        }
        catch (DasException dasException) {
            DasExceptionHandler.handle(dasException);
        }
        this.canvas.add(pwPlot2);
        this.canvas.add(pwPlot3);
        DataRange dataRange = pwTimeAxis2.getDataRange();
        this.timeRangeLabel = new TimeRangeLabel(dataRange, pwRow2, pwColumn2);
        PropertyChangeListener propertyChangeListener = this.timeRangeLabel.createDataRangePropertyListener();
        dataRange.addPropertyChangeListener("log", propertyChangeListener);
        dataRange.addPropertyChangeListener("minimum", propertyChangeListener);
        dataRange.addPropertyChangeListener("maximum", propertyChangeListener);
        this.canvas.addCanvasComponent(this.timeRangeLabel);
        JPanel jPanel = new JPanel(new FlowLayout(2));
        this.ts = new dasTimeRangeSelector(pwDate2, pwDate3);
        jPanel.add(this.ts);
        this.ts.addTimeRangeSelectionListener(this);
        JButton jButton = new JButton("Print");
        jButton.setActionCommand("print");
        jButton.addActionListener(this);
        jPanel.add(jButton);
        jButton = new JButton("Quit");
        jButton.setActionCommand("quit");
        jButton.addActionListener(this);
        jPanel.add(jButton);
        this.add((Component)jPanel, "South");
    }

    public void setTimeRange(pwDate pwDate2, pwDate pwDate3) {
        this.bta.setDataRange(pwDate2, pwDate3);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        block4: {
            String string;
            block3: {
                string = actionEvent.getActionCommand();
                if (!string.equals("quit")) break block3;
                System.exit(0);
                break block4;
            }
            if (!string.equals("print")) break block4;
            PrinterJob printerJob = PrinterJob.getPrinterJob();
            printerJob.setPrintable(this.canvas);
            boolean bl = printerJob.printDialog();
            if (bl) {
                try {
                    printerJob.print();
                }
                catch (PrinterException printerException) {
                    pwDie.println(printerException);
                }
            }
        }
    }

    public static void main(String[] stringArray) {
        Splash.showSplash();
        JFrame jFrame = new JFrame("GLLPWS Visualization Tool");
        jFrame.setDefaultCloseOperation(3);
        GLLPWS gLLPWS = new GLLPWS();
        jFrame.setContentPane(gLLPWS);
        jFrame.pack();
        jFrame.setVisible(true);
        Splash.hideSplash();
    }

    public void TimeRangeSelected(TimeRangeSelectionEvent timeRangeSelectionEvent) {
        this.setTimeRange(pwDate.create(timeRangeSelectionEvent.getStartTime()), pwDate.create(timeRangeSelectionEvent.getEndTime()));
    }
}

