/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.util.fileSystem;

import edu.uiowa.physics.pw.das.util.fileSystem.FileObject;
import edu.uiowa.physics.pw.das.util.fileSystem.FileSystem;
import edu.uiowa.physics.pw.das.util.fileSystem.LocalFileSystem;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.nio.channels.Channel;
import java.util.Date;

public class LocalFileObject
implements FileObject {
    File localFile;
    File localRoot;
    LocalFileSystem lfs;

    protected LocalFileObject(LocalFileSystem lfs, File localRoot, String filename) {
        this.lfs = lfs;
        this.localFile = new File(localRoot, filename);
        this.localRoot = localRoot;
    }

    public boolean canRead() {
        return this.localFile.canRead();
    }

    public FileObject[] getChildren() {
        File[] files = this.localFile.listFiles();
        FileObject[] result = new LocalFileObject[files.length];
        for (int i = 0; i < files.length; ++i) {
            result[i] = new LocalFileObject(this.lfs, this.localRoot, this.lfs.getLocalName(files[i]));
        }
        return result;
    }

    public InputStream getInputStream() throws FileNotFoundException {
        return new FileInputStream(this.localFile);
    }

    public FileObject getParent() {
        if (!this.localFile.equals(this.localRoot)) {
            return new LocalFileObject(this.lfs, this.localRoot, this.lfs.getLocalName(this.localFile.getParentFile()));
        }
        return null;
    }

    public long getSize() {
        return this.localFile.length();
    }

    public boolean isData() {
        return this.localFile.isFile();
    }

    public boolean isFolder() {
        return this.localFile.isDirectory();
    }

    public boolean isReadOnly() {
        return !this.localFile.canWrite();
    }

    public boolean isRoot() {
        return this.localFile.getParentFile() == null;
    }

    public Date lastModified() {
        return new Date(this.localFile.lastModified());
    }

    public boolean exists() {
        return this.localFile.exists();
    }

    public String getNameExt() {
        return FileSystem.toCanonicalFilename(this.localFile.toString().substring(this.localRoot.toString().length()));
    }

    public String toString() {
        return "[" + this.lfs + "]" + this.getNameExt();
    }

    public Channel getChannel() throws FileNotFoundException {
        return ((FileInputStream)this.getInputStream()).getChannel();
    }
}

