/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.util.fileSystem;

import edu.uiowa.physics.pw.das.DasApplication;
import edu.uiowa.physics.pw.das.util.fileSystem.FileObject;
import edu.uiowa.physics.pw.das.util.fileSystem.FileSystem;
import edu.uiowa.physics.pw.das.util.fileSystem.HtmlUtil;
import edu.uiowa.physics.pw.das.util.fileSystem.HttpFileObject;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.regex.Pattern;

public class HttpFileSystem
extends FileSystem {
    final File localRoot;
    final URL root;

    private HttpFileSystem(URL root, File localRoot) {
        if (!root.toString().endsWith("/")) {
            String s = root.toString();
            try {
                root = new URL(s + "/");
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
        this.root = root;
        this.localRoot = localRoot;
    }

    public static HttpFileSystem createHttpFileSystem(URL root) throws IOException {
        File local = System.getProperty("user.name").equals("Web") ? new File("/tmp") : new File(System.getProperty("user.home"));
        local = new File(local, ".das2/fileSystemCache/WebFileSystem/");
        local = new File(local, root.getHost());
        local = new File(local, root.getFile());
        local.mkdirs();
        return new HttpFileSystem(root, local);
    }

    protected void transferFile(String filename, File f) throws IOException {
        DasApplication.getDefaultApplication().getLogger().fine("create file " + filename);
        URL remoteURL = new URL(this.root.toString() + filename);
        InputStream in = remoteURL.openStream();
        if (!f.getParentFile().exists()) {
            f.getParentFile().mkdirs();
        }
        if (f.createNewFile()) {
            FileOutputStream out = new FileOutputStream(f);
            byte[] buf = new byte[2048];
            int br = in.read(buf);
            DasApplication.getDefaultApplication().getLogger().fine("transferring file " + filename);
            while (br != -1) {
                out.write(buf, 0, br);
                br = in.read(buf);
            }
            out.close();
        } else {
            this.handleException(new RuntimeException("couldn't create local file: " + f));
        }
        in.close();
    }

    protected File getLocalRoot() {
        return this.localRoot;
    }

    protected URL getRoot() {
        return this.root;
    }

    public boolean isDirectory(String filename) {
        File f = new File(this.localRoot, filename);
        if (f.exists()) {
            return f.isDirectory();
        }
        if (filename.endsWith("/")) {
            return true;
        }
        try {
            File parentFile = f.getParentFile();
            URL[] urls = HtmlUtil.getDirectoryListing(this.getURL(this.getLocalName(parentFile)));
            URL remoteUrl = filename.startsWith("/") ? new URL(this.root + filename.substring(1) + "/") : new URL(this.root + filename + "/");
            for (int i = 0; i < urls.length; ++i) {
                if (!urls[i].equals(remoteUrl)) continue;
                return true;
            }
            return false;
        }
        catch (IOException e) {
            this.handleException(e);
            return false;
        }
    }

    public String[] listDirectory(String directory) {
        if (!this.isDirectory(directory)) {
            throw new IllegalArgumentException("is not a directory: " + directory);
        }
        try {
            URL[] list = HtmlUtil.getDirectoryListing(this.getURL(directory));
            if (list.length > 100) {
                throw new IllegalStateException("URL list is very long, refusing to transfer");
            }
            String[] result = new String[list.length];
            for (int i = 0; i < list.length; ++i) {
                URL url = list[i];
                result[i] = this.getLocalName(url);
            }
            return result;
        }
        catch (IOException e) {
            this.handleException(e);
            return new String[0];
        }
    }

    public String[] listDirectory(String directory, String regex) {
        if (!this.isDirectory(directory = HttpFileSystem.toCanonicalFilename(directory))) {
            throw new IllegalArgumentException("is not a directory: " + directory);
        }
        try {
            Pattern pattern = Pattern.compile(regex);
            URL[] list = HtmlUtil.getDirectoryListing(this.getURL(directory));
            if (list.length > 100) {
                throw new IllegalStateException("URL list is very long, refusing to transfer");
            }
            ArrayList<String> result = new ArrayList<String>();
            for (int i = 0; i < list.length; ++i) {
                URL url = list[i];
                String r1 = this.getLocalName(url).substring(directory.length());
                if (!pattern.matcher(r1).matches()) continue;
                result.add(r1);
            }
            return result.toArray(new String[result.size()]);
        }
        catch (IOException e) {
            this.handleException(e);
            return new String[0];
        }
    }

    public URL getURL(String filename) {
        try {
            filename = FileSystem.toCanonicalFilename(filename);
            return new URL(this.root + filename.substring(1));
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public String getLocalName(File file) {
        if (!file.toString().startsWith(this.localRoot.toString())) {
            throw new IllegalArgumentException("file \"" + file + "\"is not of this web file system");
        }
        String filename = file.toString().substring(this.localRoot.toString().length());
        filename = filename.replaceAll("\\\\", "/");
        return filename;
    }

    public String getLocalName(URL url) {
        if (!url.toString().startsWith(this.root.toString())) {
            throw new IllegalArgumentException("url \"" + url + "\"is not of this web file system");
        }
        String filename = FileSystem.toCanonicalFilename(url.toString().substring(this.root.toString().length()));
        return filename;
    }

    public FileObject getFile(String filename) {
        HttpFileObject f = new HttpFileObject(this, filename, new Date(System.currentTimeMillis()));
        if (f.canRead()) {
            return f;
        }
        try {
            this.transferFile(filename, f.getLocalFile());
            return f;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return "wfs " + this.root;
    }
}

