/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.util.fileSystem;

import edu.uiowa.physics.pw.das.util.fileSystem.FileObject;
import edu.uiowa.physics.pw.das.util.fileSystem.HtmlUtil;
import edu.uiowa.physics.pw.das.util.fileSystem.HttpFileSystem;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.channels.Channel;
import java.util.Date;

public class HttpFileObject
implements FileObject {
    HttpFileSystem wfs;
    String pathname;
    File localFile;
    Date modifiedDate;
    boolean isRoot;
    boolean isFolder;

    public boolean canRead() {
        return true;
    }

    public FileObject[] getChildren() {
        if (!this.isFolder) {
            throw new IllegalArgumentException(this.toString() + "is not a folder");
        }
        try {
            URL[] list = HtmlUtil.getDirectoryListing(new URL(this.wfs.getRoot().toString() + this.pathname));
            FileObject[] result = new FileObject[list.length];
            for (int i = 0; i < list.length; ++i) {
                URL url = list[i];
                String localName = this.wfs.getLocalName(url);
                result[i] = new HttpFileObject(this.wfs, localName, new Date(System.currentTimeMillis()));
            }
            return result;
        }
        catch (MalformedURLException e) {
            this.wfs.handleException(e);
            return new FileObject[0];
        }
        catch (IOException e) {
            this.wfs.handleException(e);
            return new FileObject[0];
        }
    }

    public InputStream getInputStream() throws FileNotFoundException {
        if (this.isFolder) {
            throw new IllegalArgumentException("is a folder");
        }
        if (!this.localFile.exists()) {
            try {
                this.wfs.transferFile(this.pathname, this.localFile);
            }
            catch (FileNotFoundException e) {
                throw e;
            }
            catch (IOException e) {
                this.wfs.handleException(e);
            }
        }
        return new FileInputStream(this.localFile);
    }

    public FileObject getParent() {
        return new HttpFileObject(this.wfs, this.wfs.getLocalName(this.localFile.getParentFile()), new Date(System.currentTimeMillis()));
    }

    public long getSize() {
        if (this.isFolder) {
            throw new IllegalArgumentException("is a folder");
        }
        return this.localFile.length();
    }

    public boolean isData() {
        return !this.isFolder;
    }

    public boolean isFolder() {
        return this.isFolder;
    }

    public boolean isReadOnly() {
        return true;
    }

    public boolean isRoot() {
        return this.isRoot;
    }

    public Date lastModified() {
        return new Date(System.currentTimeMillis());
    }

    protected File getLocalFile() {
        return this.localFile;
    }

    public boolean exists() {
        if (this.localFile.exists()) {
            return true;
        }
        try {
            this.wfs.transferFile(this.pathname, this.localFile);
            return this.localFile.exists();
        }
        catch (FileNotFoundException e) {
            return false;
        }
        catch (IOException e) {
            this.wfs.handleException(e);
            return false;
        }
    }

    protected HttpFileObject(HttpFileSystem wfs, String pathname, Date modifiedDate) {
        this.localFile = new File(wfs.getLocalRoot(), pathname);
        this.localFile.deleteOnExit();
        this.wfs = wfs;
        this.pathname = pathname;
        if (!this.localFile.canRead()) {
            if (wfs.isDirectory(pathname)) {
                this.localFile.mkdirs();
                this.isFolder = true;
                if ("".equals(pathname)) {
                    this.isRoot = true;
                }
            } else {
                this.isFolder = false;
            }
        } else {
            this.isFolder = this.localFile.isDirectory();
        }
    }

    public String toString() {
        return "[" + this.wfs + "]" + this.getNameExt();
    }

    public String getNameExt() {
        return this.pathname;
    }

    public Channel getChannel() throws FileNotFoundException {
        return ((FileInputStream)this.getInputStream()).getChannel();
    }
}

