/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.util;

import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.DatumVector;
import edu.uiowa.physics.pw.das.stream.PacketDescriptor;
import edu.uiowa.physics.pw.das.stream.PropertyType;
import edu.uiowa.physics.pw.das.stream.StreamComment;
import edu.uiowa.physics.pw.das.stream.StreamDescriptor;
import edu.uiowa.physics.pw.das.stream.StreamException;
import edu.uiowa.physics.pw.das.stream.StreamHandler;
import edu.uiowa.physics.pw.das.util.ByteBufferInputStream;
import edu.uiowa.physics.pw.das.util.InflaterChannel;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackInputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class StreamTool {
    public static byte[] advanceTo(InputStream in, byte[] delim) throws IOException, DelimeterNotFoundException {
        byte[] data = new byte[4096];
        ArrayList<byte[]> list = new ArrayList<byte[]>();
        int bytesMatched = 0;
        boolean matchIndex = false;
        boolean streamIndex = false;
        int index = 0;
        boolean notDone = true;
        int unreadOffset = -99999;
        int unreadLength = -99999;
        int totalBytesRead = 0;
        int offset = 0;
        while (notDone) {
            int byteRead = in.read();
            ++totalBytesRead;
            if (byteRead == -1) {
                notDone = false;
            } else {
                data[offset] = (byte)byteRead;
                bytesMatched = delim[bytesMatched] == byteRead ? ++bytesMatched : 0;
                if (bytesMatched == delim.length) {
                    notDone = false;
                    index = totalBytesRead - delim.length;
                }
            }
            if (!notDone || ++offset != 4096) continue;
            list.add(data);
            offset = 0;
            data = new byte[4096];
        }
        if (bytesMatched != delim.length) {
            throw new DelimeterNotFoundException();
        }
        byte[] result = new byte[index];
        for (int i = 0; i < list.size(); ++i) {
            System.arraycopy(list.get(i), 0, result, i * 4096, 4096);
        }
        System.arraycopy(data, 0, result, list.size() * 4096, index - list.size() * 4096);
        return result;
    }

    public static byte[] readXML(PushbackInputStream in) throws IOException {
        ReadableByteChannel channel = Channels.newChannel(in);
        byte[] back = new byte[4096];
        ByteBuffer buffer = ByteBuffer.wrap(back);
        channel.read(buffer);
        buffer.flip();
        ByteBuffer xml = StreamTool.readXML(buffer);
        byte[] bytes = new byte[xml.remaining()];
        xml.get(bytes);
        return bytes;
    }

    private static void eatWhiteSpace(ByteBuffer buffer) {
        while (buffer.hasRemaining()) {
            char c = (char)(0xFF & buffer.get());
            if (Character.isWhitespace(c)) continue;
            buffer.position(buffer.position() - 1);
            return;
        }
    }

    public static ByteBuffer readXML(ByteBuffer input) throws IOException {
        int gtCount = 0;
        int tagCount = 0;
        boolean bufidx = false;
        boolean inQuotes = false;
        boolean inTag = false;
        boolean tagContainsSlash = false;
        ByteBuffer buffer = input.duplicate();
        buffer.mark();
        StreamTool.eatWhiteSpace(buffer);
        int b = 0xFF & buffer.get();
        if ((char)b != '<') {
            throw new IOException("found '" + (char)b + "', expected '<' at offset=" + buffer.position() + ".\n");
        }
        ++gtCount;
        tagContainsSlash = false;
        while (buffer.hasRemaining() && (gtCount > 0 || tagCount > 0)) {
            char lastChar = (char)b;
            b = 0xFF & buffer.get();
            if (inQuotes && (char)b == '\"' && lastChar != '\\') {
                inQuotes = false;
                continue;
            }
            if ((char)b == '<') {
                ++gtCount;
                inTag = true;
                tagContainsSlash = false;
                continue;
            }
            if (b == 62) {
                --gtCount;
                inTag = false;
                if (lastChar == '/') continue;
                if (tagContainsSlash) {
                    --tagCount;
                    continue;
                }
                ++tagCount;
                continue;
            }
            if (b == 47) {
                if (lastChar != '<') continue;
                tagContainsSlash = true;
                continue;
            }
            if ((char)b != '\"' || !inTag) continue;
            inQuotes = true;
        }
        if (b == -1) {
            throw new IOException("unexpected end of file before xml termination\n");
        }
        StreamTool.eatWhiteSpace(buffer);
        int limit = buffer.limit();
        buffer.limit(buffer.position());
        buffer.reset();
        ByteBuffer result = buffer.slice();
        buffer.position(buffer.limit());
        buffer.limit(limit);
        return result;
    }

    public static void readStream(ReadableByteChannel stream, StreamHandler handler) throws StreamException {
        ReadStreamStructure struct = new ReadStreamStructure(stream, handler);
        try {
            StreamDescriptor sd = StreamTool.getStreamDescriptor(struct);
            if ("deflate".equals(sd.getCompression())) {
                stream = StreamTool.getInflaterChannel(stream);
            }
            handler.streamDescriptor(sd);
            while (stream.read(struct.bigBuffer) != -1) {
                struct.bigBuffer.flip();
                while (StreamTool.getChunk(struct)) {
                }
                struct.bigBuffer.compact();
            }
            handler.streamClosed(sd);
        }
        catch (StreamException se) {
            handler.streamException(se);
            throw se;
        }
        catch (IOException ioe) {
            StreamException se = new StreamException(ioe);
            handler.streamException(se);
            throw se;
        }
    }

    private static StreamDescriptor getStreamDescriptor(ReadStreamStructure struct) throws StreamException, IOException {
        struct.bigBuffer.clear().limit(10);
        while (struct.bigBuffer.hasRemaining() && struct.stream.read(struct.bigBuffer) != -1) {
        }
        if (struct.bigBuffer.hasRemaining()) {
            throw new StreamException("Reached end of stream before encountering stream descriptor");
        }
        struct.bigBuffer.flip();
        struct.bigBuffer.get(struct.four);
        if (StreamTool.isStreamDescriptorHeader(struct.four)) {
            int contentLength = StreamTool.getContentLength(struct.bigBuffer);
            struct.bigBuffer.clear().limit(contentLength);
            while (struct.bigBuffer.hasRemaining() && struct.stream.read(struct.bigBuffer) != -1) {
            }
            if (struct.bigBuffer.hasRemaining()) {
                throw new StreamException("Reached end of stream before encountering stream descriptor");
            }
            struct.bigBuffer.flip();
            Document doc = StreamTool.getXMLDocument(struct.bigBuffer, contentLength);
            Element root = doc.getDocumentElement();
            if (root.getTagName().equals("stream")) {
                StreamDescriptor sd = new StreamDescriptor(doc.getDocumentElement());
                struct.bigBuffer.clear();
                return sd;
            }
            if (root.getTagName().equals("exception")) {
                throw StreamTool.exception(root);
            }
            throw new StreamException("Unexpected xml header, expecting stream or exception, received: " + root.getTagName());
        }
        throw new StreamException("Expecting stream descriptor header, found: '" + StreamTool.asciiBytesToString(struct.four, 0, 4) + "'");
    }

    private static final StreamException exception(Element exception) {
        String type = exception.getAttribute("type");
        return new StreamException(type);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean getChunk(ReadStreamStructure struct) throws StreamException, IOException {
        struct.bigBuffer.mark();
        if (struct.bigBuffer.remaining() < 4) {
            return false;
        }
        struct.bigBuffer.get(struct.four);
        if (StreamTool.isPacketDescriptorHeader(struct.four)) {
            if (struct.bigBuffer.remaining() < 6) {
                struct.bigBuffer.reset();
                return false;
            }
            int contentLength = StreamTool.getContentLength(struct.bigBuffer);
            if (struct.bigBuffer.capacity() < contentLength) {
                struct.bigBuffer.reset();
                ByteBuffer temp = ByteBuffer.allocate(8 + contentLength + contentLength / 10);
                temp.put(struct.bigBuffer);
                temp.flip();
                struct.bigBuffer = temp;
                return false;
            }
            if (struct.bigBuffer.remaining() < contentLength) {
                struct.bigBuffer.reset();
                return false;
            }
            Document doc = StreamTool.getXMLDocument(struct.bigBuffer, contentLength);
            Element root = doc.getDocumentElement();
            if (root.getTagName().equals("packet")) {
                PacketDescriptor pd = new PacketDescriptor(doc.getDocumentElement());
                struct.handler.packetDescriptor(pd);
                struct.descriptors.put(StreamTool.asciiBytesToString(struct.four, 1, 2), pd);
                return true;
            } else {
                if (root.getTagName().equals("exception")) {
                    throw StreamTool.exception(root);
                }
                if (!root.getTagName().equals("comment")) throw new StreamException("Unexpected xml header, expecting stream or exception, received: " + root.getTagName());
                struct.handler.streamComment(new StreamComment(doc.getDocumentElement()));
            }
            return true;
        } else {
            if (!StreamTool.isPacketHeader(struct.four)) throw new StreamException("Expected four byte header, found '" + new String(struct.four) + "'");
            String key = StreamTool.asciiBytesToString(struct.four, 1, 2);
            PacketDescriptor pd = (PacketDescriptor)struct.descriptors.get(key);
            int contentLength = pd.getSizeBytes();
            if (struct.bigBuffer.remaining() < contentLength) {
                struct.bigBuffer.reset();
                return false;
            }
            int yCount = pd.getYCount();
            Datum xTag = pd.getXDescriptor().readDatum(struct.bigBuffer);
            DatumVector[] vectors = new DatumVector[yCount];
            for (int i = 0; i < yCount; ++i) {
                vectors[i] = pd.getYDescriptor(i).read(struct.bigBuffer);
            }
            struct.handler.packet(pd, xTag, vectors);
        }
        return true;
    }

    private static ByteBuffer sliceBuffer(ByteBuffer buffer, int length) {
        ByteBuffer dup = buffer.duplicate();
        dup.limit(dup.position() + length);
        return dup.slice();
    }

    private static String asciiBytesToString(byte[] bytes, int offset, int length) {
        try {
            return new String(bytes, offset, length, "US-ASCII");
        }
        catch (UnsupportedEncodingException uee) {
            throw new RuntimeException(uee);
        }
    }

    private static boolean isStreamDescriptorHeader(byte[] four) {
        return four[0] == 91 && four[1] == 48 && four[2] == 48 && four[3] == 93;
    }

    private static boolean isPacketDescriptorHeader(byte[] four) {
        return four[0] == 91 && four[3] == 93 && (Character.isDigit((char)four[1]) && Character.isDigit((char)four[2]) || (char)four[1] == 'x' && (char)four[2] == 'x');
    }

    private static boolean isPacketHeader(byte[] four) {
        return four[0] == 58 && four[3] == 58 && Character.isDigit((char)four[1]) && Character.isDigit((char)four[2]);
    }

    private static Document getXMLDocument(ByteBuffer buffer, int contentLength) throws StreamException, IOException {
        ByteBuffer xml = buffer.duplicate();
        xml.limit(xml.position() + contentLength);
        buffer.position(buffer.position() + contentLength);
        ByteBufferInputStream bbin = new ByteBufferInputStream(xml);
        InputStreamReader isr = new InputStreamReader(bbin);
        return StreamTool.parseHeader(isr);
    }

    private static int getContentLength(ByteBuffer buffer) throws StreamException {
        int contentLength = 0;
        for (int i = 0; i < 6; ++i) {
            char c = (char)(0xFF & buffer.get());
            if (c == ' ') continue;
            if (!Character.isDigit(c)) {
                throw new StreamException("Invalid character in contentLength: '" + c + "'");
            }
            int digit = Character.digit(c, 10);
            contentLength = contentLength * 10 + digit;
        }
        return contentLength;
    }

    public static Document parseHeader(Reader header) throws StreamException {
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            InputSource source = new InputSource(header);
            Document document = builder.parse(source);
            return document;
        }
        catch (ParserConfigurationException ex) {
            throw new RuntimeException(ex.getMessage());
        }
        catch (SAXException ex) {
            throw new StreamException(ex);
        }
        catch (IOException ex) {
            throw new StreamException(ex);
        }
    }

    public static void formatHeader(Document document, Writer writer) throws StreamException {
        try {
            OutputFormat format = new OutputFormat("xml", "US-ASCII", true);
            XMLSerializer serializer = new XMLSerializer(writer, format);
            serializer.serialize(document);
        }
        catch (IOException ioe) {
            throw new StreamException(ioe);
        }
    }

    public static Map processPropertiesElement(Element element) throws StreamException {
        try {
            if (!element.getTagName().equals("properties")) {
                throw new StreamException("expecting 'properties' element, encountered '" + element.getTagName() + "'");
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            NamedNodeMap attributes = element.getAttributes();
            for (int i = 0; i < attributes.getLength(); ++i) {
                Attr attr = (Attr)attributes.item(i);
                String name = attr.getName();
                String[] split = name.split(":");
                if (split.length == 1) {
                    map.put(name, attr.getValue());
                    continue;
                }
                if (split.length == 2) {
                    PropertyType type = PropertyType.getByName(split[0]);
                    Object value = type.parse(attr.getValue());
                    map.put(split[1], value);
                    continue;
                }
                throw new IllegalArgumentException("Invalid typed name: " + name);
            }
            return map;
        }
        catch (ParseException pe) {
            StreamException se = new StreamException(pe.getMessage());
            se.initCause(pe);
            throw se;
        }
    }

    private static ReadableByteChannel getInflaterChannel(ReadableByteChannel channel) throws IOException {
        return new InflaterChannel(channel);
    }

    private static class ReadStreamStructure {
        private ReadableByteChannel stream;
        private ByteBuffer bigBuffer = ByteBuffer.allocate(4096);
        private byte[] four = new byte[4];
        private StreamHandler handler;
        private Map descriptors = new HashMap();

        private ReadStreamStructure(ReadableByteChannel stream, StreamHandler handler) {
            this.stream = stream;
            this.handler = handler;
        }
    }

    public static class DelimeterNotFoundException
    extends Exception {
    }
}

