/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.util;

import edu.uiowa.physics.pw.das.util.DasProgressMonitor;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.text.DecimalFormat;

public class DasProgressMonitorInputStream
extends FilterInputStream {
    private DasProgressMonitor monitor;
    private boolean started = false;
    private int bytesRead = 0;
    long birthTimeMilli;
    long deathTimeMilli;
    DecimalFormat transferRateFormat;

    public DasProgressMonitorInputStream(InputStream in, DasProgressMonitor monitor) {
        super(in);
        this.monitor = monitor;
        this.birthTimeMilli = System.currentTimeMillis();
        this.deathTimeMilli = -1L;
        if (monitor != null) {
            this.transferRateFormat = new DecimalFormat();
            this.transferRateFormat.setMaximumFractionDigits(2);
            this.transferRateFormat.setMinimumFractionDigits(2);
            monitor.setTaskSize(1000L);
        }
    }

    public void reportTransmitSpeed() {
        this.monitor.setAdditionalInfo("(" + this.transferRateFormat.format(this.calcTransmitSpeed() / 1024.0) + "kB/s)");
        this.monitor.setTaskProgress(this.bytesRead / 1000);
    }

    public double calcTransmitSpeed() {
        long totalBytesRead = this.bytesRead;
        long timeElapsed = this.deathTimeMilli > -1L ? this.deathTimeMilli - this.birthTimeMilli : System.currentTimeMillis() - this.birthTimeMilli;
        if (timeElapsed == 0L) {
            return Double.POSITIVE_INFINITY;
        }
        return 1000L * totalBytesRead / timeElapsed;
    }

    public int read() throws IOException {
        this.checkCancelled();
        int result = super.read();
        if (this.monitor != null) {
            if (!this.started) {
                this.started = true;
                this.monitor.started();
            }
            if (this.bytesRead == -1) {
                this.monitor.finished();
            } else {
                ++this.bytesRead;
                this.checkCancelled();
                this.reportTransmitSpeed();
            }
        }
        return result;
    }

    public int read(byte[] b) throws IOException {
        this.checkCancelled();
        int result = super.read(b);
        if (this.monitor != null) {
            if (!this.started) {
                this.started = true;
                this.monitor.started();
            }
            if (this.bytesRead == -1) {
                this.monitor.finished();
            } else {
                this.bytesRead += result;
                this.checkCancelled();
                this.reportTransmitSpeed();
            }
        }
        return result;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        this.checkCancelled();
        int result = super.read(b, off, len);
        if (this.monitor != null) {
            if (!this.started) {
                this.started = true;
                this.monitor.started();
            }
            if (this.bytesRead == -1) {
                this.monitor.finished();
            } else {
                this.bytesRead += result;
                this.checkCancelled();
                this.reportTransmitSpeed();
            }
        }
        return result;
    }

    private void checkCancelled() throws IOException {
        if (this.monitor != null && this.monitor.isCancelled()) {
            this.close();
            throw new InterruptedIOException("Operation cancelled");
        }
    }

    public void close() throws IOException {
        super.close();
        this.deathTimeMilli = System.currentTimeMillis();
        if (this.monitor != null) {
            this.monitor.finished();
            this.started = false;
        }
    }
}

