/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.math.fft;

import edu.uiowa.physics.pw.das.math.fft.ComplexArray;
import edu.uiowa.physics.pw.das.math.fft.jnt.ComplexDoubleFFT;
import edu.uiowa.physics.pw.das.math.fft.jnt.ComplexDoubleFFT_Mixed;
import edu.uiowa.physics.pw.das.math.fft.jnt.ComplexFloatFFT;
import edu.uiowa.physics.pw.das.math.fft.jnt.ComplexFloatFFT_Mixed;

public class GeneralFFT {
    boolean doublePrecision;
    int n;
    ComplexDoubleFFT complexDoubleFFT;
    ComplexFloatFFT complexFloatFFT;
    private static final double LOG_2 = Math.log(2.0);

    public GeneralFFT(int n, boolean doublePrecision) {
        this.n = n;
        this.doublePrecision = doublePrecision;
        if (n < 2 || (double)n > Math.pow(2.0, 100.0)) {
            throw new IllegalArgumentException("n too big or too small, n=" + n);
        }
        if (doublePrecision) {
            this.complexDoubleFFT = new ComplexDoubleFFT_Mixed(n);
        } else {
            this.complexFloatFFT = new ComplexFloatFFT_Mixed(n);
        }
    }

    public static GeneralFFT newFloatFFT(int n) {
        return new GeneralFFT(n, false);
    }

    public static GeneralFFT newDoubleFFT(int n) {
        return new GeneralFFT(n, true);
    }

    public void transform(ComplexArray.Double data) {
        if (!this.doublePrecision) {
            throw new IllegalArgumentException("expected float arrays, got doubles");
        }
        this.complexDoubleFFT.transform(data);
        double norm = this.complexDoubleFFT.normalization();
        for (int i = 0; i < this.n; ++i) {
            data.setReal(i, data.getReal(i) * norm);
            data.setImag(i, data.getImag(i) * norm);
        }
    }

    public void transform(ComplexArray.Float data) {
        if (this.doublePrecision) {
            throw new IllegalArgumentException("expected double arrays, got floats");
        }
        this.complexFloatFFT.transform(data);
        float norm = this.complexFloatFFT.normalization();
        for (int i = 0; i < this.n; ++i) {
            data.setReal(i, data.getReal(i) * norm);
            data.setImag(i, data.getImag(i) * norm);
        }
    }

    public void invTransform(ComplexArray.Double data) {
        if (!this.doublePrecision) {
            throw new IllegalArgumentException("expected float arrays, got doubles");
        }
        this.complexDoubleFFT.inverse(data);
    }

    public void invTransform(ComplexArray.Float data) {
        if (this.doublePrecision) {
            throw new IllegalArgumentException("expected double arrays, got floats");
        }
        this.complexFloatFFT.inverse(data);
    }
}

