/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.graph.dnd;

import edu.uiowa.physics.pw.das.graph.DasAxis;
import edu.uiowa.physics.pw.das.graph.DasCanvasComponent;
import edu.uiowa.physics.pw.das.graph.DasColorBar;
import edu.uiowa.physics.pw.das.graph.DasPlot;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public class TransferableCanvasComponent
implements Transferable {
    public static final DataFlavor CANVAS_COMPONENT_FLAVOR = TransferableCanvasComponent.localJVMFlavor("edu.uiowa.physics.pw.das.graph.DasCanvasComponent");
    public static final DataFlavor AXIS_FLAVOR = TransferableCanvasComponent.localJVMFlavor("edu.uiowa.physics.pw.das.graph.DasAxis");
    public static final DataFlavor PLOT_FLAVOR = TransferableCanvasComponent.localJVMFlavor("edu.uiowa.physics.pw.das.graph.DasPlot");
    public static final DataFlavor COLORBAR_FLAVOR = TransferableCanvasComponent.localJVMFlavor("edu.uiowa.physics.pw.das.graph.DasColorBar");
    private List flavorList;
    private DasCanvasComponent component;

    private static DataFlavor localJVMFlavor(String className) {
        try {
            String x = "application/x-java-jvm-local-objectref";
            return new DataFlavor(x + ";class=" + className);
        }
        catch (ClassNotFoundException cnfe) {
            throw new RuntimeException(cnfe);
        }
    }

    public TransferableCanvasComponent(DasAxis axis) {
        this.flavorList = Arrays.asList(AXIS_FLAVOR, CANVAS_COMPONENT_FLAVOR, DataFlavor.stringFlavor);
        this.component = axis;
    }

    public TransferableCanvasComponent(DasPlot plot) {
        this.flavorList = Arrays.asList(PLOT_FLAVOR, CANVAS_COMPONENT_FLAVOR, DataFlavor.stringFlavor);
        this.component = plot;
    }

    public TransferableCanvasComponent(DasColorBar cb) {
        this.flavorList = Arrays.asList(PLOT_FLAVOR, CANVAS_COMPONENT_FLAVOR, DataFlavor.stringFlavor);
        this.component = cb;
    }

    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (this.isDataFlavorSupported(flavor)) {
            if (flavor.equals(DataFlavor.stringFlavor)) {
                throw new UnsupportedFlavorException(flavor);
            }
            return this.component;
        }
        throw new UnsupportedFlavorException(flavor);
    }

    public DataFlavor[] getTransferDataFlavors() {
        return this.flavorList.toArray(new DataFlavor[this.flavorList.size()]);
    }

    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return this.flavorList.contains(flavor);
    }
}

