/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.graph;

import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.DatumUtil;
import edu.uiowa.physics.pw.das.datum.DatumVector;
import edu.uiowa.physics.pw.das.datum.TimeLocationUnits;
import edu.uiowa.physics.pw.das.datum.TimeUtil;
import edu.uiowa.physics.pw.das.datum.Units;
import edu.uiowa.physics.pw.das.datum.UnitsConverter;
import edu.uiowa.physics.pw.das.datum.format.DatumFormatter;
import edu.uiowa.physics.pw.das.datum.format.DatumFormatterFactory;
import edu.uiowa.physics.pw.das.datum.format.DefaultDatumFormatterFactory;
import edu.uiowa.physics.pw.das.datum.format.TimeDatumFormatter;
import edu.uiowa.physics.pw.das.util.DasDie;
import edu.uiowa.physics.pw.das.util.DasMath;
import java.text.ParseException;
import java.util.ArrayList;

public class TickVDescriptor {
    double[] tickV = null;
    double[] minorTickV = null;
    Units units = null;
    DatumFormatter datumFormatter;

    protected TickVDescriptor() {
    }

    public TickVDescriptor(double[] minorTicks, double[] ticks, Units units) {
        this.tickV = ticks;
        this.minorTickV = minorTicks;
        this.units = units;
        this.datumFormatter = DefaultDatumFormatterFactory.getInstance().defaultFormatter();
    }

    public static TickVDescriptor newTickVDescriptor(DatumVector majorTicks, DatumVector minorTicks) {
        Units units = majorTicks.getUnits();
        double[] minor = minorTicks.toDoubleArray(units);
        double[] major = majorTicks.toDoubleArray(units);
        return new TickVDescriptor(minor, major, units);
    }

    public DatumVector getMajorTicks() {
        return DatumVector.newDatumVector(this.tickV, this.units);
    }

    public DatumVector getMinorTicks() {
        return DatumVector.newDatumVector(this.minorTickV, this.units);
    }

    public DatumFormatter getFormatter() {
        return this.datumFormatter;
    }

    public void setFormatter(DatumFormatter datumFormatter) {
        this.datumFormatter = datumFormatter;
    }

    public String toString() {
        int i;
        String s = "tickV=[";
        for (i = 0; i < this.tickV.length; ++i) {
            s = s + this.datumFormatter.format(this.units.createDatum(this.tickV[i])) + ", ";
        }
        s = s + "],minor=";
        for (i = 0; i < this.minorTickV.length; ++i) {
            s = s + this.minorTickV[i] + ", ";
        }
        s = s + "]";
        return s;
    }

    public static TickVDescriptor bestTickVLinear(Datum min, Datum max, int nTicksMin, int nTicksMax) {
        double mag;
        int targetTicks;
        TickVDescriptor res = new TickVDescriptor();
        res.units = min.getUnits();
        double minimum = min.doubleValue(res.units);
        double maximum = max.doubleValue(res.units);
        double maj = (maximum - minimum) / (double)(targetTicks = Math.max(Math.min(6, nTicksMax), nTicksMin));
        double absissa = maj / (mag = DasMath.exp10(Math.floor(DasMath.log10(maj))));
        absissa = absissa < 1.666 ? 1.0 : (absissa < 3.333 ? 2.0 : 5.0);
        double axisLengthData = maximum - minimum;
        double tickSize = absissa * mag;
        double firstTick = tickSize * Math.ceil((minimum - axisLengthData) / tickSize - 0.01);
        double lastTick = tickSize * Math.floor((maximum + axisLengthData) / tickSize + 0.01);
        int nTicks = 1 + (int)Math.round((lastTick - firstTick) / tickSize);
        double[] result = new double[nTicks];
        for (int i = 0; i < nTicks; ++i) {
            result[i] = firstTick + (double)i * tickSize;
        }
        res.tickV = result;
        double minor = absissa == 5.0 ? tickSize / 5.0 : (absissa == 2.0 ? tickSize / 2.0 : tickSize / 4.0);
        int ifirst = nTicks / 3;
        int ilast = 2 * nTicks / 3;
        res.datumFormatter = DatumUtil.bestFormatter(res.units.createDatum(result[ifirst]), res.units.createDatum(result[ilast]), ilast - ifirst);
        double firstMinor = minor * Math.ceil((minimum - axisLengthData) / minor);
        double lastMinor = minor * Math.floor((maximum + axisLengthData) / minor);
        int nMinor = (int)((lastMinor - firstMinor) / minor + 0.5);
        double[] minorTickV = new double[nMinor];
        for (int i = 0; i < nMinor; ++i) {
            minorTickV[i] = firstMinor + (double)i * minor;
        }
        res.minorTickV = minorTickV;
        return res;
    }

    /*
     * WARNING - void declaration
     */
    public static TickVDescriptor bestTickVLogNew(Datum minD, Datum maxD, int nTicksMin, int nTicksMax) {
        void var18_14;
        int i;
        void var19_18;
        void var20_19;
        int stepSize;
        int maxTick;
        int minTick;
        double max;
        double min;
        TickVDescriptor ticks;
        block26: {
            ticks = new TickVDescriptor();
            ticks.units = minD.getUnits();
            min = minD.doubleValue(ticks.units);
            max = maxD.doubleValue(ticks.units);
            double dMinTick = DasMath.roundNFractionalDigits(DasMath.log10(min), 4);
            minTick = (int)Math.ceil(dMinTick);
            double dMaxTick = DasMath.roundNFractionalDigits(DasMath.log10(max), 4);
            maxTick = (int)Math.floor(dMaxTick);
            stepSize = 1;
            int nTicks = (maxTick - minTick) / stepSize + 1;
            DatumFormatterFactory factory = ticks.units.getDatumFormatterFactory();
            try {
                DatumFormatter formatter;
                double[] minors;
                int i2;
                double[] major;
                if (max / min < 10.5) {
                    return TickVDescriptor.bestTickVLinear(minD, maxD, nTicksMin, nTicksMax);
                }
                if (nTicksMin <= nTicks && nTicks <= nTicksMax) {
                    major = new double[nTicks];
                    for (i2 = 0; i2 < nTicks; ++i2) {
                        major[i2] = i2 * stepSize + minTick;
                    }
                    minors = new double[]{2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0};
                    formatter = factory.newFormatter("0E0");
                    break block26;
                }
                if (nTicksMin > nTicks) {
                    stepSize = (int)Math.floor((double)nTicks / (double)nTicksMin);
                    stepSize = stepSize < 1 ? 1 : stepSize;
                    minTick = (int)(Math.floor((double)minTick / (double)stepSize) * (double)stepSize);
                    maxTick = (int)(Math.ceil((double)maxTick / (double)stepSize) * (double)stepSize);
                    nTicks = (maxTick - minTick) / stepSize + 1;
                    major = new double[nTicks];
                    for (i2 = 0; i2 < nTicks; ++i2) {
                        major[i2] = i2 * stepSize + minTick;
                    }
                    minors = new double[]{2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0};
                    formatter = factory.newFormatter("0E0");
                    break block26;
                }
                Units units = minD.getUnits();
                Datum logMinD = units.createDatum(DasMath.log10(min));
                Datum logMaxD = units.createDatum(DasMath.log10(max));
                TickVDescriptor linTicks = TickVDescriptor.bestTickVLinear(logMinD, logMaxD, nTicksMin, nTicksMax);
                for (int i3 = 0; i3 < linTicks.tickV.length; ++i3) {
                    linTicks.tickV[i3] = DasMath.exp10(linTicks.tickV[i3]);
                }
                int idx = 0;
                if (linTicks.tickV[1] / linTicks.tickV[0] <= 10.00001) {
                    double[] newMinorTicks = new double[(linTicks.tickV.length + 1) * 9];
                    for (int j = 2; j < 10; ++j) {
                        newMinorTicks[idx++] = (double)j * (linTicks.tickV[0] / 10.0);
                    }
                    for (int i4 = 0; i4 < linTicks.tickV.length; ++i4) {
                        for (int j = 2; j < 10; ++j) {
                            newMinorTicks[idx++] = (double)j * linTicks.tickV[i4];
                        }
                    }
                    linTicks.minorTickV = newMinorTicks;
                } else {
                    for (int i5 = 0; i5 < linTicks.minorTickV.length; ++i5) {
                        linTicks.minorTickV[i5] = DasMath.exp10(linTicks.minorTickV[i5]);
                    }
                }
                linTicks.datumFormatter = factory.newFormatter("0E0");
                return linTicks;
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
        }
        ticks.datumFormatter = var20_19;
        int firstMinorTickCycle = (int)Math.floor(DasMath.log10(min));
        int lastMinorTickCycle = (int)Math.floor(DasMath.log10(max));
        double[] minorTickV = null;
        if (((void)var19_18).length > 0) {
            int idx = 0;
            minorTickV = new double[(lastMinorTickCycle - firstMinorTickCycle + 1) * ((void)var19_18).length];
            for (i = firstMinorTickCycle; i <= lastMinorTickCycle; ++i) {
                for (int j = 0; j < ((void)var19_18).length; ++j) {
                    minorTickV[idx++] = DasMath.exp10(i) * var19_18[j];
                }
            }
        } else if (stepSize > 1) {
            minorTickV = new double[lastMinorTickCycle - firstMinorTickCycle + 1 - ((void)var18_14).length + 1];
            int imajor = 0;
            int idx = 0;
            int i6 = firstMinorTickCycle;
            while (idx < minorTickV.length) {
                if (var18_14[imajor] == (double)i6) {
                    ++imajor;
                } else {
                    minorTickV[idx] = DasMath.exp10(i6);
                    ++idx;
                }
                ++i6;
            }
        }
        ticks.minorTickV = minorTickV;
        for (int i7 = 0; i7 < ((void)var18_14).length; ++i7) {
            var18_14[i7] = DasMath.exp10((double)var18_14[i7]);
        }
        ticks.tickV = var18_14;
        if (minTick >= maxTick) {
            double[] majorTicks = new double[ticks.tickV.length + ticks.minorTickV.length];
            for (i = 0; i < ticks.tickV.length; ++i) {
                majorTicks[i] = ticks.tickV[i];
            }
            for (i = 0; i < ticks.minorTickV.length; ++i) {
                majorTicks[i + ticks.tickV.length] = ticks.minorTickV[i];
            }
        }
        return ticks;
    }

    public static TickVDescriptor bestTickVTime(Datum minD, Datum maxD, int nTicksMin, int nTicksMax) {
        int ii;
        int nTicks;
        double lastTick;
        double firstTick;
        double tickSize;
        Datum minute = Datum.create(60.0, Units.seconds);
        if (maxD.subtract(minD).lt(minute)) {
            Datum base = TimeUtil.prevMidnight(minD);
            Units offUnits = Units.seconds;
            Datum offMin = minD.subtract(base).convertTo(offUnits);
            Datum offMax = maxD.subtract(base).convertTo(offUnits);
            TickVDescriptor offTicks = TickVDescriptor.bestTickVLinear(offMin, offMax, nTicksMin, nTicksMax);
            DatumVector minorTicks = offTicks.getMinorTicks().add(base);
            DatumVector majorTicks = offTicks.getMajorTicks().add(base);
            TickVDescriptor result = TickVDescriptor.newTickVDescriptor(majorTicks, minorTicks);
        }
        if (maxD.subtract(minD).gt(Datum.create(3650, Units.days))) {
            int i;
            int yearMin = TimeUtil.toTimeStruct((Datum)minD).year;
            int yearMax = TimeUtil.toTimeStruct((Datum)maxD).year;
            TickVDescriptor yearTicks = TickVDescriptor.bestTickVLinear(Units.dimensionless.createDatum(yearMin), Units.dimensionless.createDatum(yearMax), nTicksMin, nTicksMax);
            yearTicks.units = minD.getUnits();
            for (i = 0; i < yearTicks.tickV.length; ++i) {
                int iyear = (int)yearTicks.tickV[i];
                yearTicks.tickV[i] = TimeUtil.convert(iyear, 1, 1, 0, 0, 0.0, (TimeLocationUnits)yearTicks.units);
            }
            for (i = 0; i < yearTicks.minorTickV.length; ++i) {
                int iyear = (int)yearTicks.minorTickV[i];
                yearTicks.minorTickV[i] = TimeUtil.convert(iyear, 1, 1, 0, 0, 0.0, (TimeLocationUnits)yearTicks.units);
            }
            Datum t1 = yearTicks.getMajorTicks().get(0);
            int nticks = yearTicks.getMajorTicks().getLength();
            Datum t2 = yearTicks.getMajorTicks().get(nticks - 1);
            yearTicks.datumFormatter = DatumUtil.bestTimeFormatter(t1, t2, nticks);
            return yearTicks;
        }
        TickVDescriptor res = new TickVDescriptor();
        double data_minimum = minD.doubleValue(Units.t2000);
        double data_maximum = maxD.doubleValue(Units.t2000);
        double[] mags12 = new double[]{0.001, 0.002, 0.005, 0.01, 0.02, 0.05, 0.1, 0.2, 0.5, 1.0, 2.0, 5.0, 10.0, 30.0, 60.0, 120.0, 300.0, 600.0, 1200.0, 3600.0, 7200.0, 10800.0, 14400.0, 21600.0, 28800.0, 43200.0, 86400.0, 172800.0, 432000.0, 864000.0};
        int[] nminor = new int[]{4, 4, 5, 4, 4, 5, 4, 4, 5, 4, 4, 5, 5, 3, 6, 4, 5, 5, 4, 4, 4, 3, 4, 3, 4, 6, 4, 2, 5, 10};
        double mag_keep = -1.0;
        int i = 0;
        int ikeep = -1;
        if (data_maximum - data_minimum > 86400.0) {
            i = 4;
        }
        while (i < mags12.length && ikeep == -1) {
            double mag;
            tickSize = mag = mags12[i];
            firstTick = tickSize * Math.ceil(data_minimum / tickSize);
            lastTick = tickSize * Math.floor(data_maximum / tickSize);
            nTicks = (lastTick - firstTick) / tickSize > 1000.0 ? 1000 : 1 + (int)((lastTick - firstTick) / tickSize);
            if (nTicks < nTicksMax) {
                ikeep = i;
            }
            ++i;
        }
        if (ikeep != -1) {
            mag_keep = mags12[ikeep];
            double absissa = 1.0;
            tickSize = absissa * mag_keep;
            double axisLengthData = data_maximum - data_minimum;
            firstTick = tickSize * Math.ceil((data_minimum - axisLengthData) / tickSize);
            lastTick = tickSize * Math.floor((data_maximum + axisLengthData) / tickSize);
            nTicks = 1 + (int)Math.round((lastTick - firstTick) / tickSize);
            if (nTicks < 2) {
                DasDie.println("Only able to find one major tick--sorry! ");
                DasDie.println("please let us know how you entered this condition");
                nTicks = 2;
            }
            double[] tickV = new double[nTicks];
            for (i = 0; i < nTicks; ++i) {
                tickV[i] = firstTick + (double)i * tickSize;
            }
            res.tickV = tickV;
            double minor = tickSize / (double)nminor[ikeep];
            double firstMinor = minor * Math.ceil((data_minimum - axisLengthData) / minor);
            double lastMinor = minor * Math.floor((data_maximum + axisLengthData) / minor);
            int nMinor = (int)((lastMinor - firstMinor) / minor + 0.5);
            double[] minorTickV = new double[nMinor];
            for (int ii2 = 0; ii2 < nMinor; ++ii2) {
                minorTickV[ii2] = firstMinor + (double)ii2 * minor;
            }
            res.minorTickV = minorTickV;
            Datum t1 = Units.t2000.createDatum(firstTick);
            Datum t2 = Units.t2000.createDatum(lastTick);
            res.datumFormatter = DatumUtil.bestFormatter(t1, t2, nTicks - 1);
            if (res.datumFormatter == TimeDatumFormatter.HOURS) {
                res.datumFormatter = TimeDatumFormatter.MINUTES;
            }
        } else {
            int ii3;
            int minorStep;
            int step;
            double[] result = new double[30];
            ArrayList<Datum> minorTickV = new ArrayList<Datum>();
            int ir = 0;
            Datum min = Datum.create(data_minimum, (Units)Units.t2000);
            Datum max = Datum.create(data_maximum, (Units)Units.t2000);
            int nstep = 1;
            int minorNStep = 1;
            if (data_maximum - data_minimum < 1.5552E7) {
                step = 2;
                minorStep = 3;
                minorNStep = 1;
            } else if (data_maximum - data_minimum < 6.48E7) {
                step = 98;
                minorStep = 2;
            } else if (data_maximum - data_minimum < 1.89216E8) {
                step = 1;
                minorStep = 2;
            } else {
                step = 1;
                minorStep = 1;
                nstep = 2;
            }
            Datum firstTickDatum = TimeUtil.prev(step, TimeUtil.prev(step, min));
            Datum lastTickDatum = TimeUtil.next(step, TimeUtil.next(step, max));
            Datum current = firstTickDatum;
            while (lastTickDatum.ge(current)) {
                result[ir++] = current.doubleValue(Units.t2000);
                current = TimeUtil.next(step, current);
                for (ii3 = nstep; ii3 > 1; --ii3) {
                    current = TimeUtil.next(step, current);
                }
            }
            res.tickV = new double[ir];
            for (ir = 0; ir < res.tickV.length; ++ir) {
                res.tickV[ir] = result[ir];
            }
            current = firstTickDatum;
            while (lastTickDatum.ge(current)) {
                minorTickV.add(current);
                current = TimeUtil.next(minorStep, current);
                for (ii3 = minorNStep; ii3 > 1; --ii3) {
                    current = TimeUtil.next(minorStep, current);
                }
            }
            res.minorTickV = new double[minorTickV.size()];
            for (ii3 = 0; ii3 < minorTickV.size(); ++ii3) {
                res.minorTickV[ii3] = ((Datum)minorTickV.get(ii3)).doubleValue(Units.t2000);
            }
            res.datumFormatter = DatumUtil.bestFormatter(firstTickDatum, lastTickDatum, 6);
        }
        res.units = minD.getUnits();
        UnitsConverter uc = Units.getConverter(Units.t2000, res.units);
        for (ii = 0; ii < res.tickV.length; ++ii) {
            res.tickV[ii] = uc.convert(res.tickV[ii]);
        }
        for (ii = 0; ii < res.minorTickV.length; ++ii) {
            res.minorTickV[ii] = uc.convert(res.minorTickV[ii]);
        }
        return res;
    }
}

