/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.graph;

import edu.uiowa.physics.pw.das.DasException;
import edu.uiowa.physics.pw.das.components.propertyeditor.Enumeration;
import edu.uiowa.physics.pw.das.dataset.ConstantDataSetDescriptor;
import edu.uiowa.physics.pw.das.dataset.DataSet;
import edu.uiowa.physics.pw.das.dataset.DataSetDescriptor;
import edu.uiowa.physics.pw.das.dataset.VectorDataSet;
import edu.uiowa.physics.pw.das.dataset.VectorUtil;
import edu.uiowa.physics.pw.das.datum.Units;
import edu.uiowa.physics.pw.das.graph.DasAxis;
import edu.uiowa.physics.pw.das.graph.GrannyTickLabeller;
import edu.uiowa.physics.pw.das.graph.Renderer;
import edu.uiowa.physics.pw.das.graph.TickLabeller;
import edu.uiowa.physics.pw.das.graph.TickVDescriptor;
import edu.uiowa.physics.pw.das.util.DasMath;
import edu.uiowa.physics.pw.das.util.DasProgressMonitor;
import java.awt.BasicStroke;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import javax.swing.Icon;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TickCurveRenderer
extends Renderer {
    private Stroke stroke;
    TickVDescriptor tickv;
    private String xplane;
    private String yplane;
    private VectorDataSet xds;
    private VectorDataSet yds;
    private Units xunits;
    private Units yunits;
    private double[][] idata;
    TickLabeller tickLabeller;
    private TickStyle tickStyle;
    private double lineWidth;
    private float tickLength;

    public TickCurveRenderer(DataSetDescriptor dsd, String xplane, String yplane, TickVDescriptor tickv) {
        super(dsd);
        this.setTickStyle(TickStyle.outer);
        this.setLineWidth(1.0);
        this.setTickLength(8.0f);
        this.xplane = xplane;
        this.yplane = yplane;
        this.tickv = tickv;
    }

    protected void uninstallRenderer() {
    }

    protected void installRenderer() {
    }

    private static double length(Line2D line) {
        double dx = line.getX2() - line.getX1();
        double dy = line.getY2() - line.getY1();
        double dist = Math.sqrt(dx * dx + dy * dy);
        return dist;
    }

    private static Line2D normalize(Line2D line, double len) {
        Point2D p1 = line.getP1();
        double dx = line.getX2() - line.getX1();
        double dy = line.getY2() - line.getY1();
        double dist = Math.sqrt(dx * dx + dy * dy);
        Line2D result = (Line2D)line.clone();
        result.setLine(p1.getX(), p1.getY(), p1.getX() + dx / dist * len, p1.getY() + dy / dist * len);
        return result;
    }

    private double turnDir(double x1, double y1, double x2, double y2, double x3, double y3) {
        double dx1 = x2 - x1;
        double dx2 = x3 - x2;
        double dy1 = y2 - y1;
        double dy2 = y3 - y2;
        return dx1 * dy2 - dx2 * dy1;
    }

    private double turnDirAt(double findex) {
        int nvert = this.xds.getXLength();
        int index0 = findex < 1.0 ? 0 : (findex > (double)(nvert - 2) ? nvert - 3 : (int)Math.floor(findex) - 1);
        int index1 = index0 + 1;
        int index2 = index1 + 1;
        return this.turnDir(this.xds.getDouble(index0, this.xunits), this.yds.getDouble(index0, this.yunits), this.xds.getDouble(index1, this.xunits), this.yds.getDouble(index1, this.yunits), this.xds.getDouble(index2, this.xunits), this.yds.getDouble(index2, this.yunits));
    }

    private Line2D outsideNormalAt(double findex) {
        double dxNorm;
        double dyNorm;
        double turnDirTick;
        int nvert = this.xds.getXLength();
        int index0 = (int)Math.floor(findex);
        if (index0 == nvert - 1) {
            --index0;
        }
        double x1 = this.idata[0][index0];
        double x2 = this.idata[0][index0 + 1];
        double y1 = this.idata[1][index0];
        double y2 = this.idata[1][index0 + 1];
        double xinterp = DasMath.interpolate(this.idata[0], findex);
        double yinterp = DasMath.interpolate(this.idata[1], findex);
        double dx = x2 - x1;
        double dy = y2 - y1;
        double turnDir = this.turnDirAt(findex);
        if (turnDir * (turnDirTick = -1.0 * (dx * (dyNorm = -dx) - (dxNorm = dy) * dy)) > 0.0) {
            dxNorm = -dy;
            dyNorm = dx;
        }
        return TickCurveRenderer.normalize(new Line2D.Double(xinterp, yinterp, xinterp + dxNorm, yinterp + dyNorm), 1.0);
    }

    private void drawTick(Graphics2D g, double findex) {
        float tl = this.getTickLength() * 2.0f / 3.0f;
        Line2D tick = TickCurveRenderer.normalize(this.outsideNormalAt(findex), tl);
        if (this.tickStyle == TickStyle.both) {
            Line2D flipTick = TickCurveRenderer.normalize(tick, -tl);
            Line2D.Double bothTick = new Line2D.Double(flipTick.getP2(), tick.getP2());
            g.draw(bothTick);
        } else {
            g.draw(tick);
        }
    }

    private double slope(Line2D line) {
        return (line.getY2() - line.getY1()) / (line.getX2() - line.getX1());
    }

    private void drawLabelTick(Graphics2D g, double findex, int tickNumber) {
        float tl = this.getTickLength();
        Line2D tick = TickCurveRenderer.normalize(this.outsideNormalAt(findex), tl);
        if (this.tickStyle == TickStyle.both) {
            Line2D flipTick = TickCurveRenderer.normalize(tick, -tl);
            Line2D.Double bothTick = new Line2D.Double(flipTick.getP2(), tick.getP2());
            g.draw(bothTick);
        } else {
            g.draw(tick);
        }
        this.tickLabeller.labelMajorTick(g, tickNumber, tick);
    }

    public void render(Graphics g1, DasAxis xAxis, DasAxis yAxis) {
        int i;
        int i2;
        Graphics2D g = (Graphics2D)g1;
        g.setStroke(this.stroke);
        DataSet ds = this.getDataSet();
        this.xds = (VectorDataSet)ds.getPlanarView(this.xplane);
        this.yds = (VectorDataSet)ds.getPlanarView(this.yplane);
        this.xunits = this.xds.getYUnits();
        this.yunits = this.yds.getYUnits();
        this.idata = new double[2][this.xds.getXLength()];
        for (i2 = 0; i2 < this.xds.getXLength(); ++i2) {
            this.idata[0][i2] = xAxis.transform(this.xds.getDouble(i2, this.xunits), this.xunits);
            this.idata[1][i2] = yAxis.transform(this.yds.getDouble(i2, this.yunits), this.yunits);
        }
        for (i2 = 1; i2 < this.xds.getXLength(); ++i2) {
            g.drawLine((int)this.idata[0][i2 - 1], (int)this.idata[1][i2 - 1], (int)this.idata[0][i2], (int)this.idata[1][i2]);
        }
        double[] findex = DasMath.findex(VectorUtil.getXTagArrayDouble(this.xds, this.xds.getXUnits()), this.tickv.minorTickV);
        this.tickLabeller = new GrannyTickLabeller(xAxis);
        this.tickLabeller.init(this.tickv);
        for (i = 0; i < this.tickv.minorTickV.length; ++i) {
            this.drawTick(g, findex[i]);
        }
        findex = DasMath.findex(VectorUtil.getXTagArrayDouble(this.xds, this.xds.getXUnits()), this.tickv.tickV);
        for (i = 0; i < this.tickv.tickV.length; ++i) {
            this.drawLabelTick(g, findex[i], i);
        }
        this.tickLabeller.finished();
    }

    public void updatePlotImage(DasAxis xAxis, DasAxis yAxis) {
    }

    private static String lineToString(Line2D line) {
        return "" + line.getX1() + " " + line.getY1() + " " + line.getX2() + " " + line.getY2();
    }

    public TickStyle getTickStyle() {
        return this.tickStyle;
    }

    public void setTickStyle(TickStyle tickStyle) {
        this.tickStyle = tickStyle;
    }

    public double getLineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(double lineWidth) {
        this.lineWidth = lineWidth;
        this.stroke = new BasicStroke((float)lineWidth);
    }

    public float getTickLength() {
        return this.tickLength;
    }

    public void setTickLength(float tickLength) {
        this.tickLength = tickLength;
    }

    public DataSet getDataSet() {
        DataSetDescriptor dsd = this.getDataSetDescriptor();
        if (!(dsd instanceof ConstantDataSetDescriptor)) {
            throw new IllegalStateException("only ConstantDataSetDescriptors for now!");
        }
        try {
            return dsd.getDataSet(null, null, null, null);
        }
        catch (DasException e) {
            throw new RuntimeException(e);
        }
    }

    public void updatePlotImage(DasAxis xAxis, DasAxis yAxis, DasProgressMonitor monitor) {
    }

    protected Element getDOMElement(Document document) {
        throw new UnsupportedOperationException();
    }

    public static class TickStyle
    implements Enumeration {
        private String name;
        public static TickStyle outer = new TickStyle("Outer");
        public static TickStyle both = new TickStyle("Both");

        private TickStyle(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public Icon getListIcon() {
            return null;
        }
    }
}

