/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.graph;

import edu.uiowa.physics.pw.das.DasApplication;
import edu.uiowa.physics.pw.das.DasException;
import edu.uiowa.physics.pw.das.DasNameException;
import edu.uiowa.physics.pw.das.DasPropertyException;
import edu.uiowa.physics.pw.das.components.HorizontalSpectrogramSlicer;
import edu.uiowa.physics.pw.das.components.VerticalSpectrogramAverager;
import edu.uiowa.physics.pw.das.components.VerticalSpectrogramSlicer;
import edu.uiowa.physics.pw.das.components.propertyeditor.Enumeration;
import edu.uiowa.physics.pw.das.dasml.FormBase;
import edu.uiowa.physics.pw.das.dataset.AverageTableRebinner;
import edu.uiowa.physics.pw.das.dataset.DataSetDescriptor;
import edu.uiowa.physics.pw.das.dataset.DataSetRebinner;
import edu.uiowa.physics.pw.das.dataset.DefaultTableDataSet;
import edu.uiowa.physics.pw.das.dataset.NearestNeighborTableRebinner;
import edu.uiowa.physics.pw.das.dataset.RebinDescriptor;
import edu.uiowa.physics.pw.das.dataset.TableDataSet;
import edu.uiowa.physics.pw.das.dataset.TableDataSetConsumer;
import edu.uiowa.physics.pw.das.datum.Units;
import edu.uiowa.physics.pw.das.event.CrossHairMouseModule;
import edu.uiowa.physics.pw.das.event.DasMouseInputAdapter;
import edu.uiowa.physics.pw.das.event.DumpToFileMouseModule;
import edu.uiowa.physics.pw.das.event.HorizontalDragRangeSelectorMouseModule;
import edu.uiowa.physics.pw.das.event.HorizontalSlicerMouseModule;
import edu.uiowa.physics.pw.das.event.MouseModule;
import edu.uiowa.physics.pw.das.event.VerticalSlicerMouseModule;
import edu.uiowa.physics.pw.das.graph.DasAxis;
import edu.uiowa.physics.pw.das.graph.DasColorBar;
import edu.uiowa.physics.pw.das.graph.DasColumn;
import edu.uiowa.physics.pw.das.graph.DasPlot;
import edu.uiowa.physics.pw.das.graph.Renderer;
import edu.uiowa.physics.pw.das.util.DasDie;
import edu.uiowa.physics.pw.das.util.DasExceptionHandler;
import edu.uiowa.physics.pw.das.util.DasProgressMonitor;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.MemoryImageSource;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Collections;
import javax.swing.Icon;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SpectrogramRenderer
extends Renderer
implements TableDataSetConsumer {
    private DasColorBar colorBar;
    Image plotImage;
    RebinListener rebinListener = new RebinListener();
    private RebinnerEnum rebinnerEnum;
    int count = 0;
    private boolean sliceRebinnedData = true;
    static /* synthetic */ Class class$edu$uiowa$physics$pw$das$graph$DasColorBar;

    public SpectrogramRenderer(DataSetDescriptor dsd, DasColorBar colorBar) {
        super(dsd);
        this.colorBar = colorBar;
        if (this.colorBar != null) {
            colorBar.addPropertyChangeListener("dataMinimum", this.rebinListener);
            colorBar.addPropertyChangeListener("dataMaximum", this.rebinListener);
            colorBar.addPropertyChangeListener("log", this.rebinListener);
            colorBar.addPropertyChangeListener("type", this.rebinListener);
        }
        this.setRebinner(RebinnerEnum.binAverage);
    }

    public SpectrogramRenderer(DasPlot parent, DataSetDescriptor dsd, DasColorBar colorBar) {
        this(dsd, colorBar);
        this.parent = parent;
    }

    public DasAxis getZAxis() {
        return this.colorBar;
    }

    public DasColorBar getColorBar() {
        return this.colorBar;
    }

    public void setColorBar(DasColorBar cb) {
        if (this.colorBar == cb) {
            return;
        }
        if (this.colorBar != null) {
            this.colorBar.removePropertyChangeListener("dataMinimum", this.rebinListener);
            this.colorBar.removePropertyChangeListener("dataMaximum", this.rebinListener);
            this.colorBar.removePropertyChangeListener("log", this.rebinListener);
            this.colorBar.removePropertyChangeListener("type", this.rebinListener);
            if (this.parent != null && this.parent.getCanvas() != null) {
                this.parent.getCanvas().remove(this.colorBar);
            }
        }
        this.colorBar = cb;
        if (this.colorBar != null) {
            this.colorBar.addPropertyChangeListener("dataMinimum", this.rebinListener);
            this.colorBar.addPropertyChangeListener("dataMaximum", this.rebinListener);
            this.colorBar.addPropertyChangeListener("log", this.rebinListener);
            this.colorBar.addPropertyChangeListener("type", this.rebinListener);
            if (this.parent != null && this.parent.getCanvas() != null) {
                this.parent.getCanvas().add(this.colorBar);
            }
        }
    }

    public void render(Graphics g, DasAxis xAxis, DasAxis yAxis) {
        if (this.getDataSet() == null && this.lastException != null) {
            this.renderException(g, xAxis, yAxis, this.lastException);
        } else if (this.plotImage != null) {
            int x = xAxis.getColumn().getDMinimum();
            int y = yAxis.getRow().getDMinimum();
            g.drawImage(this.plotImage, x, y, this.getParent());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void updatePlotImage(DasAxis xAxis, DasAxis yAxis, DasProgressMonitor monitor) throws DasException {
        block22: {
            block21: {
                block20: {
                    block19: {
                        try {
                            if (monitor != null) {
                                if (monitor.isCancelled()) {
                                    Object var18_4 = null;
                                    if (monitor != null) {
                                        if (monitor.isCancelled()) {
                                            return;
                                        }
                                        monitor.finished();
                                    }
                                    break block19;
                                }
                                monitor.setTaskSize(-1L);
                                monitor.started();
                            }
                            int w = xAxis.getColumn().getDMaximum() - xAxis.getColumn().getDMinimum();
                            int h = yAxis.getRow().getDMaximum() - yAxis.getRow().getDMinimum();
                            if (this.getParent() == null || w <= 1 || h <= 1) {
                                DasDie.println("canvas not useable!!!");
                                break block20;
                            }
                            int[] pix = new int[w * h];
                            Arrays.fill(pix, 0);
                            if (this.getDataSet() == null) {
                                double[] yTags;
                                Units xUnits = this.getParent().getXAxis().getUnits();
                                Units yUnits = this.getParent().getYAxis().getUnits();
                                Units zUnits = this.getColorBar().getUnits();
                                double[] xTags = yTags = new double[0];
                                double[][] zValues = new double[][]{yTags};
                                DefaultTableDataSet rebinData = new DefaultTableDataSet(xTags, xUnits, yTags, yUnits, zValues, zUnits, Collections.EMPTY_MAP);
                                this.plotImage = null;
                                rebinData = null;
                                this.getParent().repaint();
                                break block21;
                            }
                            RebinDescriptor xRebinDescriptor = new RebinDescriptor(xAxis.getDataMinimum(), xAxis.getDataMaximum(), w, xAxis.isLog());
                            RebinDescriptor yRebinDescriptor = new RebinDescriptor(yAxis.getDataMinimum(), yAxis.getDataMaximum(), h, yAxis.isLog());
                            DataSetRebinner rebinner = this.rebinnerEnum.getRebinner();
                            TableDataSet rebinData = (TableDataSet)rebinner.rebin(this.getDataSet(), xRebinDescriptor, yRebinDescriptor);
                            int itable = 0;
                            int ny = rebinData.getYLength(itable);
                            int nx = rebinData.tableEnd(itable) - rebinData.tableStart(itable);
                            for (int i = rebinData.tableStart(itable); i < rebinData.tableEnd(itable); ++i) {
                                for (int j = 0; j < rebinData.getYLength(0); ++j) {
                                    int index = i - rebinData.tableStart(itable) + (ny - j - 1) * nx;
                                    pix[index] = this.colorBar.itransform(rebinData.getDouble(i, j, rebinData.getZUnits()), rebinData.getZUnits());
                                }
                            }
                            MemoryImageSource mis = new MemoryImageSource(w, h, pix, 0, w);
                            this.plotImage = this.getParent().createImage(mis);
                            if (this.isSliceRebinnedData()) {
                                DasApplication.getDefaultApplication().getLogger().fine("slicing rebin data");
                                this.ds = rebinData;
                            }
                            break block22;
                        }
                        catch (Throwable throwable) {
                            Object var18_8 = null;
                            if (monitor != null) {
                                if (monitor.isCancelled()) {
                                    return;
                                }
                                monitor.finished();
                            }
                            this.getParent().repaint();
                            throw throwable;
                        }
                    }
                    this.getParent().repaint();
                    return;
                }
                Object var18_5 = null;
                if (monitor != null) {
                    if (monitor.isCancelled()) {
                        return;
                    }
                    monitor.finished();
                }
                this.getParent().repaint();
                return;
            }
            Object var18_6 = null;
            if (monitor != null) {
                if (monitor.isCancelled()) {
                    return;
                }
                monitor.finished();
            }
            this.getParent().repaint();
            return;
        }
        Object var18_7 = null;
        if (monitor != null) {
            if (monitor.isCancelled()) {
                return;
            }
            monitor.finished();
        }
        this.getParent().repaint();
    }

    protected void installRenderer() {
        if (this.parent != null && this.parent.getCanvas() != null && this.colorBar != null) {
            if (this.colorBar.getColumn() == DasColumn.NULL) {
                DasColumn column = this.parent.getColumn();
                double columnWidth = column.getMaximum() - column.getMinimum();
                double cbMin = column.getMaximum() + columnWidth / 5.0;
                double cbMax = cbMin + columnWidth / 10.0;
                if (cbMax > 1.0 - columnWidth / 5.0) {
                    double cbWidth = (1.0 - column.getMaximum()) / 3.0;
                    cbMin = column.getMaximum() + cbWidth / 2.0;
                    cbMax = cbMin + cbWidth;
                }
                this.colorBar.setColumn(new DasColumn(this.parent.getCanvas(), cbMin, cbMax));
            }
            this.parent.getCanvas().add(this.colorBar, this.parent.getRow(), this.colorBar.getColumn());
            if (!"true".equals(System.getProperty("java.awt.headless"))) {
                DasMouseInputAdapter mouseAdapter = this.parent.mouseAdapter;
                VerticalSpectrogramSlicer vSlicer = VerticalSpectrogramSlicer.createSlicer(this.parent, this);
                VerticalSlicerMouseModule vsl = VerticalSlicerMouseModule.create(this);
                vsl.addDataPointSelectionListener(vSlicer);
                mouseAdapter.addMouseModule(vsl);
                HorizontalSpectrogramSlicer hSlicer = HorizontalSpectrogramSlicer.createSlicer(this.parent, this);
                HorizontalSlicerMouseModule hsl = HorizontalSlicerMouseModule.create(this);
                hsl.addDataPointSelectionListener(hSlicer);
                mouseAdapter.addMouseModule(hsl);
                VerticalSpectrogramAverager vAverager = VerticalSpectrogramAverager.createAverager(this.parent, this);
                HorizontalDragRangeSelectorMouseModule vrl = new HorizontalDragRangeSelectorMouseModule(this.parent, this, this.parent.getXAxis());
                vrl.addDataRangeSelectionListener(vAverager);
                mouseAdapter.addMouseModule(vrl);
                MouseModule ch = new CrossHairMouseModule(this.parent, this, this.parent.getXAxis(), this.parent.getYAxis());
                mouseAdapter.addMouseModule(ch);
                ch = new DumpToFileMouseModule(this.parent, this, this.parent.getXAxis(), this.parent.getYAxis());
                mouseAdapter.addMouseModule(ch);
            }
        }
    }

    protected void uninstallRenderer() {
        if (this.colorBar != null && this.colorBar.getCanvas() != null) {
            this.colorBar.getCanvas().remove(this.colorBar);
        }
    }

    public static SpectrogramRenderer processSpectrogramElement(Element element, DasPlot parent, FormBase form) throws DasPropertyException, DasNameException, ParseException {
        String dataSetID = element.getAttribute("dataSetID");
        DasColorBar colorbar = null;
        NodeList children = element.getChildNodes();
        for (int index = 0; index < children.getLength(); ++index) {
            Node node = children.item(index);
            if (!(node instanceof Element) || !node.getNodeName().equals("zAxis")) continue;
            colorbar = SpectrogramRenderer.processZAxisElement((Element)node, form);
        }
        if (colorbar == null) {
            try {
                colorbar = (DasColorBar)form.checkValue(element.getAttribute("colorbar"), class$edu$uiowa$physics$pw$das$graph$DasColorBar == null ? (class$edu$uiowa$physics$pw$das$graph$DasColorBar = SpectrogramRenderer.class$("edu.uiowa.physics.pw.das.graph.DasColorBar")) : class$edu$uiowa$physics$pw$das$graph$DasColorBar, "<colorbar>");
            }
            catch (DasPropertyException dpe) {
                dpe.setPropertyName("colorbar");
                throw dpe;
            }
        }
        SpectrogramRenderer renderer = new SpectrogramRenderer(parent, null, colorbar);
        try {
            renderer.setDataSetID(dataSetID);
        }
        catch (DasException de) {
            DasExceptionHandler.handle(de);
        }
        return renderer;
    }

    private static DasColorBar processZAxisElement(Element element, FormBase form) throws DasPropertyException, DasNameException, ParseException {
        NodeList children = element.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node node = children.item(i);
            if (!(node instanceof Element) || !node.getNodeName().equals("colorbar")) continue;
            return DasColorBar.processColorbarElement((Element)node, form);
        }
        return null;
    }

    public Element getDOMElement(Document document) {
        Element element = document.createElement("spectrogram");
        element.setAttribute("dataSetID", this.getDataSetID());
        Element zAxisChild = document.createElement("zAxis");
        Element zAxisElement = this.getColorBar().getDOMElement(document);
        if (zAxisElement.getAttribute("row").equals(this.getParent().getRow().getDasName())) {
            zAxisElement.removeAttribute("row");
        }
        if (zAxisElement.getAttribute("column").equals(this.getParent().getColumn().getDasName())) {
            zAxisElement.removeAttribute("column");
        }
        zAxisChild.appendChild(zAxisElement);
        element.appendChild(zAxisChild);
        return element;
    }

    public RebinnerEnum getRebinner() {
        return this.rebinnerEnum;
    }

    public void setRebinner(RebinnerEnum rebinnerEnum) {
        this.rebinnerEnum = rebinnerEnum;
        this.refreshImage();
    }

    public boolean isSliceRebinnedData() {
        return this.sliceRebinnedData;
    }

    public void setSliceRebinnedData(boolean sliceRebinnedData) {
        this.sliceRebinnedData = sliceRebinnedData;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class RebinnerEnum
    implements Enumeration {
        DataSetRebinner rebinner;
        String label;
        public static final RebinnerEnum binAverage = new RebinnerEnum(new AverageTableRebinner(), "binAverage");
        public static final RebinnerEnum nearestNeighbor = new RebinnerEnum(new NearestNeighborTableRebinner(), "nearestNeighbor");
        public static final RebinnerEnum binAverageNoInterpolate;
        public static final RebinnerEnum binAverageNoInterpolateNoEnlarge;

        private RebinnerEnum(DataSetRebinner rebinner, String label) {
            this.rebinner = rebinner;
            this.label = label;
        }

        public Icon getListIcon() {
            return null;
        }

        public String toString() {
            return this.label;
        }

        DataSetRebinner getRebinner() {
            return this.rebinner;
        }

        static {
            AverageTableRebinner rebinner = new AverageTableRebinner();
            rebinner.setInterpolate(false);
            binAverageNoInterpolate = new RebinnerEnum(rebinner, "noInterpolate");
            rebinner = new AverageTableRebinner();
            rebinner.setInterpolate(false);
            rebinner.setEnlargePixels(false);
            binAverageNoInterpolateNoEnlarge = new RebinnerEnum(rebinner, "noInterpolateNoEnlarge");
        }
    }

    protected class RebinListener
    implements PropertyChangeListener {
        protected RebinListener() {
        }

        public void propertyChange(PropertyChangeEvent e) {
            SpectrogramRenderer.this.update();
        }
    }
}

