/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.graph;

import edu.uiowa.physics.pw.das.DasException;
import edu.uiowa.physics.pw.das.dataset.DataSetDescriptor;
import edu.uiowa.physics.pw.das.dataset.DataSetUpdateEvent;
import edu.uiowa.physics.pw.das.dataset.DataSetUpdateListener;
import edu.uiowa.physics.pw.das.dataset.VectorDataSet;
import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.UnitsConverter;
import edu.uiowa.physics.pw.das.graph.DasAxis;
import edu.uiowa.physics.pw.das.graph.DasCanvasComponent;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.event.MouseInputAdapter;

public class DasEventsIndicator
extends DasCanvasComponent
implements DataSetUpdateListener {
    DasAxis axis;
    DataSetDescriptor dsd;
    VectorDataSet vds;
    String planeId;
    int[] eventMap;

    public DasEventsIndicator(DataSetDescriptor dsd, DasAxis axis, String planeId) {
        if (!axis.isHorizontal()) {
            throw new IllegalArgumentException("Axis must be horizontal");
        }
        this.axis = axis;
        this.dsd = dsd;
        dsd.addDataSetUpdateListener(this);
        axis.addPropertyChangeListener("dataMinimum", this.getPropertyChangeListener());
        axis.addPropertyChangeListener("dataMaximum", this.getPropertyChangeListener());
        axis.addPropertyChangeListener("log", this.getPropertyChangeListener());
        MyMouseAdapter ma = new MyMouseAdapter(this, planeId);
        this.addMouseListener(ma);
        this.addMouseMotionListener(ma);
    }

    private PropertyChangeListener getPropertyChangeListener() {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                DasEventsIndicator.this.markDirty();
                DasEventsIndicator.this.update();
            }
        };
    }

    public void paint(Graphics g1) {
        Graphics2D g = (Graphics2D)g1;
        g.translate(-this.getX(), -this.getY());
        g.setColor(Color.white);
        g.fill(this.getBounds());
        g.setColor(Color.DARK_GRAY);
        g.draw(new Rectangle(this.getX(), this.getY(), this.getWidth() - 1, this.getHeight() - 1));
        g.setColor(new Color(100, 100, 100, 180));
        this.eventMap = new int[this.getWidth()];
        try {
            this.vds = (VectorDataSet)this.dsd.getDataSet(this.axis.getDataMinimum(), this.axis.getDataMaximum(), null, null);
            if (this.vds.getPlanarView("xTagWidth") == null) {
                throw new IllegalArgumentException("no xTagWidth plane found.");
            }
            VectorDataSet widthsDs = (VectorDataSet)this.vds.getPlanarView("xTagWidth");
            for (int k = 0; k < this.eventMap.length; ++k) {
                this.eventMap[k] = -1;
            }
            if (this.vds.getXLength() > 0) {
                UnitsConverter uc = UnitsConverter.getConverter(widthsDs.getYUnits(), this.axis.getUnits().getOffsetUnits());
                int ivds0 = 0;
                int ivds1 = this.vds.getXLength();
                for (int i = ivds0; i < ivds1; ++i) {
                    int iwidth;
                    Datum x = this.vds.getXTagDatum(i);
                    int ix = (int)this.axis.transform(x);
                    if (uc != null) {
                        Datum y = widthsDs.getDatum(i);
                        iwidth = (int)this.axis.transform(x.add(y)) - ix;
                    } else {
                        iwidth = 1;
                    }
                    if (this.getColumn().getDMinimum() >= ix + iwidth && this.getColumn().getDMaximum() <= ix) continue;
                    if (iwidth == 0) {
                        iwidth = 1;
                    }
                    g.fill(new Rectangle(ix, this.getY(), iwidth, this.getHeight()));
                    int im = ix - this.getX();
                    int em0 = im - 1;
                    int em1 = im + iwidth + 1;
                    for (int k = em0; k < em1; ++k) {
                        if (k < 0 || k >= this.eventMap.length) continue;
                        this.eventMap[k] = i;
                    }
                }
                for (int k1 = 1; k1 <= 2; ++k1) {
                    for (int k2 = -1; k2 <= 1; k2 += 2) {
                        int em0 = k2 == 1 ? 0 : this.eventMap.length - 1;
                        int em1 = k2 == 1 ? this.eventMap.length - k1 : k1;
                        for (int k = em0; k != em1; k += k2) {
                            if (this.eventMap[k] != -1) continue;
                            this.eventMap[k] = this.eventMap[k + k2];
                        }
                    }
                }
            }
        }
        catch (DasException e) {
            g.drawString("exception: " + e.getMessage(), this.getX(), this.getY() + this.getHeight());
        }
    }

    public void setDataSetDescriptor(DataSetDescriptor dsd) {
        this.dsd = dsd;
        this.markDirty();
        this.update();
    }

    public void dataSetUpdated(DataSetUpdateEvent e) {
        this.markDirty();
        this.update();
    }

    class MyMouseAdapter
    extends MouseInputAdapter {
        DasEventsIndicator parent;
        String planeId;

        MyMouseAdapter(DasEventsIndicator parent, String planeId) {
            this.parent = parent;
            this.planeId = planeId;
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mouseMoved(MouseEvent e) {
            if (this.parent.vds == null) {
                return;
            }
            if (this.parent.vds.getXLength() == 0) {
                return;
            }
            int ix = e.getX() + this.parent.getX();
            Datum x = this.parent.axis.invTransform(ix);
            int i = DasEventsIndicator.this.eventMap[e.getX()];
            if (i >= 0) {
                Datum sx = this.parent.vds.getXTagDatum(i);
                Datum sz = this.parent.vds.getDatum(i);
                VectorDataSet widthsDs = (VectorDataSet)DasEventsIndicator.this.vds.getPlanarView("xTagWidth");
                Datum sy = widthsDs.getDatum(i);
                this.parent.setToolTipText("" + sx + " " + sy + " " + sz);
            } else {
                this.parent.setToolTipText(null);
            }
        }
    }
}

