/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.graph;

import edu.uiowa.physics.pw.das.DasApplication;
import edu.uiowa.physics.pw.das.DasNameException;
import edu.uiowa.physics.pw.das.DasPropertyException;
import edu.uiowa.physics.pw.das.NameContext;
import edu.uiowa.physics.pw.das.components.propertyeditor.Enumeration;
import edu.uiowa.physics.pw.das.dasml.FormBase;
import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.TimeUtil;
import edu.uiowa.physics.pw.das.datum.Units;
import edu.uiowa.physics.pw.das.graph.AttachedColumn;
import edu.uiowa.physics.pw.das.graph.DasAxis;
import edu.uiowa.physics.pw.das.graph.DasColumn;
import edu.uiowa.physics.pw.das.graph.DasRow;
import edu.uiowa.physics.pw.das.util.DasExceptionHandler;
import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.text.ParseException;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DasColorBar
extends DasAxis {
    private BufferedImage image;
    private Type type;
    static /* synthetic */ Class class$edu$uiowa$physics$pw$das$graph$DasRow;
    static /* synthetic */ Class class$edu$uiowa$physics$pw$das$graph$DasColumn;

    public DasColorBar(Datum min, Datum max, boolean isLog) {
        this(min, max, 4, isLog);
    }

    public DasColorBar(Datum min, Datum max, int orientation, boolean isLog) {
        super(min, max, orientation, isLog);
        this.setLayout(new ColorBarLayoutManager());
        this.setType(Type.COLOR_WEDGE);
    }

    public int itransform(double x, Units units) {
        int ncolor = this.type.getColorCount();
        int icolor = (int)this.transform(x, units, 0, ncolor);
        if (units.isFill(x)) {
            return Color.LIGHT_GRAY.getRGB();
        }
        icolor = icolor < 0 ? 0 : icolor;
        icolor = icolor >= ncolor ? ncolor - 1 : icolor;
        return this.type.getRGB(icolor);
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        if (this.type == type) {
            return;
        }
        Type oldValue = this.type;
        this.type = type;
        this.image = null;
        this.markDirty();
        this.update();
        this.firePropertyChange("type", oldValue, type);
    }

    protected void paintComponent(Graphics g) {
        int x = Math.round(this.getColumn().getDMinimum());
        int y = Math.round(this.getRow().getDMinimum());
        int width = Math.round(this.getColumn().getDMaximum()) - x;
        int height = Math.round(this.getRow().getDMaximum()) - y;
        if (this.image == null || this.image.getWidth() != width || this.image.getHeight() != height) {
            this.image = this.isHorizontal() ? this.type.getHorizontalScaledImage(width, height) : this.type.getVerticalScaledImage(width, height);
        }
        g.translate(-this.getX(), -this.getY());
        if (!this.isHorizontal()) {
            ++y;
        }
        g.drawImage(this.image, x, y, this);
        g.translate(this.getX(), this.getY());
        super.paintComponent(g);
    }

    protected Rectangle getAxisBounds() {
        int x = Math.round(this.getColumn().getDMinimum());
        int y = Math.round(this.getRow().getDMinimum());
        int width = Math.round(this.getColumn().getDMaximum()) - x;
        int height = Math.round(this.getRow().getDMaximum()) - y;
        Rectangle rc = new Rectangle(x, y, width, height);
        Rectangle bounds = super.getAxisBounds();
        bounds.add(rc);
        return bounds;
    }

    public static DasColumn getColorBarColumn(DasColumn column) {
        return new AttachedColumn(column, 1.05, 1.1);
    }

    static DasColorBar processColorbarElement(Element element, FormBase form) throws DasPropertyException, DasNameException, ParseException {
        String columnString;
        Datum dataMaximum;
        Datum dataMinimum;
        String name = element.getAttribute("name");
        boolean log = element.getAttribute("log").equals("true");
        String unitStr = element.getAttribute("units");
        if (unitStr == null) {
            unitStr = "";
        }
        if (unitStr.equals("TIME")) {
            String min = element.getAttribute("dataMinimum");
            String max = element.getAttribute("dataMaximum");
            dataMinimum = min == null || min.equals("") ? TimeUtil.create("1979-02-26") : TimeUtil.create(min);
            dataMaximum = max == null || max.equals("") ? TimeUtil.create("1979-02-27") : TimeUtil.create(max);
        } else {
            Units units = Units.getByName(unitStr);
            String min = element.getAttribute("dataMinimum");
            String max = element.getAttribute("dataMaximum");
            dataMinimum = min == null || min.equals("") ? Datum.create(1.0, units) : Datum.create(Double.parseDouble(min), units);
            dataMaximum = max == null || max.equals("") ? Datum.create(10.0, units) : Datum.create(Double.parseDouble(max), units);
        }
        int orientation = DasColorBar.parseOrientationString(element.getAttribute("orientation"));
        DasColorBar cb = new DasColorBar(dataMinimum, dataMaximum, orientation, log);
        String rowString = element.getAttribute("row");
        if (!rowString.equals("")) {
            DasRow row = (DasRow)form.checkValue(rowString, class$edu$uiowa$physics$pw$das$graph$DasRow == null ? (class$edu$uiowa$physics$pw$das$graph$DasRow = DasColorBar.class$("edu.uiowa.physics.pw.das.graph.DasRow")) : class$edu$uiowa$physics$pw$das$graph$DasRow, "<row>");
            cb.setRow(row);
        }
        if (!(columnString = element.getAttribute("column")).equals("")) {
            DasColumn column = (DasColumn)form.checkValue(columnString, class$edu$uiowa$physics$pw$das$graph$DasColumn == null ? (class$edu$uiowa$physics$pw$das$graph$DasColumn = DasColorBar.class$("edu.uiowa.physics.pw.das.graph.DasColumn")) : class$edu$uiowa$physics$pw$das$graph$DasColumn, "<column>");
            cb.setColumn(column);
        }
        cb.setLabel(element.getAttribute("label"));
        cb.setOppositeAxisVisible(!element.getAttribute("oppositeAxisVisible").equals("false"));
        cb.setTickLabelsVisible(!element.getAttribute("tickLabelsVisible").equals("false"));
        cb.setType(Type.parse(element.getAttribute("type")));
        cb.setDasName(name);
        DasApplication app = form.getDasApplication();
        NameContext nc = app.getNameContext();
        nc.put(name, cb);
        return cb;
    }

    public Element getDOMElement(Document document) {
        Element element = document.createElement("colorbar");
        String minimumStr = this.getDataMinimum().toString();
        element.setAttribute("dataMinimum", minimumStr);
        String maximumStr = this.getDataMaximum().toString();
        element.setAttribute("dataMaximum", maximumStr);
        element.setAttribute("name", this.getDasName());
        element.setAttribute("row", this.getRow().getDasName());
        element.setAttribute("column", this.getColumn().getDasName());
        element.setAttribute("label", this.getLabel());
        element.setAttribute("log", Boolean.toString(this.isLog()));
        element.setAttribute("tickLabelsVisible", Boolean.toString(this.areTickLabelsVisible()));
        element.setAttribute("oppositeAxisVisible", Boolean.toString(this.isOppositeAxisVisible()));
        element.setAttribute("animated", Boolean.toString(this.isAnimated()));
        element.setAttribute("orientation", DasColorBar.orientationToString(this.getOrientation()));
        element.setAttribute("type", this.getType().toString());
        return element;
    }

    public static DasColorBar createNamedColorBar(String name) {
        DasColorBar cb = new DasColorBar(Datum.create(1.0, Units.dimensionless), Datum.create(10.0, Units.dimensionless), false);
        if (name == null) {
            name = "colorbar_" + Integer.toHexString(System.identityHashCode(cb));
        }
        try {
            cb.setDasName(name);
        }
        catch (DasNameException dne) {
            DasExceptionHandler.handle(dne);
        }
        return cb;
    }

    public Shape getActiveRegion() {
        int x = Math.round(this.getColumn().getDMinimum());
        int y = Math.round(this.getRow().getDMinimum());
        int width = Math.round(this.getColumn().getDMaximum()) - x;
        int height = Math.round(this.getRow().getDMaximum()) - y;
        Rectangle bounds = this.primaryInputPanel.getBounds();
        bounds.translate(this.getX(), this.getY());
        Rectangle middleBounds = new Rectangle(x, y, width, height);
        bounds.add(middleBounds);
        if (this.isOppositeAxisVisible()) {
            Rectangle secondaryBounds = this.secondaryInputPanel.getBounds();
            secondaryBounds.translate(this.getX(), this.getY());
            bounds.add(secondaryBounds);
        }
        return bounds;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static final class Type
    implements Enumeration {
        public static final Type COLOR_WEDGE = new Type("color_wedge");
        public static final Type GRAYSCALE = new Type("grayscale");
        public static final Type INVERSE_GRAYSCALE = new Type("inverse_grayscale");
        private BufferedImage image;
        private int[] colorTable;
        private final String desc;
        private Icon icon;

        private Type(String desc) {
            this.desc = desc;
        }

        public Icon getListIcon() {
            this.maybeInitializeIcon();
            return this.icon;
        }

        public void maybeInitializeIcon() {
            if (this.icon == null) {
                this.icon = new ImageIcon(this.getVerticalScaledImage(24, 24));
            }
        }

        public String toString() {
            return this.desc;
        }

        public int getColorCount() {
            this.maybeInitializeColorTable();
            return this.colorTable.length;
        }

        public int getRGB(int index) {
            this.maybeInitializeColorTable();
            return this.colorTable[index];
        }

        public BufferedImage getHorizontalScaledImage(int width, int height) {
            this.maybeInitializeImage();
            BufferedImage scaled = new BufferedImage(width, height, 1);
            AffineTransform at = new AffineTransform();
            at.scale((double)width / (double)this.colorTable.length, height);
            at.rotate(-1.5707963267948966);
            at.translate(-1.0, 0.0);
            AffineTransformOp op = new AffineTransformOp(at, 2);
            op.filter(this.image, scaled);
            return scaled;
        }

        public BufferedImage getVerticalScaledImage(int width, int height) {
            this.maybeInitializeImage();
            BufferedImage scaled = new BufferedImage(width, height, 1);
            AffineTransform at = new AffineTransform();
            at.scale(width, -((double)height) / (double)this.colorTable.length);
            at.translate(0.0, -((double)this.colorTable.length));
            AffineTransformOp op = new AffineTransformOp(at, 2);
            op.filter(this.image, scaled);
            return scaled;
        }

        private void maybeInitializeImage() {
            if (this.image == null) {
                this.maybeInitializeColorTable();
                this.image = new BufferedImage(1, this.colorTable.length, 1);
                this.image.setRGB(0, 0, 1, this.colorTable.length, this.colorTable, 0, 1);
            }
        }

        private void maybeInitializeColorTable() {
            if (this.colorTable == null) {
                if (this == COLOR_WEDGE) {
                    this.initializeColorWedge();
                } else if (this == GRAYSCALE) {
                    this.initializeGrayScale();
                } else if (this == INVERSE_GRAYSCALE) {
                    this.initializeInverseGrayScale();
                }
            }
        }

        private void initializeColorWedge() {
            int[] index = new int[]{0, 30, 63, 126, 162, 192, 221, 255};
            int[] red = new int[]{0, 0, 0, 0, 255, 255, 255, 255};
            int[] green = new int[]{0, 0, 255, 255, 255, 185, 84, 0};
            int[] blue = new int[]{137, 255, 255, 0, 0, 0, 0, 0};
            this.colorTable = new int[256];
            int ii = 0;
            for (int i = 0; i < this.colorTable.length; ++i) {
                if (i > index[ii + 1]) {
                    ++ii;
                }
                double a = (double)(i - index[ii]) / (double)(index[ii + 1] - index[ii]);
                double rr = ((double)red[ii] * (1.0 - a) + (double)red[ii + 1] * a) / 255.0;
                double gg = ((double)green[ii] * (1.0 - a) + (double)green[ii + 1] * a) / 255.0;
                double bb = ((double)blue[ii] * (1.0 - a) + (double)blue[ii + 1] * a) / 255.0;
                this.colorTable[i] = new Color((float)rr, (float)gg, (float)bb).getRGB();
            }
            this.colorTable[0] = this.colorTable[0] & 0xFFFFFF00 | 1;
        }

        private void initializeInverseGrayScale() {
            this.colorTable = new int[256];
            for (int i = 0; i < 256; ++i) {
                this.colorTable[i] = 0xFF000000 | i << 16 | i << 8 | i;
            }
        }

        private void initializeGrayScale() {
            this.colorTable = new int[256];
            for (int i = 255; i >= 0; --i) {
                this.colorTable[255 - i] = 0xFF000000 | i << 16 | i << 8 | i;
            }
        }

        public static Type parse(String s) {
            if (s.equals("color_wedge")) {
                return COLOR_WEDGE;
            }
            if (s.equals("grayscale")) {
                return GRAYSCALE;
            }
            if (s.equals("inverse_grayscale")) {
                return INVERSE_GRAYSCALE;
            }
            throw new IllegalArgumentException("invalid DasColorBar.Type string: " + s);
        }
    }

    protected class ColorBarLayoutManager
    extends DasAxis.AxisLayoutManager {
        protected ColorBarLayoutManager() {
        }

        public void layoutContainer(Container parent) {
            super.layoutContainer(parent);
            int x = Math.round(DasColorBar.this.getColumn().getDMinimum());
            int y = Math.round(DasColorBar.this.getRow().getDMinimum());
            int width = Math.round(DasColorBar.this.getColumn().getDMaximum()) - x;
            int height = Math.round(DasColorBar.this.getRow().getDMaximum()) - y;
            Rectangle rc = new Rectangle(x - DasColorBar.this.getX(), y - DasColorBar.this.getY(), width, height);
            Rectangle bounds = DasColorBar.this.primaryInputPanel.getBounds();
            bounds.add(rc);
            DasColorBar.this.primaryInputPanel.setBounds(bounds);
        }
    }
}

