/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.graph;

import edu.uiowa.physics.pw.das.DasApplication;
import edu.uiowa.physics.pw.das.DasNameException;
import edu.uiowa.physics.pw.das.components.propertyeditor.Editable;
import edu.uiowa.physics.pw.das.components.propertyeditor.PropertyEditor;
import edu.uiowa.physics.pw.das.event.DasMouseInputAdapter;
import edu.uiowa.physics.pw.das.event.MouseModule;
import edu.uiowa.physics.pw.das.graph.DasCanvas;
import edu.uiowa.physics.pw.das.graph.DasColumn;
import edu.uiowa.physics.pw.das.graph.DasRow;
import edu.uiowa.physics.pw.das.graph.event.DasUpdateEvent;
import edu.uiowa.physics.pw.das.graph.event.DasUpdateListener;
import java.awt.AWTEvent;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public abstract class DasCanvasComponent
extends JComponent
implements Editable {
    private static final MouseListener currentComponentListener = new MouseAdapter(){

        public void mousePressed(MouseEvent e) {
            DasCanvas canvas;
            DasCanvasComponent dcc = e.getSource() instanceof DasCanvasComponent ? (DasCanvasComponent)e.getComponent() : (DasCanvasComponent)SwingUtilities.getAncestorOfClass(class$edu$uiowa$physics$pw$das$graph$DasCanvasComponent == null ? (class$edu$uiowa$physics$pw$das$graph$DasCanvasComponent = DasCanvasComponent.class$("edu.uiowa.physics.pw.das.graph.DasCanvasComponent")) : class$edu$uiowa$physics$pw$das$graph$DasCanvasComponent, e.getComponent());
            CanvasComponentAction.currentCanvasComponent = dcc;
            DasCanvas.CanvasAction.currentCanvas = canvas = dcc.getCanvas();
        }
    };
    public static final Action PROPERTIES_ACTION = new CanvasComponentAction("Properties"){

        public void actionPerformed(ActionEvent e) {
            if (2.getCurrentComponent() != null) {
                2.getCurrentComponent().showProperties();
            }
        }
    };
    private DasRow row;
    private DasColumn column;
    private ResizeListener rl;
    protected DasMouseInputAdapter mouseAdapter;
    private String dasName;
    private edu.uiowa.physics.pw.das.event.DasUpdateEvent devt;
    boolean dirty = true;
    static /* synthetic */ Class class$edu$uiowa$physics$pw$das$graph$DasCanvasComponent;

    public DasCanvasComponent() {
        this.setOpaque(false);
        this.rl = new ResizeListener();
        this.row = DasRow.NULL;
        this.column = DasColumn.NULL;
        this.mouseAdapter = new DasMouseInputAdapter(this);
        this.addMouseListener(this.mouseAdapter);
        this.addMouseMotionListener(this.mouseAdapter);
        this.addMouseListener(currentComponentListener);
        this.addKeyListener(this.mouseAdapter.getKeyAdapter());
        try {
            this.setDasName("c_" + Integer.toString(this.hashCode()));
        }
        catch (DasNameException dasNameException) {
            // empty catch block
        }
    }

    public void addMouseModule(MouseModule module) {
        this.mouseAdapter.addMouseModule(module);
    }

    public void removeMouseModule(MouseModule module) {
        this.mouseAdapter.removeMouseModule(module);
    }

    public DasRow getRow() {
        return this.row;
    }

    public DasColumn getColumn() {
        return this.column;
    }

    public void resize() {
        if (this.column == DasColumn.NULL || this.row == DasRow.NULL) {
            Logger logger = DasApplication.getDefaultApplication().getLogger();
            logger.warning("Null row and/or column in resize: row=" + this.row + " column=" + this.column);
        } else {
            this.setBounds(this.column.getDMinimum(), this.row.getDMinimum(), this.column.getDMaximum() - this.column.getDMinimum(), this.row.getDMaximum() - this.row.getDMinimum());
        }
    }

    public void setRow(DasRow r) {
        if (this.row == r) {
            return;
        }
        DasRow oldValue = this.row;
        if (this.row != DasRow.NULL) {
            this.row.removepwUpdateListener(this.rl);
        }
        this.row = r;
        if (this.row != DasRow.NULL) {
            this.row.addpwUpdateListener(this.rl);
        }
        this.firePropertyChange("row", oldValue, r);
    }

    public void setColumn(DasColumn c) {
        if (this.column == c) {
            return;
        }
        DasColumn oldValue = this.column;
        if (this.column != DasColumn.NULL) {
            this.column.removepwUpdateListener(this.rl);
        }
        this.column = c;
        if (this.column != DasColumn.NULL) {
            this.column.addpwUpdateListener(this.rl);
        }
        this.firePropertyChange("column", oldValue, c);
    }

    public void showProperties() {
        PropertyEditor editor = new PropertyEditor(this);
        editor.showDialog(this);
    }

    public String toString() {
        return this.getClass().getName() + "'" + this.getName() + "'";
    }

    protected void updateImmediately() {
    }

    public void update() {
        EventQueue eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
        if (this.devt == null) {
            this.devt = new edu.uiowa.physics.pw.das.event.DasUpdateEvent(this);
        }
        eventQueue.postEvent(this.devt);
    }

    protected void processEvent(AWTEvent e) {
        super.processEvent(e);
        if (e instanceof edu.uiowa.physics.pw.das.event.DasUpdateEvent) {
            this.processDasUpdateEvent((edu.uiowa.physics.pw.das.event.DasUpdateEvent)e);
        }
    }

    protected void processDasUpdateEvent(edu.uiowa.physics.pw.das.event.DasUpdateEvent e) {
        if (this.isDisplayable()) {
            if (this.isDirty()) {
                this.markClean();
                this.updateImmediately();
            }
            this.resize();
            this.repaint();
        }
    }

    protected AWTEvent coalesceEvents(AWTEvent existingEvent, AWTEvent newEvent) {
        if (existingEvent instanceof edu.uiowa.physics.pw.das.event.DasUpdateEvent && newEvent instanceof edu.uiowa.physics.pw.das.event.DasUpdateEvent) {
            return existingEvent;
        }
        return super.coalesceEvents(existingEvent, newEvent);
    }

    protected void installComponent() {
    }

    protected void uninstallComponent() {
    }

    public Font getFont() {
        return this.getParent() == null ? super.getFont() : this.getParent().getFont();
    }

    void markDirty() {
        this.dirty = true;
    }

    boolean isDirty() {
        return this.dirty;
    }

    void markClean() {
        this.dirty = false;
    }

    public DasCanvas getCanvas() {
        return (DasCanvas)this.getParent();
    }

    public String getDasName() {
        return this.dasName;
    }

    public void setDasName(String name) throws DasNameException {
        if (name.equals(this.dasName)) {
            return;
        }
        String oldName = this.dasName;
        this.dasName = name;
        DasApplication app = null;
        if (this.getCanvas() != null) {
            app = this.getCanvas().getDasApplication();
        }
        if (app != null) {
            app.getNameContext().put(name, this);
            if (oldName != null) {
                app.getNameContext().remove(oldName);
            }
        }
        this.firePropertyChange("name", oldName, name);
    }

    public Shape getActiveRegion() {
        int x = this.getColumn().getDMinimum();
        int y = this.getRow().getDMinimum();
        int width = this.getColumn().getDMaximum() - x;
        int height = this.getRow().getDMaximum() - y;
        return new Rectangle(x, y, width, height);
    }

    public DasMouseInputAdapter getMouseAdapter() {
        return this.mouseAdapter;
    }

    public Action[] getActions() {
        return new Action[]{PROPERTIES_ACTION};
    }

    public DasMouseInputAdapter getDasMouseInputAdapter() {
        return this.mouseAdapter;
    }

    public void setDasMouseInputAdapter(DasMouseInputAdapter dasMouseInputAdapter) {
        this.mouseAdapter = dasMouseInputAdapter;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ResizeListener
    implements DasUpdateListener {
        private ResizeListener() {
        }

        public void update(DasUpdateEvent e) {
            DasCanvasComponent.this.markDirty();
            DasCanvasComponent.this.update();
        }
    }

    protected static abstract class CanvasComponentAction
    extends DasCanvas.CanvasAction {
        private static DasCanvasComponent currentCanvasComponent;

        public CanvasComponentAction(String label) {
            super(label);
        }

        public static DasCanvasComponent getCurrentComponent() {
            return currentCanvasComponent;
        }
    }
}

