/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.graph;

import edu.uiowa.physics.pw.das.DasException;
import edu.uiowa.physics.pw.das.dataset.ConstantDataSetDescriptor;
import edu.uiowa.physics.pw.das.dataset.DataSet;
import edu.uiowa.physics.pw.das.dataset.DataSetDescriptor;
import edu.uiowa.physics.pw.das.dataset.VectorDataSet;
import edu.uiowa.physics.pw.das.datum.Units;
import edu.uiowa.physics.pw.das.graph.DasAxis;
import edu.uiowa.physics.pw.das.graph.Psym;
import edu.uiowa.physics.pw.das.graph.PsymConnector;
import edu.uiowa.physics.pw.das.graph.Renderer;
import edu.uiowa.physics.pw.das.graph.SymColor;
import edu.uiowa.physics.pw.das.graph.Util;
import edu.uiowa.physics.pw.das.util.DasProgressMonitor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.GeneralPath;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CurveRenderer
extends Renderer {
    private String xplane;
    private String yplane;
    private Units xunits;
    private Units yunits;
    private double[][] idata;
    private boolean antiAliased = true;
    private SymColor color = SymColor.black;
    private PsymConnector psymConnector = PsymConnector.SOLID;
    private Psym psym = Psym.NONE;
    private double symSize = 1.0;
    private float lineWidth = 1.5f;
    private GeneralPath path;

    public CurveRenderer(DataSetDescriptor dsd, String xplane, String yplane) {
        super(dsd);
        this.setLineWidth(1.0);
        this.xplane = xplane;
        this.yplane = yplane;
    }

    protected void uninstallRenderer() {
    }

    protected void installRenderer() {
    }

    public void render(Graphics g1, DasAxis xAxis, DasAxis yAxis) {
        double ymin;
        double ymax;
        double xmin;
        double xmax;
        long timer0 = System.currentTimeMillis();
        VectorDataSet dataSet = (VectorDataSet)this.getDataSet();
        if (dataSet == null || dataSet.getXLength() == 0) {
            return;
        }
        VectorDataSet xds = (VectorDataSet)dataSet.getPlanarView(this.xplane);
        VectorDataSet yds = (VectorDataSet)dataSet.getPlanarView(this.yplane);
        Graphics2D graphics = (Graphics2D)g1;
        RenderingHints hints0 = graphics.getRenderingHints();
        if (this.antiAliased) {
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        Units xUnits = xAxis.getUnits();
        Units yUnits = yAxis.getUnits();
        Rectangle r = g1.getClipBounds();
        if (r == null) {
            xmax = xAxis.getDataMaximum().doubleValue(xUnits);
            xmin = xAxis.getDataMinimum().doubleValue(xUnits);
            ymax = yAxis.getDataMaximum().doubleValue(yUnits);
            ymin = yAxis.getDataMinimum().doubleValue(yUnits);
        } else {
            xmin = xAxis.invTransform((int)r.getX()).doubleValue(xUnits);
            xmax = xAxis.invTransform((int)(r.getX() + r.getWidth())).doubleValue(xUnits);
            ymin = yAxis.invTransform((int)r.getY()).doubleValue(yUnits);
            ymax = yAxis.invTransform((int)(r.getY() + r.getHeight())).doubleValue(yUnits);
        }
        graphics.setColor(this.color.toColor());
        if (this.path != null) {
            this.psymConnector.draw(graphics, this.path, this.lineWidth);
        }
        for (int index = 0; index < xds.getXLength(); ++index) {
            if (yUnits.isFill(yds.getDouble(index, yUnits))) continue;
            double i = xAxis.transform(xds.getDouble(index, xUnits), xUnits);
            double j = yAxis.transform(yds.getDouble(index, yUnits), yUnits);
            if (Double.isNaN(j)) continue;
            this.psym.draw(graphics, i, j, (float)this.symSize);
        }
        graphics.setRenderingHints(hints0);
    }

    public void updatePlotImage(DasAxis xAxis, DasAxis yAxis, DasProgressMonitor monitor) throws DasException {
        VectorDataSet dataSet = (VectorDataSet)this.getDataSet();
        if (dataSet == null || dataSet.getXLength() == 0) {
            return;
        }
        VectorDataSet xds = (VectorDataSet)dataSet.getPlanarView(this.xplane);
        VectorDataSet yds = (VectorDataSet)dataSet.getPlanarView(this.yplane);
        this.path = Util.getPath(xAxis, yAxis, xds, yds, false);
    }

    public double getLineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(double lineWidth) {
        this.lineWidth = (float)lineWidth;
    }

    public DataSet getDataSet() {
        DataSetDescriptor dsd = this.getDataSetDescriptor();
        if (!(dsd instanceof ConstantDataSetDescriptor)) {
            throw new IllegalStateException("only ConstantDataSetDescriptors for now!");
        }
        try {
            return dsd.getDataSet(null, null, null, null);
        }
        catch (DasException e) {
            throw new RuntimeException(e);
        }
    }

    protected Element getDOMElement(Document document) {
        throw new UnsupportedOperationException();
    }

    public PsymConnector getPsymConnector() {
        return this.psymConnector;
    }

    public void setPsymConnector(PsymConnector p) {
        this.psymConnector = p;
        this.refreshImage();
    }

    public Psym getPsym() {
        return this.psym;
    }

    public void setPsym(Psym psym) {
        if (psym == null) {
            throw new NullPointerException("psym cannot be null");
        }
        Psym oldValue = this.psym;
        this.psym = psym;
        this.refreshImage();
    }
}

