/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.graph;

import edu.uiowa.physics.pw.das.graph.DasCanvas;
import edu.uiowa.physics.pw.das.graph.DasCanvasComponent;
import edu.uiowa.physics.pw.das.graph.DasColumn;
import edu.uiowa.physics.pw.das.graph.DasRow;
import java.awt.BasicStroke;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;

public class Arrow
extends DasCanvasComponent {
    Point head;
    Point tail;
    Stroke stroke;
    double em = 24.0;

    public Arrow(DasCanvas c, Point head, Point tail) {
        this.head = head;
        this.tail = tail;
        this.setRow(new DasRow(c, head.getX(), tail.getX()));
        this.setColumn(new DasColumn(c, head.getY(), tail.getY()));
    }

    public void resize() {
        Rectangle bounds = new Rectangle();
        bounds.add((double)this.head.x - this.em, (double)this.head.y - this.em);
        bounds.add((double)this.tail.x + this.em, (double)this.tail.y + this.em);
        this.setBounds(bounds);
    }

    protected void paintComponent(Graphics g1) {
        Graphics2D g = (Graphics2D)g1;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.translate(-this.getX(), -this.getY());
        double em = 4.0;
        Line2D.Double line = new Line2D.Double(this.head, this.tail);
        double dx = -(this.head.getX() - this.tail.getX());
        double dy = -(this.head.getY() - this.tail.getY());
        double dd = Math.sqrt(dx * dx + dy * dy);
        dx = dx * em / dd;
        dy = dy * em / dd;
        double hx = this.head.getX();
        double hy = this.head.getY();
        g.setStroke(new BasicStroke((float)(em / 2.0), 1, 1));
        g.draw(line);
        GeneralPath p = new GeneralPath();
        p.moveTo((float)hx, (float)hy);
        p.lineTo((float)(hx + 2.0 * dx + 0.5 * dy), (float)(hy + 2.0 * dy - 0.5 * dx));
        p.lineTo((float)(hx + 3.0 * dx + dy), (float)(hy + 3.0 * dy - dx));
        p.lineTo((float)(hx + 3.0 * dx - dy), (float)(hy + 3.0 * dy + dx));
        p.lineTo((float)(hx + 2.0 * dx - 0.5 * dy), (float)(hy + 2.0 * dy + 0.5 * dx));
        p.lineTo((float)hx, (float)hy);
        g.fill(p);
        g.draw(p);
    }
}

