/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.event;

import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.event.DataRangeSelectionEvent;
import edu.uiowa.physics.pw.das.event.DataRangeSelectionListener;
import edu.uiowa.physics.pw.das.event.Gesture;
import edu.uiowa.physics.pw.das.event.HorizontalRangeGesturesRenderer;
import edu.uiowa.physics.pw.das.event.MouseDragEvent;
import edu.uiowa.physics.pw.das.event.MouseModule;
import edu.uiowa.physics.pw.das.event.MouseRangeSelectionEvent;
import edu.uiowa.physics.pw.das.graph.DasAxis;
import edu.uiowa.physics.pw.das.graph.DasCanvasComponent;
import edu.uiowa.physics.pw.das.graph.DasPlot;
import edu.uiowa.physics.pw.das.graph.DasSpectrogramPlot;
import javax.swing.event.EventListenerList;

public class HorizontalRangeSelectorMouseModule
extends MouseModule {
    DasAxis axis;
    private EventListenerList listenerList = null;
    static /* synthetic */ Class class$edu$uiowa$physics$pw$das$event$DataRangeSelectionListener;

    public HorizontalRangeSelectorMouseModule(DasCanvasComponent parent, DasAxis axis) {
        super(parent, new HorizontalRangeGesturesRenderer(parent), "Zoom X");
        if (!axis.isHorizontal()) {
            throw new IllegalArgumentException("Axis orientation is not horizontal");
        }
        this.axis = axis;
    }

    public static HorizontalRangeSelectorMouseModule create(DasPlot parent) {
        DasAxis axis = parent.getXAxis();
        HorizontalRangeSelectorMouseModule result = new HorizontalRangeSelectorMouseModule(parent, parent.getXAxis());
        return result;
    }

    public void mouseRangeSelected(MouseDragEvent e0) {
        if (!e0.isGesture()) {
            Datum nnMax;
            MouseRangeSelectionEvent e = (MouseRangeSelectionEvent)e0;
            Datum min = this.axis.invTransform(e.getMinimum());
            Datum max = this.axis.invTransform(e.getMaximum());
            Datum nnMin = this.axis.findTick(min, 0.0, true);
            if (nnMin.equals(nnMax = this.axis.findTick(max, 0.0, true))) {
                min = this.axis.findTick(min, -1.0, true);
                max = this.axis.findTick(max, 1.0, true);
            } else {
                min = nnMin;
                max = nnMax;
            }
            DataRangeSelectionEvent te = new DataRangeSelectionEvent(e0.getSource(), min, max);
            this.fireDataRangeSelectionListenerDataRangeSelected(te);
        } else if (e0.getGesture() == Gesture.BACK) {
            this.axis.setDataRangePrev();
        } else if (e0.getGesture() == Gesture.ZOOMOUT) {
            this.axis.setDataRangeZoomOut();
        } else if (e0.getGesture() == Gesture.FORWARD) {
            this.axis.setDataRangeForward();
        } else if (e0.getGesture() == Gesture.SCANPREV) {
            this.axis.scanPrevious();
        } else if (e0.getGesture() == Gesture.SCANNEXT) {
            this.axis.scanNext();
        }
    }

    public synchronized void addDataRangeSelectionListener(DataRangeSelectionListener listener) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.add(class$edu$uiowa$physics$pw$das$event$DataRangeSelectionListener == null ? (class$edu$uiowa$physics$pw$das$event$DataRangeSelectionListener = HorizontalRangeSelectorMouseModule.class$("edu.uiowa.physics.pw.das.event.DataRangeSelectionListener")) : class$edu$uiowa$physics$pw$das$event$DataRangeSelectionListener, listener);
    }

    public synchronized void removeDataRangeSelectionListener(DataRangeSelectionListener listener) {
        this.listenerList.remove(class$edu$uiowa$physics$pw$das$event$DataRangeSelectionListener == null ? (class$edu$uiowa$physics$pw$das$event$DataRangeSelectionListener = HorizontalRangeSelectorMouseModule.class$("edu.uiowa.physics.pw.das.event.DataRangeSelectionListener")) : class$edu$uiowa$physics$pw$das$event$DataRangeSelectionListener, listener);
    }

    private void fireDataRangeSelectionListenerDataRangeSelected(DataRangeSelectionEvent event) {
        if (this.parent instanceof DasSpectrogramPlot) {
            event.setDataSet(((DasSpectrogramPlot)this.parent).getData());
        }
        if (this.listenerList == null) {
            return;
        }
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$edu$uiowa$physics$pw$das$event$DataRangeSelectionListener == null ? HorizontalRangeSelectorMouseModule.class$("edu.uiowa.physics.pw.das.event.DataRangeSelectionListener") : class$edu$uiowa$physics$pw$das$event$DataRangeSelectionListener)) continue;
            ((DataRangeSelectionListener)listeners[i + 1]).DataRangeSelected(event);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

