/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.event;

import edu.uiowa.physics.pw.das.DasProperties;
import edu.uiowa.physics.pw.das.components.propertyeditor.Editable;
import edu.uiowa.physics.pw.das.dataset.DataSet;
import edu.uiowa.physics.pw.das.dataset.DataSetConsumer;
import edu.uiowa.physics.pw.das.dataset.DataSetUtil;
import edu.uiowa.physics.pw.das.dataset.TableDataSet;
import edu.uiowa.physics.pw.das.dataset.TableDataSetConsumer;
import edu.uiowa.physics.pw.das.dataset.TableUtil;
import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.format.DatumFormatter;
import edu.uiowa.physics.pw.das.datum.format.DefaultDatumFormatterFactory;
import edu.uiowa.physics.pw.das.event.DragRenderer;
import edu.uiowa.physics.pw.das.event.MouseDragEvent;
import edu.uiowa.physics.pw.das.graph.DasAxis;
import edu.uiowa.physics.pw.das.graph.DasPlot;
import edu.uiowa.physics.pw.das.util.GrannyTextRenderer;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.text.ParseException;

public class CrossHairRenderer
implements DragRenderer,
Editable {
    protected int xInitial;
    protected int yInitial;
    protected DataSet ds;
    protected DasAxis XAxis;
    protected DasAxis YAxis;
    protected DasPlot parent;
    private int ix = 0;
    private int iy = 0;
    private int context;
    private DatumFormatter nfx;
    private DatumFormatter nfy;
    private DatumFormatter nfz;
    private FontMetrics fm;
    private int dxMax = -999999;
    private Rectangle dirtyBounds;
    private Rectangle hDirtyBounds;
    private Rectangle vDirtyBounds;
    private Point crossHairLocation = null;
    private DataSetConsumer dataSetConsumer;
    private boolean allPlanesReport;
    private boolean debugging;

    public CrossHairRenderer(DasPlot parent, DataSetConsumer dataSetConsumer, DasAxis xAxis, DasAxis yAxis) {
        this.XAxis = xAxis;
        this.YAxis = yAxis;
        this.parent = parent;
        this.dataSetConsumer = dataSetConsumer;
        this.dirtyBounds = new Rectangle();
        this.hDirtyBounds = new Rectangle();
        this.vDirtyBounds = new Rectangle();
    }

    private DatumFormatter addResolutionToFormat(DatumFormatter nfz) throws ParseException {
        String[] ss;
        String formatString = nfz.toString();
        String result = formatString.indexOf(69) == -1 ? formatString + "0" : ((ss = formatString.split("E"))[0].indexOf(46) == -1 ? ss[0] + ".0" + "E0" : ss[0] + "0" + "E0");
        return DefaultDatumFormatterFactory.getInstance().newFormatter(result);
    }

    private String getZString(TableDataSet tds, Datum x, Datum y) {
        int i = DataSetUtil.closestColumn(tds, x);
        int j = TableUtil.closestRow(tds, tds.tableOfIndex(i), y);
        Datum zValue = tds.getDatum(i, j);
        try {
            if (this.dataSetConsumer instanceof TableDataSetConsumer) {
                this.nfz = ((TableDataSetConsumer)this.dataSetConsumer).getZAxis().getDatumFormatter();
                this.nfz = this.addResolutionToFormat(this.nfz);
            } else {
                this.nfz = DefaultDatumFormatterFactory.getInstance().newFormatter("0.00");
            }
        }
        catch (ParseException pe) {
            DasProperties.getLogger().severe("failure to create formatter");
            DasAxis axis = ((TableDataSetConsumer)this.dataSetConsumer).getZAxis();
            axis.getUnits().getDatumFormatterFactory().defaultFormatter();
        }
        String result = zValue.isFill() ? "fill" : this.nfz.grannyFormat(zValue);
        if (this.allPlanesReport) {
            if (this.debugging) {
                result = result + "!c" + tds.toString();
            }
            String[] planeIds = tds.getPlaneIds();
            for (int iplane = 0; iplane < planeIds.length; ++iplane) {
                if (planeIds[iplane].equals("")) continue;
                result = result + "!c";
                result = result + planeIds[iplane] + ":" + this.nfz.grannyFormat(((TableDataSet)tds.getPlanarView(planeIds[iplane])).getDatum(i, j));
                if (!this.debugging) continue;
                result = result + " " + ((TableDataSet)tds.getPlanarView(planeIds[iplane])).toString();
            }
            if (this.debugging) {
                result = result + "!ci:" + i + " j:" + j;
            }
        }
        return result;
    }

    public void renderDrag(Graphics g1, Point p1, Point p2) {
        Graphics2D g = (Graphics2D)g1;
        g.setRenderingHints(DasProperties.getRenderingHints());
        this.ds = this.dataSetConsumer.getDataSet();
        if (this.crossHairLocation == null) {
            String report;
            Datum x = this.XAxis.invTransform(p2.x + this.parent.getX());
            Datum y = this.YAxis.invTransform(p2.y + this.parent.getY());
            this.nfy = y.getFormatter();
            this.nfx = x.getFormatter();
            String xAsString = this.nfx.format(x);
            String yAsString = this.nfy.format(y);
            if (this.ds instanceof TableDataSet) {
                TableDataSet tds = (TableDataSet)this.ds;
                String zAsString = this.getZString(tds, x, y);
                report = "x:" + xAsString + " y:" + yAsString + " z:" + zAsString;
            } else {
                report = "x:" + xAsString + " y:" + yAsString;
            }
            this.fm = this.parent.getGraphics().getFontMetrics();
            Color color0 = g.getColor();
            g.setColor(new Color(255, 255, 255, 200));
            Dimension d = this.parent.getSize();
            GrannyTextRenderer gtr = new GrannyTextRenderer();
            gtr.setString(this.parent, report);
            int dx = (int)gtr.getWidth() + 6;
            if (this.dxMax < dx) {
                this.dxMax = dx;
            }
            int dy = (int)gtr.getHeight();
            int xp = p2.x + 3;
            int yp = p2.y - 3 - dy;
            if (xp + this.dxMax > d.width - 3 && p2.x - 3 - dx > 0) {
                xp = p2.x - 3 - dx;
            }
            if (yp < 13) {
                yp = p2.y + 3;
            }
            this.dirtyBounds.setRect(xp, yp, gtr.getWidth() + 6.0, gtr.getHeight() + 6.0);
            g.fill(this.dirtyBounds);
            g.setColor(new Color(20, 20, 20));
            gtr.draw(g, xp + 3, (float)((double)yp + gtr.getAscent()));
            g.setColor(color0);
        }
        this.drawCrossHair(g, p2);
    }

    public MouseDragEvent getMouseDragEvent(Object source, Point p1, Point p2, boolean isModified) {
        return null;
    }

    private void drawCrossHair(Graphics g0, Point p) {
        Graphics g = g0.create();
        g.setColor(Color.black);
        Dimension d = this.parent.getSize();
        this.hDirtyBounds.setBounds(0, p.y, d.width, 1);
        g.drawLine(0, p.y, d.width, p.y);
        this.vDirtyBounds.setBounds(p.x, 0, 1, d.height);
        g.drawLine(p.x, 0, p.x, d.height);
        g.dispose();
    }

    public void clear(Graphics g) {
        if (this.crossHairLocation != null) {
            this.drawCrossHair(g, this.crossHairLocation);
        }
        this.parent.paintImmediately(this.dirtyBounds);
        this.parent.paintImmediately(this.hDirtyBounds);
        this.parent.paintImmediately(this.vDirtyBounds);
    }

    public boolean isXRangeSelection() {
        return false;
    }

    public boolean isYRangeSelection() {
        return false;
    }

    public boolean isPointSelection() {
        return true;
    }

    public boolean isUpdatingDragSelection() {
        return false;
    }

    public boolean isAllPlanesReport() {
        return this.allPlanesReport;
    }

    public void setAllPlanesReport(boolean allPlanesReport) {
        this.allPlanesReport = allPlanesReport;
    }

    public boolean isDebugging() {
        return this.debugging;
    }

    public void setDebugging(boolean debugging) {
        this.debugging = debugging;
    }
}

