/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.event;

import edu.uiowa.physics.pw.das.dataset.DataSet;
import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.event.DasEvent;

public class BoxSelectionEvent
extends DasEvent {
    private Datum xMin;
    private Datum xMax;
    private Datum yMin;
    private Datum yMax;
    private DataSet ds;

    public BoxSelectionEvent(Object source, Datum xMin, Datum xMax, Datum yMin, Datum yMax) {
        super(source);
        Datum t;
        if (xMin.gt(xMax)) {
            t = xMin;
            xMin = xMax;
            xMax = t;
        }
        if (yMin.gt(yMax)) {
            t = yMin;
            yMin = yMax;
            yMax = t;
        }
        this.xMin = xMin;
        this.xMax = xMax;
        this.yMin = yMin;
        this.yMax = yMax;
    }

    public Datum getXMinimum() {
        return this.xMin;
    }

    public Datum getXMaximum() {
        return this.xMax;
    }

    public Datum getYMinimum() {
        return this.yMin;
    }

    public Datum getYMaximum() {
        return this.yMax;
    }

    public void setDataSet(DataSet ds) {
        this.ds = ds;
    }

    public DataSet getDataSet() {
        return this.ds;
    }

    public String toString() {
        return "[BoxSelectionEvent x: " + this.xMin + " - " + this.xMax + ", y: " + this.yMin + " - " + this.yMax + "]";
    }
}

