/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.datum;

import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.Units;
import edu.uiowa.physics.pw.das.datum.UnitsConverter;
import edu.uiowa.physics.pw.das.datum.format.DatumFormatterFactory;
import edu.uiowa.physics.pw.das.datum.format.DefaultDatumFormatterFactory;
import java.text.ParseException;

public class NumberUnits
extends Units {
    public NumberUnits(String id) {
        this(id, "");
    }

    public NumberUnits(String id, String description) {
        super(id, description);
    }

    public Datum createDatum(double value) {
        return new Datum.Double(new Double(value), (Units)this);
    }

    public Datum createDatum(int value) {
        return new Datum.Double(new Double(value), (Units)this);
    }

    public Datum createDatum(long value) {
        return new Datum.Double(new Double(value), (Units)this);
    }

    public Datum createDatum(Number value) {
        return new Datum.Double(value, (Units)this);
    }

    public DatumFormatterFactory getDatumFormatterFactory() {
        return DefaultDatumFormatterFactory.getInstance();
    }

    public Datum parse(String s) throws ParseException {
        try {
            return Datum.create(Double.parseDouble(s), (Units)this);
        }
        catch (NumberFormatException nfe) {
            ParseException pe = new ParseException(nfe.getMessage(), 0);
            pe.initCause(nfe);
            throw pe;
        }
    }

    protected static Number add(Number a, Number value) {
        if (a instanceof Integer && value instanceof Integer) {
            return new Integer(a.intValue() + value.intValue());
        }
        return new Double(a.doubleValue() + value.doubleValue());
    }

    protected static Number subtract(Number from, Number value) {
        if (from instanceof Integer && value instanceof Integer) {
            return new Integer(from.intValue() - value.intValue());
        }
        return new Double(from.doubleValue() - value.doubleValue());
    }

    protected static Number divide(Number a, Number value) {
        if (a instanceof Integer && value instanceof Integer) {
            return new Integer(a.intValue() / value.intValue());
        }
        return new Double(a.doubleValue() / value.doubleValue());
    }

    protected static Number multiply(Number a, Number value) {
        if (a instanceof Integer && value instanceof Integer) {
            return new Integer(a.intValue() * value.intValue());
        }
        return new Double(a.doubleValue() * value.doubleValue());
    }

    public Datum add(Number a, Number b, Units bUnits) {
        if (bUnits != this) {
            UnitsConverter uc = Units.getConverter(bUnits, this);
            b = uc.convert(b);
        }
        return this.createDatum(NumberUnits.add(a, b));
    }

    public Datum subtract(Number a, Number b, Units bUnits) {
        if (bUnits != this) {
            UnitsConverter uc = Units.getConverter(bUnits, this);
            b = uc.convert(b);
        }
        return this.createDatum(NumberUnits.subtract(a, b));
    }

    public Datum multiply(Number a, Number b, Units bUnits) {
        if (bUnits == Units.dimensionless) {
            return this.createDatum(NumberUnits.multiply(a, b));
        }
        throw new IllegalArgumentException("Only multiplication by dimensionless numbers is supported");
    }

    public Datum divide(Number a, Number b, Units bUnits) {
        if (bUnits == Units.dimensionless) {
            return this.createDatum(NumberUnits.divide(a, b));
        }
        throw new IllegalArgumentException("Only multiplication by dimensionless numbers is supported");
    }
}

