/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.datum;

import edu.uiowa.physics.pw.das.datum.DatumRange;
import edu.uiowa.physics.pw.das.datum.TimeUtil;

public class MonthDatumRange
extends DatumRange {
    int width;
    int widthDigit = -1;
    int[] start;
    int[] end;

    public MonthDatumRange(int[] start, int[] end) {
        super(TimeUtil.toDatum(start), TimeUtil.toDatum(end));
        int i;
        int[] widthArr = new int[7];
        boolean haveNonZeroDigit = false;
        for (i = 0; i < 7; ++i) {
            widthArr[i] = end[i] - start[i];
        }
        while (widthArr[1] < 0) {
            widthArr[1] = widthArr[1] + 12;
            widthArr[0] = widthArr[0] - 1;
        }
        for (i = 0; i < 7; ++i) {
            if (widthArr[i] == 0) continue;
            if (this.widthDigit != -1) {
                throw new IllegalArgumentException("only one non-zero digit allowed");
            }
            this.widthDigit = i;
            this.width = widthArr[this.widthDigit];
        }
        this.start = start;
        this.end = end;
    }

    public DatumRange next() {
        int[] end1 = new int[7];
        for (int i = 0; i < 7; ++i) {
            end1[i] = this.end[i];
        }
        end1[this.widthDigit] = end1[this.widthDigit] + this.width;
        switch (this.widthDigit) {
            case 1: {
                while (end1[1] > 12) {
                    end1[1] = end1[1] - 12;
                    end1[0] = end1[0] + 1;
                }
            }
            case 0: {
                break;
            }
            default: {
                throw new IllegalArgumentException("not implemented");
            }
        }
        return new MonthDatumRange(this.end, end1);
    }

    public DatumRange previous() {
        int[] start1 = new int[7];
        for (int i = 0; i < 7; ++i) {
            start1[i] = this.start[i];
        }
        start1[this.widthDigit] = start1[this.widthDigit] - this.width;
        switch (this.widthDigit) {
            case 1: {
                while (start1[1] < 1) {
                    start1[1] = start1[1] + 12;
                    start1[0] = start1[0] - 1;
                }
            }
            case 0: {
                break;
            }
            default: {
                throw new IllegalArgumentException("not implemented");
            }
        }
        return new MonthDatumRange(start1, this.start);
    }
}

