/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.datum;

import edu.uiowa.physics.pw.das.datum.Units;
import edu.uiowa.physics.pw.das.datum.UnitsConverter;
import edu.uiowa.physics.pw.das.datum.format.DatumFormatter;

public abstract class Datum {
    private Units units;
    private Number value;
    private DatumFormatter formatter;

    private Datum(Number value, Units units) {
        this(value, units, units.getDatumFormatterFactory().defaultFormatter());
    }

    private Datum(Number value, Units units, DatumFormatter formatter) {
        this.value = value;
        this.units = units;
        this.formatter = formatter;
    }

    protected double doubleValue() {
        return this.getValue().doubleValue();
    }

    public double doubleValue(Units units) {
        if (units != this.getUnits()) {
            return this.getUnits().getConverter(units).convert(this.getValue()).doubleValue();
        }
        return this.getValue().doubleValue();
    }

    protected int intValue() {
        return this.getValue().intValue();
    }

    public int intValue(Units units) {
        if (units != this.getUnits()) {
            return this.getUnits().getConverter(units).convert(this.getValue()).intValue();
        }
        return this.getValue().intValue();
    }

    public Units getUnits() {
        return this.units;
    }

    public Number getValue() {
        return this.value;
    }

    public boolean isFill() {
        return this.getUnits().isFill(this.getValue());
    }

    public Datum add(Datum a) {
        return this.add(a.getValue(), a.getUnits());
    }

    public Datum add(Number a, Units units) {
        return this.getUnits().add(this.getValue(), a, units);
    }

    public Datum add(double d, Units units) {
        return this.add(new java.lang.Double(d), units);
    }

    public Datum subtract(Datum a) {
        return this.subtract(a.getValue(), a.getUnits());
    }

    public Datum subtract(Number a, Units units) {
        return this.getUnits().subtract(this.getValue(), a, units);
    }

    public Datum subtract(double d, Units units) {
        return this.subtract(new java.lang.Double(d), units);
    }

    public Datum divide(Datum a) {
        return this.getUnits().divide(this.getValue(), a.getValue(), a.getUnits());
    }

    public Datum divide(Number a, Units units) {
        return this.getUnits().divide(this.getValue(), a, units);
    }

    public Datum divide(double d) {
        return this.divide(new java.lang.Double(d), Units.dimensionless);
    }

    public Datum multiply(Datum a) {
        return this.getUnits().multiply(this.getValue(), a.getValue(), a.getUnits());
    }

    public Datum multiply(Number a, Units units) {
        return this.getUnits().multiply(this.getValue(), a, units);
    }

    public Datum multiply(double d) {
        return this.multiply(new java.lang.Double(d), Units.dimensionless);
    }

    public Datum convertTo(Units units) throws IllegalArgumentException {
        UnitsConverter muc = this.getUnits().getConverter(units);
        Datum result = units.createDatum(muc.convert(this.getValue()));
        return result;
    }

    public int hashCode() {
        long bits = this.getValue().hashCode();
        int doubleHash = (int)(bits ^ bits >>> 32);
        int unitsHash = this.units.hashCode();
        return doubleHash ^ unitsHash;
    }

    public boolean equals(Object a) throws IllegalArgumentException {
        return a instanceof Datum && this.equals((Datum)a);
    }

    public boolean equals(Datum a) throws IllegalArgumentException {
        return a.units == this.units && a.value.equals(this.value);
    }

    public boolean lt(Datum a) throws IllegalArgumentException {
        return this.compareTo(a) < 0;
    }

    public boolean gt(Datum a) throws IllegalArgumentException {
        return this.compareTo(a) > 0;
    }

    public boolean le(Datum a) throws IllegalArgumentException {
        return this.compareTo(a) <= 0;
    }

    public boolean ge(Datum a) throws IllegalArgumentException {
        return this.compareTo(a) >= 0;
    }

    public int compareTo(Object a) throws IllegalArgumentException {
        if (!(a instanceof Datum)) {
            throw new IllegalArgumentException("comparable type mismatch");
        }
        return this.compareTo((Datum)a);
    }

    public int compareTo(Datum a) throws IllegalArgumentException {
        double d;
        if (this.units != a.units) {
            a = a.convertTo(this.units);
        }
        if ((d = this.getValue().doubleValue() - a.getValue().doubleValue()) == 0.0) {
            return 0;
        }
        if (d < 0.0) {
            return -1;
        }
        return 1;
    }

    public boolean isValid() {
        return this.value.doubleValue() != java.lang.Double.NaN;
    }

    public boolean isFinite() {
        return this.value.doubleValue() != java.lang.Double.POSITIVE_INFINITY && this.value.doubleValue() != java.lang.Double.NEGATIVE_INFINITY;
    }

    public String toString() {
        if (this.formatter == null) {
            return "" + this.value + " " + this.units;
        }
        return this.formatter.format(this);
    }

    public static Datum create(double value) {
        return Units.dimensionless.createDatum(value);
    }

    public static Datum create(double value, Units units) {
        return units.createDatum(value);
    }

    public static Datum create(double value, Units units, DatumFormatter formatter) {
        Datum result = Datum.create(value, units);
        result.formatter = formatter;
        return result;
    }

    public static Datum create(int value) {
        return Units.dimensionless.createDatum(value);
    }

    public static Datum create(int value, Units units) {
        return units.createDatum(value);
    }

    public DatumFormatter getFormatter() {
        return this.formatter;
    }

    public static class Double
    extends Datum {
        Double(Number value, Units units) {
            super(value, units);
        }

        Double(double value, Units units) {
            this(new java.lang.Double(value), units);
        }

        Double(double value) {
            this(value, Units.dimensionless);
        }
    }
}

