/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.dataset.parser;

import edu.uiowa.physics.pw.das.dataset.VectorDataSet;
import edu.uiowa.physics.pw.das.dataset.VectorDataSetBuilder;
import edu.uiowa.physics.pw.das.datum.Units;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class VectorDataSetParser {
    Pattern propertyPattern;
    String commentRegex;
    Pattern recordPattern;
    String[] fieldNames;
    static final String decimalRegex = "\\S*\\d+\\S*";
    int skipLines;
    int recordCountLimit;
    int fieldCount;
    public static final Pattern NAME_COLON_VALUE_PATTERN = Pattern.compile("\\s*(.+?)\\s*\\:\\s*(.+)\\s*");
    public static final Pattern NAME_EQUAL_VALUE_PATTERN = Pattern.compile("\\s*(.+?)\\s*\\=\\s*(.+)\\s*");

    private VectorDataSetParser(String[] fieldNames) {
        this.fieldCount = fieldNames.length;
        this.fieldNames = fieldNames;
        StringBuffer regexBuf = new StringBuffer();
        regexBuf.append("\\s*");
        for (int i = 0; i < this.fieldCount - 1; ++i) {
            regexBuf.append("(\\S*\\d+\\S*)\\s+");
        }
        regexBuf.append("(\\S*\\d+\\S*)\\s*");
        this.recordPattern = this.recordPattern = Pattern.compile(regexBuf.toString());
    }

    public static VectorDataSetParser newParser(int fieldCount) {
        String[] fieldNames = new String[fieldCount];
        for (int i = 0; i < fieldCount; ++i) {
            fieldNames[i] = "field" + i;
        }
        return new VectorDataSetParser(fieldNames);
    }

    public static VectorDataSetParser newParser(String[] fieldNames) {
        return new VectorDataSetParser(fieldNames);
    }

    public void setSkipLines(int skipLines) {
        this.skipLines = skipLines;
    }

    public void setRecordCountLimit(int recordCountLimit) {
        this.recordCountLimit = recordCountLimit;
    }

    public void setPropertyPattern(Pattern propertyPattern) {
        this.propertyPattern = propertyPattern;
    }

    private VectorDataSet readStream(InputStream in) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        int iline = 0;
        int irec = 0;
        VectorDataSetBuilder builder = new VectorDataSetBuilder(Units.dimensionless, Units.dimensionless);
        for (int i = 0; i < this.fieldCount; ++i) {
            builder.addPlane(this.fieldNames[i], Units.dimensionless);
        }
        while ((line = reader.readLine()) != null && iline >= this.skipLines) {
            Matcher m = this.recordPattern.matcher(line);
            if (m.matches()) {
                for (int i = 0; i < this.fieldCount; ++i) {
                    builder.insertY(irec, Double.parseDouble(m.group(i + 1)), this.fieldNames[i]);
                }
                ++irec;
                continue;
            }
            if (this.propertyPattern == null || !(m = this.propertyPattern.matcher(line)).matches()) continue;
            builder.setProperty(m.group(1).trim(), m.group(2).trim());
        }
        return builder.toVectorDataSet();
    }

    public VectorDataSet readFile(String filename) throws IOException {
        return this.readStream(new FileInputStream(filename));
    }

    public static void main(String[] args) throws Exception {
        VectorDataSetParser parser = VectorDataSetParser.newParser(5);
        parser.setPropertyPattern(Pattern.compile("\\s*(.+)\\s*\\:\\s*(.+)\\s*"));
        long t0 = System.currentTimeMillis();
        VectorDataSet ds = parser.readFile("j:/ct/ncvs/sarahFFT/lintest10/2490lintest100002.raw");
        System.out.println("" + (System.currentTimeMillis() - t0));
        System.out.println(ds.getProperty("Frequency"));
        System.out.flush();
    }
}

