/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.dataset;

import edu.uiowa.physics.pw.das.dataset.DefaultTableDataSet;
import edu.uiowa.physics.pw.das.dataset.GapListDouble;
import edu.uiowa.physics.pw.das.dataset.TableDataSet;
import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.DatumVector;
import edu.uiowa.physics.pw.das.datum.Units;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;

public class TableDataSetBuilder {
    private static final double[] EMPTY = new double[0];
    private GapListDouble xTags = new GapListDouble();
    private List zValues = new ArrayList();
    private List planeIDs = new ArrayList();
    private Units xUnits;
    private Units yUnits;
    private Map zUnitsMap;
    private SortedSet yTagSet;
    private Map properties;
    private int count;

    public TableDataSetBuilder(Units xUnits, Units yUnits, Units zUnits) {
        this.planeIDs.add("");
        this.xUnits = Units.dimensionless;
        this.yUnits = Units.dimensionless;
        this.zUnitsMap = new HashMap();
        this.zUnitsMap.put("", Units.dimensionless);
        this.yTagSet = new TreeSet(new DoubleArrayComparator());
        this.properties = new HashMap();
        this.count = 0;
        this.setXUnits(xUnits);
        this.setYUnits(yUnits);
        this.setZUnits(zUnits);
    }

    public void setProperty(String name, Object value) {
        this.properties.put(name, value);
    }

    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    public void addProperties(Map map) {
        this.properties.putAll(map);
    }

    public void addPlane(String name, Units zUnits) {
        if (name != null && !this.planeIDs.contains(name)) {
            this.planeIDs.add(name);
            this.zUnitsMap.put(name, zUnits);
        }
    }

    public void insertYScan(Datum x, DatumVector y, DatumVector z) {
        this.insertYScan(x, y, new DatumVector[]{z}, new String[]{""});
    }

    public void insertYScan(Datum x, DatumVector y, DatumVector z, String planeId) {
        this.insertYScan(x, y, new DatumVector[]{z}, new String[]{planeId});
    }

    public void insertYScan(Datum xTag, DatumVector yTags, DatumVector[] scans, String[] planeIDs) {
        double x = xTag.doubleValue(this.xUnits);
        double[] y = yTags.toDoubleArray(this.yUnits);
        int insertionIndex = this.xTags.indexOf(x);
        for (int i = 0; i < scans.length; ++i) {
            if (yTags.getLength() == scans[i].getLength()) continue;
            IllegalArgumentException iae = new IllegalArgumentException("Scan length must equal yTags length");
        }
        if (this.yTagSet.contains(y)) {
            y = (double[])this.yTagSet.tailSet(y).iterator().next();
        } else {
            this.yTagSet.add(y);
        }
        if (insertionIndex < 0) {
            insertionIndex ^= 0xFFFFFFFF;
        }
        this.xTags.add(x);
        MultiYScan scan = new MultiYScan();
        for (int i = 0; i < planeIDs.length; ++i) {
            String planeID = planeIDs[i];
            Units zUnits = (Units)this.zUnitsMap.get(planeID);
            if (zUnits == null) {
                zUnits = Units.dimensionless;
                this.addPlane(planeID, zUnits);
            }
            double[] z = scans[i].toDoubleArray(zUnits);
            scan.put(planeID, z);
            scan.setYTags(y);
            this.zValues.add(insertionIndex, scan);
        }
    }

    public void append(TableDataSet tds) {
        String[] planeIDs = this.planeIDs.toArray(new String[this.planeIDs.size()]);
        TableDataSet[] planes = new TableDataSet[planeIDs.length];
        planes[0] = tds;
        for (int i = 1; i < planeIDs.length; ++i) {
            planes[i] = (TableDataSet)tds.getPlanarView(planeIDs[i]);
        }
        DatumVector[] z = new DatumVector[planes.length];
        for (int table = 0; table < tds.tableCount(); ++table) {
            DatumVector y = this.getYTagsDatumVector(tds, table);
            for (int i = tds.tableStart(table); i < tds.tableEnd(table); ++i) {
                for (int p = 0; p < planes.length; ++p) {
                    z[p] = this.getZScanDatumVector(planes[p], table, i);
                }
                this.insertYScan(tds.getXTagDatum(i), y, z, planeIDs);
            }
        }
    }

    private DatumVector getYTagsDatumVector(TableDataSet tds, int table) {
        double[] yTags = new double[tds.getYLength(table)];
        for (int j = 0; j < tds.getYLength(table); ++j) {
            yTags[j] = tds.getYTagDouble(table, j, this.yUnits);
        }
        return DatumVector.newDatumVector(yTags, this.yUnits);
    }

    private DatumVector getZScanDatumVector(TableDataSet tds, int table, int i) {
        if (tds == null) {
            return null;
        }
        double[] scan = new double[tds.getYLength(table)];
        for (int j = 0; j < tds.getYLength(table); ++j) {
            scan[j] = tds.getDouble(i, j, this.yUnits);
        }
        return DatumVector.newDatumVector(scan, this.yUnits);
    }

    public void setXUnits(Units units) {
        if (units == null) {
            throw new NullPointerException();
        }
        this.xUnits = units;
    }

    public void setYUnits(Units units) {
        if (units == null) {
            throw new NullPointerException();
        }
        this.yUnits = units;
    }

    public void setZUnits(Units units) {
        this.setZUnits(units, "");
    }

    public void setZUnits(Units units, String planeID) {
        if (units == null) {
            throw new NullPointerException();
        }
        this.zUnitsMap.put(planeID, units);
    }

    public String toString() {
        int index = 0;
        StringBuffer result = new StringBuffer();
        Iterator i = this.zValues.iterator();
        while (i.hasNext()) {
            MultiYScan scan = (MultiYScan)i.next();
            result.append(TableDataSetBuilder.toString(this.xTags.toArray(), index, index + 1)).append(TableDataSetBuilder.toString(scan.get(""))).append('\n');
            ++index;
        }
        return result.toString();
    }

    public TableDataSet toTableDataSet() {
        int count = TableDataSetBuilder.getTableCount(this.zValues);
        int[] tableOffsets = TableDataSetBuilder.getTableOffsets(this.zValues, count);
        double[][] collapsedYTags = TableDataSetBuilder.collapseYTags(this.zValues, count);
        double[][][] collapsedZValues = TableDataSetBuilder.collapseZValues(this.zValues, this.planeIDs, this.zUnitsMap);
        Units[] zUnitsArray = TableDataSetBuilder.getUnitsArray(this.planeIDs, this.zUnitsMap);
        return new DefaultTableDataSet(this.xTags.toArray(), this.xUnits, collapsedYTags, this.yUnits, collapsedZValues, zUnitsArray, this.planeIDs.toArray(new String[this.planeIDs.size()]), tableOffsets, this.properties);
    }

    public int getXLength() {
        return this.xTags.size();
    }

    public double getXTag(int i) {
        return this.xTags.get(i);
    }

    private static double[] insert(double[] array, double value, int index) {
        double[] result = new double[array.length + 1];
        System.arraycopy(array, 0, result, 0, index);
        result[index] = value;
        System.arraycopy(array, index, result, index + 1, array.length - index);
        return result;
    }

    private static double[][] insert(double[][] array, double[] values, int index) {
        double[][] result = new double[array.length + 1][];
        System.arraycopy(array, 0, result, 0, index);
        result[index] = values;
        System.arraycopy(array, index, result, index + 1, array.length - index);
        return result;
    }

    private static String toString(double[] array) {
        return TableDataSetBuilder.toString(array, 0, array.length);
    }

    private static String toString(double[] array, int startIndex, int endIndex) {
        if (array.length == 0) {
            return "[]";
        }
        StringBuffer buffer = new StringBuffer("[");
        for (int i = startIndex; i < endIndex - 1; ++i) {
            buffer.append(array[i]).append(", ");
        }
        buffer.append(array[endIndex - 1]).append(']');
        return buffer.toString();
    }

    private static int getTableCount(List list) {
        int count = 0;
        double[] previous = null;
        Iterator i = list.iterator();
        while (i.hasNext()) {
            MultiYScan scan = (MultiYScan)i.next();
            if (Arrays.equals(previous, scan.getYTags())) continue;
            previous = scan.getYTags();
            ++count;
        }
        return count;
    }

    private static int[] getTableOffsets(List list, int count) {
        double[] previous = null;
        int index = 0;
        int offset = 0;
        int[] tableOffsets = new int[count];
        Iterator i = list.iterator();
        while (i.hasNext()) {
            MultiYScan scan = (MultiYScan)i.next();
            if (!Arrays.equals(previous, scan.getYTags())) {
                tableOffsets[index] = offset;
                previous = scan.getYTags();
                ++index;
            }
            ++offset;
        }
        return tableOffsets;
    }

    private static double[][] collapseYTags(List list, int count) {
        double[] previous = null;
        int index = 0;
        double[][] result = new double[count][];
        Iterator i = list.iterator();
        while (i.hasNext()) {
            MultiYScan scan = (MultiYScan)i.next();
            if (Arrays.equals(previous, scan.getYTags())) continue;
            result[index] = scan.getYTags();
            previous = scan.getYTags();
            ++index;
        }
        return result;
    }

    private static double[][][] collapseZValues(List list, List planeIDs, Map unitsMap) {
        double[][][] zValues = new double[planeIDs.size()][list.size()][];
        int index = 0;
        Iterator i = list.iterator();
        while (i.hasNext()) {
            MultiYScan scan = (MultiYScan)i.next();
            for (int plane = 0; plane < planeIDs.size(); ++plane) {
                double[] z = scan.get((String)planeIDs.get(plane));
                if (z == null) {
                    z = new double[scan.getYTags().length];
                    Units units = (Units)unitsMap.get(planeIDs.get(plane));
                    Arrays.fill(z, units.getFillDouble());
                }
                zValues[plane][index] = z;
            }
            ++index;
        }
        return zValues;
    }

    private static Units[] getUnitsArray(List planeIDs, Map unitsMap) {
        Units[] units = new Units[planeIDs.size()];
        for (int i = 0; i < units.length; ++i) {
            units[i] = (Units)unitsMap.get(planeIDs.get(i));
        }
        return units;
    }

    private class MultiYScan {
        private HashMap map = new HashMap();
        double[] yTags;

        private MultiYScan() {
        }

        public void put(String name, double[] scan) {
            this.map.put(name, scan);
        }

        public double[] get(String name) {
            return (double[])this.map.get(name);
        }

        public double[] getYTags() {
            return this.yTags;
        }

        public void setYTags(double[] yTags) {
            this.yTags = yTags;
        }
    }

    private class DoubleArrayComparator
    implements Comparator {
        private DoubleArrayComparator() {
        }

        public int compare(Object o1, Object o2) {
            double[] d1 = (double[])o1;
            double[] d2 = (double[])o2;
            if (d1.length != d2.length) {
                return d1.length - d2.length;
            }
            for (int i = 0; i < d1.length; ++i) {
                double delta = d1[i] - d2[i];
                if (delta < 0.0) {
                    return -1;
                }
                if (!(delta > 0.0)) continue;
                return 1;
            }
            return 0;
        }
    }
}

