/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.dataset;

class GapListDouble {
    private static final int INITIAL_ARRAY_SIZE = 128;
    private double[] array = new double[128];
    private int gapStart = 0;
    private int gapEnd = 128;

    GapListDouble() {
    }

    public int add(double d) {
        int index = this.indexOf(d);
        if (index < 0) {
            index ^= 0xFFFFFFFF;
        }
        if (this.isFull()) {
            this.resizeArray();
        }
        if (index != this.gapStart) {
            this.moveGap(index);
        }
        this.array[this.gapStart] = d;
        ++this.gapStart;
        return index;
    }

    public double get(int index) {
        if (index < this.gapStart) {
            return this.array[index];
        }
        return this.array[index + (this.gapEnd - this.gapStart)];
    }

    public int indexOf(double d) {
        if (this.gapStart != 0 && this.array[this.gapStart - 1] >= d) {
            return GapListDouble.binarySearch(d, this.array, 0, this.gapStart);
        }
        if (this.gapEnd != this.array.length && this.array[this.gapEnd] < d) {
            int index = GapListDouble.binarySearch(d, this.array, this.gapEnd, this.array.length);
            if (index >= 0) {
                return index - (this.gapEnd - this.gapStart);
            }
            return ~(~index - (this.gapEnd - this.gapStart));
        }
        return ~this.gapStart;
    }

    public boolean isEmpty() {
        return this.gapStart == 0 && this.gapEnd == this.array.length;
    }

    private boolean isFull() {
        return this.gapStart == this.gapEnd;
    }

    public int size() {
        return this.gapStart + this.array.length - this.gapEnd;
    }

    public double[] toArray() {
        double[] out = new double[this.size()];
        System.arraycopy(this.array, 0, out, 0, this.gapStart);
        System.arraycopy(this.array, this.gapEnd, out, this.gapStart, this.array.length - this.gapEnd);
        return out;
    }

    public String toString() {
        if (this.isEmpty()) {
            return "[]";
        }
        StringBuffer buffer = new StringBuffer("[");
        int size = this.size();
        for (int i = 0; i < size - 1; ++i) {
            buffer.append(this.get(i)).append(", ");
        }
        buffer.append(this.get(size - 1)).append("]");
        return buffer.toString();
    }

    private void resizeArray() {
        double[] temp = new double[this.array.length << 1];
        System.arraycopy(this.array, 0, temp, 0, this.gapStart);
        int l2 = this.array.length - this.gapEnd;
        System.arraycopy(this.array, this.gapEnd, temp, temp.length - l2, l2);
        this.array = temp;
        this.gapEnd = temp.length - l2;
    }

    private void moveGap(int position) {
        if (position < this.gapStart) {
            int chunkSize = this.gapStart - position;
            int gapSize = this.gapEnd - this.gapStart;
            System.arraycopy(this.array, position, this.array, position + gapSize, chunkSize);
            this.gapStart = position;
            this.gapEnd = this.gapStart + gapSize;
        } else if (position > this.gapStart) {
            int chunkSize = position - this.gapStart;
            int gapSize = this.gapEnd - this.gapStart;
            System.arraycopy(this.array, this.gapEnd, this.array, this.gapStart, chunkSize);
            this.gapStart = position;
            this.gapEnd = this.gapStart + gapSize;
        }
    }

    private static int binarySearch(double d, double[] array, int start, int end) {
        int low = start;
        int high = end - 1;
        while (low <= high) {
            int mid = low + high >> 1;
            if (array[mid] < d) {
                low = mid + 1;
                continue;
            }
            if (array[mid] > d) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return ~low;
    }
}

