/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.dataset;

import edu.uiowa.physics.pw.das.DasApplication;
import edu.uiowa.physics.pw.das.dataset.AbstractDataSet;
import edu.uiowa.physics.pw.das.dataset.AbstractTableDataSet;
import edu.uiowa.physics.pw.das.dataset.DataSet;
import edu.uiowa.physics.pw.das.dataset.TableDataSet;
import edu.uiowa.physics.pw.das.dataset.TableUtil;
import edu.uiowa.physics.pw.das.dataset.VectorDataSet;
import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.DatumVector;
import edu.uiowa.physics.pw.das.datum.Units;
import edu.uiowa.physics.pw.das.datum.UnitsConverter;
import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Logger;

public final class DefaultTableDataSet
extends AbstractTableDataSet {
    private double[][][] tableData;
    private Units[] zUnits;
    private double[][] yTags;
    private int[] tableOffsets;
    private String[] planeIDs;
    static /* synthetic */ Class class$edu$uiowa$physics$pw$das$dataset$DefaultTableDataSet;

    public DefaultTableDataSet(double[] xTags, Units xUnits, double[][] yTags, Units yUnits, double[][][] zValues, Units zUnits, Map zValuesMap, Map zUnitsMap, Map properties) {
        super(xTags, xUnits, yUnits, zUnits, properties);
        if (zValuesMap == null ^ zUnitsMap == null) {
            throw new IllegalArgumentException("zValuesMap == null ^ zUnitsMap == null");
        }
        if (zValuesMap != null && !((Object)zValuesMap.keySet()).equals(zUnitsMap.keySet())) {
            throw new IllegalArgumentException("mismatched keySets for zValuesMap and zUnitsMap");
        }
        if (zValuesMap != null) {
            Iterator it = zValuesMap.keySet().iterator();
            while (it.hasNext()) {
                if (it.next() instanceof String) continue;
                throw new IllegalArgumentException("Non-String key found in zValuesMap");
            }
        }
        int planeCount = 1 + (zValuesMap == null ? 0 : zValuesMap.size());
        this.tableData = new double[planeCount][][];
        this.tableData[0] = this.flatten(zValues);
        this.yTags = DefaultTableDataSet.copy(yTags);
        this.zUnits = new Units[planeCount];
        this.zUnits[0] = zUnits;
        this.planeIDs = new String[planeCount];
        this.planeIDs[0] = "";
        this.tableOffsets = DefaultTableDataSet.computeTableOffsets(zValues, yTags);
        if (zValuesMap != null) {
            int index = 1;
            Iterator it = new TreeMap(zValuesMap).entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                String key = (String)entry.getKey();
                double[][][] d = (double[][][])entry.getValue();
                double[][] f = this.flatten(d);
                this.planeIDs[index] = key;
                this.tableData[index] = f;
                this.zUnits[index] = (Units)zUnitsMap.get(key);
            }
        }
    }

    private double[][] flatten(double[][][] d) {
        int sum = 0;
        for (int index = 0; index < d.length; ++index) {
            sum += d[index].length;
        }
        double[][] flat = new double[sum][];
        int offset = 0;
        for (int i = 0; i < d.length; ++i) {
            for (int j = 0; j < d[i].length; ++j) {
                flat[offset] = (double[])d[i][j].clone();
                ++offset;
            }
        }
        return flat;
    }

    public static DefaultTableDataSet createSimple(double[] xTags, double[] yTags, double[][] zValues) {
        int nx = zValues.length;
        int ny = zValues[0].length;
        if (xTags.length != nx) {
            throw new IllegalArgumentException("xTags (" + xTags.length + ") don't match zValues' first dimension (" + nx + "," + ny + ").");
        }
        if (yTags.length != ny) {
            throw new IllegalArgumentException("yTags (" + yTags.length + ") don't match zValues' first dimension (" + nx + "," + ny + ").");
        }
        return new DefaultTableDataSet(xTags, Units.dimensionless, yTags, Units.dimensionless, zValues, Units.dimensionless, new HashMap());
    }

    public DefaultTableDataSet(double[] xTags, Units xUnits, double[] yTags, Units yUnits, double[][] zValues, Units zUnits, Map properties) {
        this(xTags, xUnits, (double[][])new double[][]{yTags}, yUnits, (double[][][])new double[][][]{zValues}, zUnits, null, null, properties);
    }

    DefaultTableDataSet(double[] xTags, Units xUnits, double[][] yTags, Units yUnits, double[][][] zValues, Units[] zUnits, String[] planeIDs, int[] tableOffsets, Map properties) {
        super(xTags, xUnits, yUnits, zUnits[0], properties);
        this.yTags = yTags;
        this.tableData = zValues;
        this.zUnits = zUnits;
        this.planeIDs = planeIDs;
        this.tableOffsets = tableOffsets;
    }

    private static double[][][] copy(double[][][] d) {
        double[][][] copy = new double[d.length][][];
        for (int index = 0; index < d.length; ++index) {
            copy[index] = DefaultTableDataSet.copy(d[index]);
        }
        return copy;
    }

    private static double[][] copy(double[][] d) {
        double[][] copy = new double[d.length][];
        for (int index = 0; index < d.length; ++index) {
            copy[index] = (double[])d[index].clone();
        }
        return copy;
    }

    private static int[] computeTableOffsets(double[][][] tableData, double[][] yTags) {
        int[] tableOffsets = new int[tableData.length];
        int currentOffset = 0;
        for (int index = 0; index < tableOffsets.length; ++index) {
            tableOffsets[index] = currentOffset;
            currentOffset += tableData[index].length;
        }
        return tableOffsets;
    }

    public Datum getDatum(int i, int j) {
        int table = this.tableOfIndex(i);
        int yLength = this.yTags[table].length;
        if (i < 0 || i >= this.tableData[0].length) {
            IndexOutOfBoundsException ioobe = new IndexOutOfBoundsException("x index is out of bounds: " + i + " xLength: " + this.getXLength());
            Logger logger = DasApplication.getDefaultApplication().getLogger();
            logger.throwing((class$edu$uiowa$physics$pw$das$dataset$DefaultTableDataSet == null ? (class$edu$uiowa$physics$pw$das$dataset$DefaultTableDataSet = DefaultTableDataSet.class$("edu.uiowa.physics.pw.das.dataset.DefaultTableDataSet")) : class$edu$uiowa$physics$pw$das$dataset$DefaultTableDataSet).getName(), "getDatum(int,int)", ioobe);
            throw ioobe;
        }
        if (j < 0 || j >= this.yTags[table].length) {
            IndexOutOfBoundsException ioobe = new IndexOutOfBoundsException("y index is out of bounds: " + i + " yLength(" + table + "): " + this.getYLength(table));
            Logger logger = DasApplication.getDefaultApplication().getLogger();
            logger.throwing((class$edu$uiowa$physics$pw$das$dataset$DefaultTableDataSet == null ? (class$edu$uiowa$physics$pw$das$dataset$DefaultTableDataSet = DefaultTableDataSet.class$("edu.uiowa.physics.pw.das.dataset.DefaultTableDataSet")) : class$edu$uiowa$physics$pw$das$dataset$DefaultTableDataSet).getName(), "getDatum(int,int)", ioobe);
            throw ioobe;
        }
        double value = this.tableData[0][i][j];
        return Datum.create(value, this.zUnits[0]);
    }

    public DatumVector getScan(int i) {
        int table = this.tableOfIndex(i);
        if (i < 0 || i >= this.tableData[0].length) {
            IndexOutOfBoundsException ioobe = new IndexOutOfBoundsException("x index is out of bounds: " + i + " xLength: " + this.getXLength());
            Logger logger = DasApplication.getDefaultApplication().getLogger();
            logger.throwing((class$edu$uiowa$physics$pw$das$dataset$DefaultTableDataSet == null ? (class$edu$uiowa$physics$pw$das$dataset$DefaultTableDataSet = DefaultTableDataSet.class$("edu.uiowa.physics.pw.das.dataset.DefaultTableDataSet")) : class$edu$uiowa$physics$pw$das$dataset$DefaultTableDataSet).getName(), "getDatum(int,int)", ioobe);
            throw ioobe;
        }
        double[] values = this.tableData[0][i];
        return DatumVector.newDatumVector(values, 0, this.getYLength(table), this.zUnits[0]);
    }

    public double getDouble(int i, int j, Units units) {
        int table = this.tableOfIndex(i);
        int yLength = this.yTags[table].length;
        double value = this.tableData[0][i][j];
        if (units == this.getZUnits()) {
            return value;
        }
        return this.zUnits[0].getConverter(units).convert(value);
    }

    public double[] getDoubleScan(int i, Units units) {
        int table = this.tableOfIndex(i);
        int yLength = this.yTags[table].length;
        double[] values = this.tableData[0][i];
        double[] retValues = new double[yLength];
        if (units == this.getZUnits()) {
            System.arraycopy(values, 0, retValues, 0, yLength);
        } else {
            UnitsConverter uc = this.zUnits[0].getConverter(units);
            for (int j = 0; j < yLength; ++j) {
                retValues[j] = uc.convert(values[j]);
            }
        }
        return retValues;
    }

    public int getInt(int i, int j, Units units) {
        return (int)Math.round(this.getDouble(i, j, units));
    }

    public DataSet getPlanarView(String planeID) {
        int planeIndex = -1;
        for (int index = 0; index < this.planeIDs.length; ++index) {
            if (!this.planeIDs[index].equals(planeID)) continue;
            planeIndex = index;
        }
        if (planeIndex == -1) {
            return null;
        }
        return new PlanarViewDataSet(planeIndex);
    }

    public String[] getPlaneIds() {
        String[] result = new String[this.planeIDs.length];
        System.arraycopy(this.planeIDs, 0, result, 0, this.planeIDs.length);
        return result;
    }

    public int getYLength(int table) {
        return this.yTags[table].length;
    }

    public Datum getYTagDatum(int table, int j) {
        double value = this.yTags[table][j];
        return Datum.create(value, this.getYUnits());
    }

    public double getYTagDouble(int table, int j, Units units) {
        double value = this.yTags[table][j];
        if (units == this.getYUnits()) {
            return value;
        }
        return this.getYUnits().getConverter(units).convert(value);
    }

    public int getYTagInt(int table, int j, Units units) {
        return (int)Math.round(this.getYTagDouble(table, j, units));
    }

    public DatumVector getYTags(int table) {
        return DatumVector.newDatumVector(this.yTags[table], 0, this.getYLength(table), this.getYUnits());
    }

    public int tableCount() {
        return this.yTags.length;
    }

    public int tableEnd(int table) {
        if (table == this.tableOffsets.length - 1) {
            return this.getXLength();
        }
        return this.tableOffsets[table + 1];
    }

    public int tableOfIndex(int i) {
        int table = Arrays.binarySearch(this.tableOffsets, i);
        if (i >= this.getXLength()) {
            throw new IndexOutOfBoundsException(i + " > " + this.getXLength());
        }
        if (table < 0) {
            table = ~table - 1;
        }
        return table;
    }

    public int tableStart(int table) {
        return this.tableOffsets[table];
    }

    public void dump(PrintStream out) {
        String str;
        MessageFormat tableFormat = new MessageFormat("        {0,number,00}. Y Length: {1,number,000}, Start: {2,number,000}, End: {3,number,000}");
        MessageFormat planeFormat = new MessageFormat("        ID: {0}, Z Units: ''{1}''");
        out.println("============================================================");
        out.println(this.getClass().getName());
        out.println("    X Length:    " + this.getXLength());
        out.println("    X Units:     '" + this.getXUnits() + "'");
        out.print("    X Tags:");
        for (int index = 0; index < this.getXLength(); ++index) {
            out.print(" ");
            out.print(this.getXTagDouble(index, this.getXUnits()));
        }
        out.println();
        out.println("    Y Units:     '" + this.getYUnits() + "'");
        out.println("    Z Units:     '" + this.getZUnits() + "'");
        out.println("    Table Count: " + this.tableCount());
        Object[] args = new Object[4];
        for (int table = 0; table < this.tableCount(); ++table) {
            args[0] = new Integer(table);
            args[1] = new Integer(this.yTags[table].length);
            args[2] = new Integer(this.tableStart(table));
            args[3] = new Integer(this.tableEnd(table));
            str = tableFormat.format(args);
            out.println(str);
            out.print("        Y Tags:");
            for (int index = 0; index < this.getYLength(table); ++index) {
                out.print(" ");
                out.print(this.getYTagDouble(table, index, this.getXUnits()));
            }
            out.println();
            out.println("        Z Values:");
            for (int j = 0; j < this.getYLength(table); ++j) {
                out.print("        ");
                for (int i = this.tableStart(table); i < this.tableEnd(table); ++i) {
                    out.print(this.getDouble(i, j, this.getZUnits()));
                    out.print("\t");
                }
                out.println();
            }
        }
        out.println("    Plane Count: " + this.planeIDs.length);
        for (int plane = 1; plane < this.planeIDs.length; ++plane) {
            args[0] = this.planeIDs[plane];
            args[1] = this.zUnits[plane];
            str = planeFormat.format(args);
            out.println(str);
        }
        out.println("============================================================");
    }

    public String toString() {
        return "DefaultTableDataSet " + TableUtil.toString(this);
    }

    public void printDebugInfo(PrintStream out) {
        out.println("xLength: " + this.getXLength());
        out.println("tableCount: " + this.tableCount());
        for (int table = 0; table < this.tableCount(); ++table) {
            out.println("tableStart(" + table + "): " + this.tableStart(table));
            out.println("yLength: " + this.getYLength(table));
            for (int i = this.tableStart(table); i < this.tableEnd(table); ++i) {
                out.println(i + ": " + this.tableData[0][i].length);
            }
            out.println("tableEnd(" + table + "): " + this.tableEnd(table));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private final class PlanarViewDataSet
    extends AbstractDataSet.ViewDataSet
    implements TableDataSet {
        private final int index;

        private PlanarViewDataSet(int index) {
            this.index = index;
        }

        public DataSet getPlanarView(String planeID) {
            return null;
        }

        public String[] getPlaneIds() {
            return new String[0];
        }

        public Datum getDatum(int i, int j) {
            int table = this.tableOfIndex(i);
            int yLength = DefaultTableDataSet.this.yTags[table].length;
            double value = DefaultTableDataSet.this.tableData[this.index][i][j];
            return Datum.create(value, DefaultTableDataSet.this.zUnits[this.index]);
        }

        public double getDouble(int i, int j, Units units) {
            int table = this.tableOfIndex(i);
            int yLength = DefaultTableDataSet.this.yTags[table].length;
            double value = DefaultTableDataSet.this.tableData[this.index][i][j];
            return DefaultTableDataSet.this.zUnits[this.index].getConverter(units).convert(value);
        }

        public double[] getDoubleScan(int i, Units units) {
            int table = this.tableOfIndex(i);
            int yLength = DefaultTableDataSet.this.yTags[table].length;
            double[] values = DefaultTableDataSet.this.tableData[this.index][i];
            double[] retValues = new double[yLength];
            if (units == this.getZUnits()) {
                System.arraycopy(values, 0, retValues, 0, yLength);
            } else {
                UnitsConverter uc = DefaultTableDataSet.this.zUnits[this.index].getConverter(units);
                for (int j = 0; j < yLength; ++j) {
                    retValues[j] = uc.convert(values[j]);
                }
            }
            return retValues;
        }

        public DatumVector getScan(int i) {
            int table = this.tableOfIndex(i);
            if (i < 0 || i >= DefaultTableDataSet.this.tableData[0].length) {
                IndexOutOfBoundsException ioobe = new IndexOutOfBoundsException("x index is out of bounds: " + i + " xLength: " + this.getXLength());
                Logger logger = DasApplication.getDefaultApplication().getLogger();
                logger.throwing((class$edu$uiowa$physics$pw$das$dataset$DefaultTableDataSet == null ? (class$edu$uiowa$physics$pw$das$dataset$DefaultTableDataSet = DefaultTableDataSet.class$("edu.uiowa.physics.pw.das.dataset.DefaultTableDataSet")) : class$edu$uiowa$physics$pw$das$dataset$DefaultTableDataSet).getName(), "getDatum(int,int)", ioobe);
                throw ioobe;
            }
            double[] values = DefaultTableDataSet.this.tableData[this.index][i];
            return DatumVector.newDatumVector(values, 0, this.getYLength(table), DefaultTableDataSet.this.zUnits[this.index]);
        }

        public int getInt(int i, int j, Units units) {
            return (int)Math.round(this.getDouble(i, j, units));
        }

        public VectorDataSet getXSlice(int i) {
            return new AbstractTableDataSet.XSliceDataSet(this, i);
        }

        public int getYLength(int table) {
            return DefaultTableDataSet.this.getYLength(table);
        }

        public VectorDataSet getYSlice(int j, int table) {
            return new AbstractTableDataSet.YSliceDataSet(this, j, table);
        }

        public Datum getYTagDatum(int table, int j) {
            return DefaultTableDataSet.this.getYTagDatum(table, j);
        }

        public double getYTagDouble(int table, int j, Units units) {
            return DefaultTableDataSet.this.getYTagDouble(table, j, units);
        }

        public int getYTagInt(int table, int j, Units units) {
            return DefaultTableDataSet.this.getYTagInt(table, j, units);
        }

        public Units getZUnits() {
            return DefaultTableDataSet.this.zUnits[this.index];
        }

        public int tableCount() {
            return DefaultTableDataSet.this.tableCount();
        }

        public int tableEnd(int table) {
            return DefaultTableDataSet.this.tableEnd(table);
        }

        public int tableOfIndex(int i) {
            return DefaultTableDataSet.this.tableOfIndex(i);
        }

        public int tableStart(int table) {
            return DefaultTableDataSet.this.tableStart(table);
        }

        public Object getProperty(String name) {
            Object result = DefaultTableDataSet.this.getProperty(DefaultTableDataSet.this.planeIDs[this.index] + "." + name);
            if (result == null) {
                result = DefaultTableDataSet.this.getProperty(name);
            }
            return result;
        }

        public DatumVector getYTags(int table) {
            return DefaultTableDataSet.this.getYTags(table);
        }

        public String toString() {
            return TableUtil.toString(this);
        }
    }
}

