/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.dataset;

import edu.uiowa.physics.pw.das.DasApplication;
import edu.uiowa.physics.pw.das.DasException;
import edu.uiowa.physics.pw.das.DasIOException;
import edu.uiowa.physics.pw.das.client.DasServer;
import edu.uiowa.physics.pw.das.client.DataSetDescriptorNotAvailableException;
import edu.uiowa.physics.pw.das.client.NoSuchDataSetException;
import edu.uiowa.physics.pw.das.client.StreamDataSetDescriptor;
import edu.uiowa.physics.pw.das.dataset.CacheTag;
import edu.uiowa.physics.pw.das.dataset.ConstantDataSetDescriptor;
import edu.uiowa.physics.pw.das.dataset.DataSet;
import edu.uiowa.physics.pw.das.dataset.DataSetUpdateEvent;
import edu.uiowa.physics.pw.das.dataset.DataSetUpdateListener;
import edu.uiowa.physics.pw.das.dataset.NoDataInIntervalException;
import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.Units;
import edu.uiowa.physics.pw.das.stream.StreamDescriptor;
import edu.uiowa.physics.pw.das.system.RequestProcessor;
import edu.uiowa.physics.pw.das.util.DasProgressMonitor;
import edu.uiowa.physics.pw.das.util.URLBuddy;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.event.EventListenerList;

public abstract class DataSetDescriptor {
    protected Map properties = new HashMap();
    private boolean defaultCaching = true;
    private DataSet cacheDataSet;
    private String dataSetID;
    private CacheTag cacheTag = null;
    private EventListenerList listenerList;
    private static final Pattern CLASS_ID = Pattern.compile("class:([a-zA-Z0-9_\\.]+)(?:\\?(.*))?");
    private static final Pattern NAME_VALUE = Pattern.compile("([_0-9a-zA-Z%+.-]+)=([_0-9a-zA-Z%+.-]+)");
    static /* synthetic */ Class class$edu$uiowa$physics$pw$das$dataset$DataSetUpdateListener;
    static /* synthetic */ Class class$java$util$Map;

    protected DataSetDescriptor(String dataSetID) {
        this.dataSetID = dataSetID;
    }

    protected DataSetDescriptor() {
        this("");
    }

    protected abstract DataSet getDataSetImpl(Datum var1, Datum var2, Datum var3, DasProgressMonitor var4) throws DasException;

    public abstract Units getXUnits();

    public void requestDataSet(Datum start, Datum end, Datum resolution, DasProgressMonitor monitor) {
        DataSetUpdateEvent dsue;
        try {
            DataSet ds = this.getDataSet(start, end, resolution, monitor);
            dsue = ds == null ? new DataSetUpdateEvent(this, new NoDataInIntervalException(start + " to " + end)) : new DataSetUpdateEvent(this, ds);
        }
        catch (DasException de) {
            dsue = new DataSetUpdateEvent(this, de);
        }
        this.fireDataSetUpdateEvent(dsue);
    }

    public void requestDataSet(final Datum start, final Datum end, final Datum resolution, final DasProgressMonitor monitor, final DataSetUpdateListener listener) {
        if (this instanceof ConstantDataSetDescriptor) {
            try {
                DataSet ds = this.getDataSet(null, null, null, null);
                DataSetUpdateEvent dsue = new DataSetUpdateEvent(this, ds);
            }
            catch (DasException e) {
                DataSetUpdateEvent dsue = new DataSetUpdateEvent(this, e);
                listener.dataSetUpdated(dsue);
            }
        } else {
            Runnable request = new Runnable(){

                public void run() {
                    DasApplication.getDefaultApplication().getLogger(DasApplication.GRAPHICS_LOG).info("request data from dsd: " + start + " " + end + " " + resolution);
                    try {
                        DataSet ds = DataSetDescriptor.this.getDataSet(start, end, resolution, monitor);
                        DataSetUpdateEvent dsue = new DataSetUpdateEvent(DataSetDescriptor.this, ds);
                        listener.dataSetUpdated(dsue);
                    }
                    catch (DasException e) {
                        DataSetUpdateEvent dsue = new DataSetUpdateEvent(DataSetDescriptor.this, e);
                        listener.dataSetUpdated(dsue);
                    }
                }

                public String toString() {
                    return "loadDataSet " + start + " - " + end;
                }
            };
            RequestProcessor.invokeLater(request, listener);
        }
    }

    public DataSet getDataSet(Datum start, Datum end, Datum resolution, DasProgressMonitor monitor) throws DasException {
        if (monitor != null) {
            monitor.started();
        }
        if (this.cacheTag != null && this.defaultCaching && this.cacheTag.start.le(start) && this.cacheTag.end.ge(end) && (this.cacheTag.resolution == null || resolution != null && this.cacheTag.resolution.le(resolution))) {
            if (monitor != null) {
                monitor.finished();
            }
            return this.cacheDataSet;
        }
        DataSet ds = this.getDataSetImpl(start, end, resolution, monitor);
        if (ds != null) {
            this.cacheDataSet = ds;
            this.cacheTag = (CacheTag)this.cacheDataSet.getProperty("cacheTag");
            if (this.cacheTag == null) {
                this.cacheTag = new CacheTag(start, end, resolution);
            }
        }
        if (monitor != null) {
            monitor.finished();
        }
        return this.cacheDataSet;
    }

    public void reset() {
        this.cacheTag = null;
    }

    protected void setDefaultCaching(boolean value) {
        this.defaultCaching = value;
    }

    public void addDataSetUpdateListener(DataSetUpdateListener listener) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.add(class$edu$uiowa$physics$pw$das$dataset$DataSetUpdateListener == null ? (class$edu$uiowa$physics$pw$das$dataset$DataSetUpdateListener = DataSetDescriptor.class$("edu.uiowa.physics.pw.das.dataset.DataSetUpdateListener")) : class$edu$uiowa$physics$pw$das$dataset$DataSetUpdateListener, listener);
    }

    public void removeDataSetUpdateListener(DataSetUpdateListener listener) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.remove(class$edu$uiowa$physics$pw$das$dataset$DataSetUpdateListener == null ? (class$edu$uiowa$physics$pw$das$dataset$DataSetUpdateListener = DataSetDescriptor.class$("edu.uiowa.physics.pw.das.dataset.DataSetUpdateListener")) : class$edu$uiowa$physics$pw$das$dataset$DataSetUpdateListener, listener);
    }

    protected void fireDataSetUpdateEvent(DataSetUpdateEvent event) {
        if (this.listenerList == null) {
            return;
        }
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$edu$uiowa$physics$pw$das$dataset$DataSetUpdateListener == null ? DataSetDescriptor.class$("edu.uiowa.physics.pw.das.dataset.DataSetUpdateListener") : class$edu$uiowa$physics$pw$das$dataset$DataSetUpdateListener)) continue;
            ((DataSetUpdateListener)listeners[i + 1]).dataSetUpdated(event);
        }
    }

    public String getDataSetID() {
        return this.dataSetID;
    }

    /*
     * WARNING - void declaration
     */
    public static DataSetDescriptor create(String dataSetID) throws DasException {
        void var2_2;
        DataSetDescriptor result;
        Matcher classMatcher = CLASS_ID.matcher(dataSetID);
        if (classMatcher.matches()) {
            result = DataSetDescriptor.createFromClassName(dataSetID, classMatcher);
        } else {
            try {
                result = DataSetDescriptor.createFromServerAddress(new URL(dataSetID));
            }
            catch (MalformedURLException mue) {
                throw new DasIOException(mue.getMessage());
            }
        }
        var2_2.dataSetID = dataSetID;
        return var2_2;
    }

    private static DataSetDescriptor createFromServerAddress(URL url) throws DasException {
        DasServer server = DasServer.create(url);
        StreamDescriptor sd = server.getStreamDescriptor(url);
        return new StreamDataSetDescriptor(sd, server.getStandardDataStreamSource(url));
    }

    private static DataSetDescriptor createFromClassName(String dataSetID, Matcher matcher) throws DasException {
        try {
            String className = matcher.group(1);
            String argString = matcher.group(2);
            Map argMap = argString == null ? Collections.EMPTY_MAP : URLBuddy.parseQueryString(argString);
            Class<?> dsdClass = Class.forName(className);
            Method method = dsdClass.getMethod("newDataSetDescriptor", class$java$util$Map == null ? (class$java$util$Map = DataSetDescriptor.class$("java.util.Map")) : class$java$util$Map);
            if (!Modifier.isStatic(method.getModifiers())) {
                throw new NoSuchDataSetException("newDataSetDescriptor must be static");
            }
            return (DataSetDescriptor)method.invoke(null, argMap);
        }
        catch (ClassNotFoundException cnfe) {
            DataSetDescriptorNotAvailableException dsdnae = new DataSetDescriptorNotAvailableException(cnfe.getMessage());
            dsdnae.initCause(cnfe);
            throw dsdnae;
        }
        catch (NoSuchMethodException nsme) {
            DataSetDescriptorNotAvailableException dsdnae = new DataSetDescriptorNotAvailableException(nsme.getMessage());
            dsdnae.initCause(nsme);
            throw dsdnae;
        }
        catch (InvocationTargetException ite) {
            DataSetDescriptorNotAvailableException dsdnae = new DataSetDescriptorNotAvailableException(ite.getTargetException().getMessage());
            dsdnae.initCause(ite.getTargetException());
            throw dsdnae;
        }
        catch (IllegalAccessException iae) {
            DataSetDescriptorNotAvailableException dsdnae = new DataSetDescriptorNotAvailableException(iae.getMessage());
            dsdnae.initCause(iae);
            throw dsdnae;
        }
    }

    protected void setProperties(Map properties) {
        this.properties.putAll(properties);
    }

    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

