/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.dataset;

import edu.uiowa.physics.pw.das.DasException;
import edu.uiowa.physics.pw.das.dataset.DataRequestor;
import edu.uiowa.physics.pw.das.dataset.DataSet;
import edu.uiowa.physics.pw.das.dataset.DataSetDescriptor;
import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.util.DasProgressMonitor;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class DataRequestThread
extends Thread {
    private static int threadCount = 0;
    private Object lock = new String("DATA_REQUEST_LOCK");
    private DataRequest currentRequest;
    private List queue = Collections.synchronizedList(new LinkedList());

    public DataRequestThread() {
        this.setName("DataRequest_" + threadCount++);
        this.setDaemon(true);
        this.start();
    }

    public void request(DataSetDescriptor dsd, Datum start, Datum end, Datum resolution, DataRequestor requestor, DasProgressMonitor monitor) throws InterruptedException {
        this.requestInternal(new DataRequest(dsd, start, end, resolution, requestor, monitor));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestAndWait(DataSetDescriptor dsd, Object params, Datum start, Datum end, Datum resolution, DataRequestor requestor, DasProgressMonitor monitor) throws InterruptedException {
        DataRequest request;
        DataRequest dataRequest = request = new DataRequest(dsd, start, end, resolution, requestor, monitor);
        synchronized (dataRequest) {
            this.requestInternal(request);
            request.wait();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void requestInternal(DataRequest request) {
        this.queue.add(request);
        Object object = this.lock;
        synchronized (object) {
            this.lock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelCurrentRequest() throws InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            if (this.isAlive()) {
                this.interrupt();
                this.lock.wait();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        if (Thread.currentThread() != this) {
            throw new IllegalStateException("This method should not be invoked directly");
        }
        while (true) {
            if (!this.queue.isEmpty()) {
                DataRequest dataRequest;
                Object var3_3;
                this.currentRequest = (DataRequest)this.queue.remove(0);
                try {
                    try {
                        DataSet ds = this.currentRequest.dsd.getDataSet(this.currentRequest.start, this.currentRequest.end, this.currentRequest.resolution, this.currentRequest.monitor);
                        this.currentRequest.requestor.finished(ds);
                    }
                    catch (DasException e) {
                        this.currentRequest.requestor.exception(e);
                        var3_3 = null;
                        dataRequest = this.currentRequest;
                        synchronized (dataRequest) {
                            this.currentRequest.notifyAll();
                            continue;
                        }
                    }
                    var3_3 = null;
                    dataRequest = this.currentRequest;
                }
                catch (Throwable throwable) {
                    var3_3 = null;
                    dataRequest = this.currentRequest;
                    synchronized (dataRequest) {
                        this.currentRequest.notifyAll();
                        throw throwable;
                    }
                }
                synchronized (dataRequest) {
                    this.currentRequest.notifyAll();
                    continue;
                }
            }
            Object object = this.lock;
            synchronized (object) {
                try {
                    this.lock.wait();
                }
                catch (InterruptedException ie) {
                    return;
                }
            }
        }
    }

    private static class DataRequest {
        DataSetDescriptor dsd;
        Datum start;
        Datum end;
        Object params;
        Datum resolution;
        DataRequestor requestor;
        DasProgressMonitor monitor;

        DataRequest(DataSetDescriptor dsd, Datum start, Datum end, Datum resolution, DataRequestor requestor, DasProgressMonitor monitor) {
            this.dsd = dsd;
            this.start = start;
            this.end = end;
            this.resolution = resolution;
            this.requestor = requestor;
            this.monitor = monitor;
        }
    }
}

