/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.dasml;

import edu.uiowa.physics.pw.das.DasPropertyException;
import edu.uiowa.physics.pw.das.NameContext;
import edu.uiowa.physics.pw.das.dasml.DataFormatException;
import edu.uiowa.physics.pw.das.dasml.ParsedExpressionException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ParsedExpression {
    private static final Pattern SIMPLE_NAME_PATTERN = Pattern.compile("[A-Za-z_][A-Za-z0-9_-]*");
    private static final Pattern INT_PATTERN = Pattern.compile("-?(0|[1-9][0-9]*)");
    private static final Pattern FLOAT_PATTERN = Pattern.compile("-?[0-9]*(\\.[0-9]*)?([eE]-?[0-9]+)?");
    private static final Pattern PAREN_PATTERN = Pattern.compile("\\(([^\\(\\)])\\)");
    private static final Pattern EQUALITY_PATTERN = Pattern.compile("\\b(eq|ne)\\b");
    private static final Pattern COMPARISON_PATTERN = Pattern.compile("\\b(lt|le|gt|ge)\\b");
    private static final Pattern OR_PATTERN = Pattern.compile("\\bor\\b");
    private static final Pattern AND_PATTERN = Pattern.compile("\\band\\b");
    private static final Pattern NOT_PATTERN = Pattern.compile("\\Anot\\b");
    static final int ID_LOAD = 0;
    static final int ID_ALOAD = 1;
    static final int ID_STORE = 2;
    static final int ID_ASTORE = 3;
    static final int ID_ADD = 4;
    static final int ID_SUBTRACT = 5;
    static final int ID_MULTIPLY = 6;
    static final int ID_DIVIDE = 7;
    static final int ID_NEGATE = 8;
    static final int ID_EQ = 9;
    static final int ID_NE = 10;
    static final int ID_GT = 11;
    static final int ID_LT = 12;
    static final int ID_GE = 13;
    static final int ID_LE = 14;
    static final int ID_OR = 15;
    static final int ID_AND = 16;
    static final int ID_NOT = 17;
    private List list;
    private String expression;
    static /* synthetic */ Class class$java$lang$Number;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Byte;

    public ParsedExpression(String expression) throws ParsedExpressionException {
        this.expression = expression;
        this.list = new LinkedList();
        if (!ParsedExpression.parseExpression(expression, this.list)) {
            throw new ParsedExpressionException("Invalid expression");
        }
    }

    public String toString() {
        return this.expression;
    }

    private static boolean parseExpression(String s, List queue) {
        return ParsedExpression.parseOrExpression(s, queue);
    }

    private static boolean parseOrExpression(String expression, List queue) {
        if (expression.length() < 1) {
            return false;
        }
        Matcher matcher = OR_PATTERN.matcher(expression);
        while (matcher.find()) {
            String andExpression = expression.substring(matcher.end()).trim();
            String orExpression = expression.substring(0, matcher.start()).trim();
            LinkedList leftList = new LinkedList();
            LinkedList rightList = new LinkedList();
            if (!ParsedExpression.parseAndExpression(andExpression, rightList) || !ParsedExpression.parseOrExpression(orExpression, leftList)) continue;
            queue.addAll(leftList);
            queue.addAll(rightList);
            queue.add(Op.OR);
            return true;
        }
        return ParsedExpression.parseAndExpression(expression, queue);
    }

    private static boolean parseAndExpression(String expression, List queue) {
        if (expression.length() < 1) {
            return false;
        }
        Matcher matcher = AND_PATTERN.matcher(expression);
        while (matcher.find()) {
            String notExpression = expression.substring(matcher.end()).trim();
            String andExpression = expression.substring(0, matcher.start()).trim();
            LinkedList leftList = new LinkedList();
            LinkedList rightList = new LinkedList();
            if (!ParsedExpression.parseNotExpression(notExpression, rightList) || !ParsedExpression.parseAndExpression(andExpression, leftList)) continue;
            queue.addAll(leftList);
            queue.addAll(rightList);
            queue.add(Op.AND);
            return true;
        }
        return ParsedExpression.parseNotExpression(expression, queue);
    }

    private static boolean parseNotExpression(String expression, List queue) {
        if (expression.length() < 1) {
            return false;
        }
        Matcher matcher = NOT_PATTERN.matcher(expression);
        if (matcher.find()) {
            LinkedList list;
            String equalityExpression = expression.substring(matcher.end()).trim();
            if (ParsedExpression.parseEqualityExpression(equalityExpression, list = new LinkedList())) {
                queue.addAll(list);
                queue.add(Op.NOT);
                return true;
            }
            return false;
        }
        return ParsedExpression.parseEqualityExpression(expression, queue);
    }

    private static boolean parseEqualityExpression(String expression, List queue) {
        if (expression.length() < 1) {
            return false;
        }
        Matcher matcher = EQUALITY_PATTERN.matcher(expression);
        while (matcher.find()) {
            String relationalExpression = expression.substring(matcher.end()).trim();
            String equalityExpression = expression.substring(0, matcher.start()).trim();
            LinkedList leftList = new LinkedList();
            LinkedList rightList = new LinkedList();
            if (!ParsedExpression.parseRelationalExpression(relationalExpression, rightList) || !ParsedExpression.parseEqualityExpression(equalityExpression, leftList)) continue;
            queue.addAll(leftList);
            queue.addAll(rightList);
            String op = matcher.group(1);
            if (op.equals("eq")) {
                queue.add(Op.EQ);
            } else {
                queue.add(Op.NE);
            }
            return true;
        }
        return ParsedExpression.parseRelationalExpression(expression, queue);
    }

    private static boolean parseRelationalExpression(String expression, List queue) {
        if (expression.length() < 1) {
            return false;
        }
        Matcher matcher = COMPARISON_PATTERN.matcher(expression);
        while (matcher.find()) {
            String additiveExpression = expression.substring(matcher.end()).trim();
            String relationalExpression = expression.substring(0, matcher.start()).trim();
            LinkedList leftList = new LinkedList();
            LinkedList rightList = new LinkedList();
            if (!ParsedExpression.parseAdditiveExpression(additiveExpression, rightList) || !ParsedExpression.parseRelationalExpression(relationalExpression, leftList)) continue;
            queue.addAll(leftList);
            queue.addAll(rightList);
            String op = matcher.group(1);
            if (op.equals("lt")) {
                queue.add(Op.LT);
            } else if (op.equals("le")) {
                queue.add(Op.LE);
            } else if (op.equals("gt")) {
                queue.add(Op.GT);
            } else {
                queue.add(Op.GE);
            }
            return true;
        }
        return ParsedExpression.parseAdditiveExpression(expression, queue);
    }

    private static boolean parseAdditiveExpression(String expression, List queue) {
        if (expression.length() < 1) {
            return false;
        }
        int index = Math.max(expression.lastIndexOf(43), expression.lastIndexOf(45));
        while (index >= 0) {
            String multiplicativeExpression = expression.substring(index + 1).trim();
            String additiveExpression = expression.substring(0, index).trim();
            LinkedList leftList = new LinkedList();
            LinkedList rightList = new LinkedList();
            if (ParsedExpression.parseMultiplicativeExpression(multiplicativeExpression, rightList) && ParsedExpression.parseAdditiveExpression(additiveExpression, leftList)) {
                queue.addAll(leftList);
                queue.addAll(rightList);
                queue.add(expression.charAt(index) == '+' ? Op.ADD : Op.SUBTRACT);
                return true;
            }
            index = Math.max(expression.lastIndexOf(43, index - 1), expression.lastIndexOf(45, index - 1));
        }
        return ParsedExpression.parseMultiplicativeExpression(expression, queue);
    }

    private static boolean parseMultiplicativeExpression(String expression, List queue) {
        if (expression.length() < 1) {
            return false;
        }
        int index = Math.max(expression.lastIndexOf(42), expression.lastIndexOf(47));
        while (index >= 0) {
            String unaryExpression = expression.substring(index + 1).trim();
            String multiplicativeExpression = expression.substring(0, index).trim();
            LinkedList leftList = new LinkedList();
            LinkedList rightList = new LinkedList();
            if (!ParsedExpression.parseUnaryExpression(unaryExpression, rightList) || !ParsedExpression.parseMultiplicativeExpression(multiplicativeExpression, leftList)) continue;
            queue.addAll(leftList);
            queue.addAll(rightList);
            queue.add(expression.charAt(index) == '*' ? Op.MULTIPLY : Op.DIVIDE);
            return true;
        }
        return ParsedExpression.parseUnaryExpression(expression, queue);
    }

    private static boolean parseUnaryExpression(String expression, List queue) {
        return ParsedExpression.parseNegateExpression(expression, queue);
    }

    private static boolean parseNegateExpression(String expression, List queue) {
        if (expression.length() < 1) {
            return false;
        }
        if (expression.charAt(0) == '-') {
            LinkedList list = new LinkedList();
            boolean result = ParsedExpression.parseSimpleExpression(expression.substring(1).trim(), list);
            if (result) {
                queue.addAll(list);
                queue.add(Op.NEGATE);
                return true;
            }
            return false;
        }
        return ParsedExpression.parseSimpleExpression(expression, queue);
    }

    private static boolean parseSimpleExpression(String expression, List queue) {
        if (expression.length() < 1) {
            return false;
        }
        if (expression.startsWith("(") && expression.endsWith(")")) {
            LinkedList list = new LinkedList();
            boolean result = ParsedExpression.parseExpression(expression.substring(1, expression.length() - 1).trim(), list);
            if (result) {
                queue.addAll(list);
                return true;
            }
            return false;
        }
        if (expression.startsWith("${") && expression.endsWith("}")) {
            LinkedList list = new LinkedList();
            boolean result = ParsedExpression.parseArrayAccess(expression.substring(2, expression.length() - 1).trim(), list);
            if (result) {
                queue.addAll(list);
            }
            return result;
        }
        Matcher matcher = INT_PATTERN.matcher(expression);
        if (matcher.matches()) {
            queue.add(new Integer(expression));
            return true;
        }
        matcher = FLOAT_PATTERN.matcher(expression);
        if (matcher.matches()) {
            queue.add(new Double(expression));
            return true;
        }
        if (expression.equals("true")) {
            queue.add(Boolean.TRUE);
            return true;
        }
        if (expression.equals("false")) {
            queue.add(Boolean.FALSE);
            return true;
        }
        return false;
    }

    private static boolean parseArrayAccess(String expression, List queue) {
        if ((expression = expression.trim()).length() < 1) {
            return false;
        }
        if (SIMPLE_NAME_PATTERN.matcher(expression).matches()) {
            queue.add(null);
            queue.add(expression);
            queue.add(Op.LOAD);
            return true;
        }
        if (expression.charAt(expression.length() - 1) == ']') {
            int index = expression.lastIndexOf(91);
            while (index >= 0) {
                boolean leftResult;
                int dotIndex = expression.lastIndexOf(46, index);
                String arrayAccess = expression.substring(0, dotIndex);
                String simpleName = expression.substring(dotIndex + 1, index).trim();
                String indexExpression = expression.substring(index + 1, expression.length() - 2).trim();
                if (!SIMPLE_NAME_PATTERN.matcher(simpleName).matches()) {
                    return false;
                }
                LinkedList leftList = new LinkedList();
                LinkedList rightList = new LinkedList();
                boolean rightResult = ParsedExpression.parseExpression(indexExpression, rightList);
                if (!rightResult || !(leftResult = ParsedExpression.parseArrayAccess(arrayAccess, leftList))) continue;
                queue.addAll(leftList);
                queue.addAll(rightList);
                queue.add(Op.ALOAD);
                return true;
            }
        } else {
            int index = expression.lastIndexOf(46);
            while (index > 0) {
                String arrayAccess = expression.substring(0, index);
                String simpleName = expression.substring(index + 1);
                if (!SIMPLE_NAME_PATTERN.matcher(simpleName).matches()) {
                    return false;
                }
                LinkedList leftList = new LinkedList();
                boolean leftResult = ParsedExpression.parseArrayAccess(arrayAccess, leftList);
                if (!leftResult) continue;
                queue.addAll(leftList);
                queue.add(simpleName);
                queue.add(Op.LOAD);
                return true;
            }
        }
        return false;
    }

    public Object evaluate(NameContext nc) throws ParsedExpressionException, DasPropertyException {
        try {
            return ParsedExpression.evaluate(this.list, nc);
        }
        catch (InvocationTargetException ite) {
            Throwable t = ite.getTargetException();
            if (t instanceof DataFormatException) {
                ParsedExpressionException pee = new ParsedExpressionException(t.getMessage());
                pee.initCause(t);
                throw pee;
            }
            throw new RuntimeException(ite);
        }
    }

    private static Object evaluate(List list, NameContext nc) throws ParsedExpressionException, InvocationTargetException, DasPropertyException {
        if (list.size() == 0) {
            throw new RuntimeException("empty expression");
        }
        if (list.size() == 1 && !(list.get(0) instanceof Op)) {
            return list.get(0);
        }
        ArrayList stack = new ArrayList(list.size());
        Iterator i = list.iterator();
        while (i.hasNext()) {
            Object o = i.next();
            if (o instanceof Op) {
                Op op = (Op)o;
                ParsedExpression.evaluate(stack, op.id, nc);
                continue;
            }
            ParsedExpression.push(stack, o);
        }
        if (stack.size() != 1) {
            throw new IllegalArgumentException("Invalid expression: " + list);
        }
        return ParsedExpression.pop(stack);
    }

    private static void evaluate(List stack, int id, NameContext nc) throws InvocationTargetException, ParsedExpressionException, DasPropertyException {
        switch (id) {
            case 0: {
                ParsedExpression.load(stack, nc);
                break;
            }
            case 1: {
                ParsedExpression.aload(stack, nc);
                break;
            }
            case 2: {
                ParsedExpression.store(stack, nc);
                break;
            }
            case 3: {
                ParsedExpression.astore(stack, nc);
                break;
            }
            case 8: {
                ParsedExpression.negate(stack);
                break;
            }
            case 4: {
                ParsedExpression.add(stack);
                break;
            }
            case 5: {
                ParsedExpression.subtract(stack);
                break;
            }
            case 6: {
                ParsedExpression.multiply(stack);
                break;
            }
            case 7: {
                ParsedExpression.divide(stack);
                break;
            }
            case 9: {
                ParsedExpression.eq(stack);
                break;
            }
            case 10: {
                ParsedExpression.ne(stack);
                break;
            }
            case 11: {
                ParsedExpression.gt(stack);
                break;
            }
            case 12: {
                ParsedExpression.lt(stack);
                break;
            }
            case 13: {
                ParsedExpression.ge(stack);
                break;
            }
            case 14: {
                ParsedExpression.le(stack);
                break;
            }
            case 15: {
                ParsedExpression.or(stack);
                break;
            }
            case 16: {
                ParsedExpression.and(stack);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    private static Object pop(List stack) {
        return stack.remove(stack.size() - 1);
    }

    private static Boolean popBoolean(List stack) {
        return (Boolean)stack.remove(stack.size() - 1);
    }

    private static String popString(List stack) {
        return (String)stack.remove(stack.size() - 1);
    }

    private static Integer popInteger(List stack) {
        return (Integer)stack.remove(stack.size() - 1);
    }

    private static Double popDouble(List stack) {
        return (Double)stack.remove(stack.size() - 1);
    }

    private static Number popNumber(List stack) {
        return (Number)stack.remove(stack.size() - 1);
    }

    private static Comparable popComparable(List stack) {
        return (Comparable)stack.remove(stack.size() - 1);
    }

    private static void push(List stack, Object o) {
        stack.add(o);
    }

    private static Class widest(Class c1, Class c2) {
        if (c1.getSuperclass() != (class$java$lang$Number == null ? (class$java$lang$Number = ParsedExpression.class$("java.lang.Number")) : class$java$lang$Number) || c2.getSuperclass() != (class$java$lang$Number == null ? (class$java$lang$Number = ParsedExpression.class$("java.lang.Number")) : class$java$lang$Number)) {
            throw new IllegalArgumentException("(" + c1.getName() + ", " + c2.getName());
        }
        if (c1 == (class$java$lang$Double == null ? (class$java$lang$Double = ParsedExpression.class$("java.lang.Double")) : class$java$lang$Double) || c2 == (class$java$lang$Double == null ? (class$java$lang$Double = ParsedExpression.class$("java.lang.Double")) : class$java$lang$Double)) {
            return class$java$lang$Double == null ? (class$java$lang$Double = ParsedExpression.class$("java.lang.Double")) : class$java$lang$Double;
        }
        if (c1 == (class$java$lang$Float == null ? (class$java$lang$Float = ParsedExpression.class$("java.lang.Float")) : class$java$lang$Float) || c2 == (class$java$lang$Float == null ? (class$java$lang$Float = ParsedExpression.class$("java.lang.Float")) : class$java$lang$Float)) {
            return class$java$lang$Float == null ? (class$java$lang$Float = ParsedExpression.class$("java.lang.Float")) : class$java$lang$Float;
        }
        if (c1 == (class$java$lang$Long == null ? (class$java$lang$Long = ParsedExpression.class$("java.lang.Long")) : class$java$lang$Long) || c2 == (class$java$lang$Long == null ? (class$java$lang$Long = ParsedExpression.class$("java.lang.Long")) : class$java$lang$Long)) {
            return class$java$lang$Long == null ? (class$java$lang$Long = ParsedExpression.class$("java.lang.Long")) : class$java$lang$Long;
        }
        if (c1 == (class$java$lang$Integer == null ? (class$java$lang$Integer = ParsedExpression.class$("java.lang.Integer")) : class$java$lang$Integer) || c2 == (class$java$lang$Integer == null ? (class$java$lang$Integer = ParsedExpression.class$("java.lang.Integer")) : class$java$lang$Integer)) {
            return class$java$lang$Integer == null ? (class$java$lang$Integer = ParsedExpression.class$("java.lang.Integer")) : class$java$lang$Integer;
        }
        if (c1 == (class$java$lang$Short == null ? (class$java$lang$Short = ParsedExpression.class$("java.lang.Short")) : class$java$lang$Short) || c2 == (class$java$lang$Short == null ? (class$java$lang$Short = ParsedExpression.class$("java.lang.Short")) : class$java$lang$Short)) {
            return class$java$lang$Short == null ? (class$java$lang$Short = ParsedExpression.class$("java.lang.Short")) : class$java$lang$Short;
        }
        return class$java$lang$Byte == null ? (class$java$lang$Byte = ParsedExpression.class$("java.lang.Byte")) : class$java$lang$Byte;
    }

    private static void load(List stack, NameContext nc) throws DasPropertyException, InvocationTargetException, ParsedExpressionException {
        String pname = ParsedExpression.popString(stack);
        Object source = ParsedExpression.pop(stack);
        Object value = source == null ? nc.get(pname) : nc.getPropertyValue(source, pname);
        ParsedExpression.push(stack, value);
    }

    private static void aload(List stack, NameContext nc) throws DasPropertyException, InvocationTargetException, ParsedExpressionException {
        Integer index = ParsedExpression.popInteger(stack);
        String pname = ParsedExpression.popString(stack);
        Object source = ParsedExpression.pop(stack);
        ParsedExpression.push(stack, nc.getIndexedPropertyValue(source, pname, index));
    }

    private static void store(List stack, NameContext nc) throws DasPropertyException, InvocationTargetException, ParsedExpressionException {
        Object value = ParsedExpression.pop(stack);
        String pname = ParsedExpression.popString(stack);
        Object dest = ParsedExpression.pop(stack);
        nc.setPropertyValue(dest, pname, value);
    }

    private static void astore(List stack, NameContext nc) throws DasPropertyException, InvocationTargetException, ParsedExpressionException {
        Object value = ParsedExpression.pop(stack);
        Integer index = ParsedExpression.popInteger(stack);
        String pname = ParsedExpression.popString(stack);
        Object dest = ParsedExpression.pop(stack);
        nc.setIndexedPropertyValue(dest, pname, index, value);
    }

    private static void negate(List stack) {
        Double a = ParsedExpression.popDouble(stack);
        ParsedExpression.push(stack, new Double(-a.doubleValue()));
    }

    private static void add(List stack) {
        Number b = ParsedExpression.popNumber(stack);
        Number a = ParsedExpression.popNumber(stack);
        Class widest = ParsedExpression.widest(a.getClass(), b.getClass());
        Number result = widest == (class$java$lang$Double == null ? (class$java$lang$Double = ParsedExpression.class$("java.lang.Double")) : class$java$lang$Double) ? (Number)new Double(a.doubleValue() + b.doubleValue()) : (Number)(widest == (class$java$lang$Float == null ? (class$java$lang$Float = ParsedExpression.class$("java.lang.Float")) : class$java$lang$Float) ? (Number)new Float(a.floatValue() + b.floatValue()) : (Number)(widest == (class$java$lang$Long == null ? (class$java$lang$Long = ParsedExpression.class$("java.lang.Long")) : class$java$lang$Long) ? (Number)new Long(a.longValue() + b.longValue()) : (Number)(widest == (class$java$lang$Integer == null ? (class$java$lang$Integer = ParsedExpression.class$("java.lang.Integer")) : class$java$lang$Integer) ? (Number)new Integer(a.intValue() + b.intValue()) : (Number)(widest == (class$java$lang$Short == null ? (class$java$lang$Short = ParsedExpression.class$("java.lang.Short")) : class$java$lang$Short) ? (Number)new Short((short)(a.shortValue() + b.shortValue())) : (Number)new Byte((byte)(a.byteValue() + b.byteValue()))))));
        ParsedExpression.push(stack, result);
    }

    private static void subtract(List stack) {
        Number b = ParsedExpression.popNumber(stack);
        Number a = ParsedExpression.popNumber(stack);
        Class widest = ParsedExpression.widest(a.getClass(), b.getClass());
        Number result = widest == (class$java$lang$Double == null ? (class$java$lang$Double = ParsedExpression.class$("java.lang.Double")) : class$java$lang$Double) ? (Number)new Double(a.doubleValue() - b.doubleValue()) : (Number)(widest == (class$java$lang$Float == null ? (class$java$lang$Float = ParsedExpression.class$("java.lang.Float")) : class$java$lang$Float) ? (Number)new Float(a.floatValue() - b.floatValue()) : (Number)(widest == (class$java$lang$Long == null ? (class$java$lang$Long = ParsedExpression.class$("java.lang.Long")) : class$java$lang$Long) ? (Number)new Long(a.longValue() - b.longValue()) : (Number)(widest == (class$java$lang$Integer == null ? (class$java$lang$Integer = ParsedExpression.class$("java.lang.Integer")) : class$java$lang$Integer) ? (Number)new Integer(a.intValue() - b.intValue()) : (Number)(widest == (class$java$lang$Short == null ? (class$java$lang$Short = ParsedExpression.class$("java.lang.Short")) : class$java$lang$Short) ? (Number)new Short((short)(a.shortValue() - b.shortValue())) : (Number)new Byte((byte)(a.byteValue() - b.byteValue()))))));
        ParsedExpression.push(stack, result);
    }

    private static void multiply(List stack) {
        Number b = ParsedExpression.popNumber(stack);
        Number a = ParsedExpression.popNumber(stack);
        Class widest = ParsedExpression.widest(a.getClass(), b.getClass());
        Number result = widest == (class$java$lang$Double == null ? (class$java$lang$Double = ParsedExpression.class$("java.lang.Double")) : class$java$lang$Double) ? (Number)new Double(a.doubleValue() * b.doubleValue()) : (Number)(widest == (class$java$lang$Float == null ? (class$java$lang$Float = ParsedExpression.class$("java.lang.Float")) : class$java$lang$Float) ? (Number)new Float(a.floatValue() * b.floatValue()) : (Number)(widest == (class$java$lang$Long == null ? (class$java$lang$Long = ParsedExpression.class$("java.lang.Long")) : class$java$lang$Long) ? (Number)new Long(a.longValue() * b.longValue()) : (Number)(widest == (class$java$lang$Integer == null ? (class$java$lang$Integer = ParsedExpression.class$("java.lang.Integer")) : class$java$lang$Integer) ? (Number)new Integer(a.intValue() * b.intValue()) : (Number)(widest == (class$java$lang$Short == null ? (class$java$lang$Short = ParsedExpression.class$("java.lang.Short")) : class$java$lang$Short) ? (Number)new Short((short)(a.shortValue() * b.shortValue())) : (Number)new Byte((byte)(a.byteValue() * b.byteValue()))))));
        ParsedExpression.push(stack, result);
    }

    private static void divide(List stack) {
        Number b = ParsedExpression.popNumber(stack);
        Number a = ParsedExpression.popNumber(stack);
        Class widest = ParsedExpression.widest(a.getClass(), b.getClass());
        Number result = widest == (class$java$lang$Double == null ? (class$java$lang$Double = ParsedExpression.class$("java.lang.Double")) : class$java$lang$Double) ? (Number)new Double(a.doubleValue() / b.doubleValue()) : (Number)(widest == (class$java$lang$Float == null ? (class$java$lang$Float = ParsedExpression.class$("java.lang.Float")) : class$java$lang$Float) ? (Number)new Float(a.floatValue() / b.floatValue()) : (Number)(widest == (class$java$lang$Long == null ? (class$java$lang$Long = ParsedExpression.class$("java.lang.Long")) : class$java$lang$Long) ? (Number)new Long(a.longValue() / b.longValue()) : (Number)(widest == (class$java$lang$Integer == null ? (class$java$lang$Integer = ParsedExpression.class$("java.lang.Integer")) : class$java$lang$Integer) ? (Number)new Integer(a.intValue() / b.intValue()) : (Number)(widest == (class$java$lang$Short == null ? (class$java$lang$Short = ParsedExpression.class$("java.lang.Short")) : class$java$lang$Short) ? (Number)new Short((short)(a.shortValue() / b.shortValue())) : (Number)new Byte((byte)(a.byteValue() / b.byteValue()))))));
        ParsedExpression.push(stack, result);
    }

    private static void eq(List stack) {
        Object b = ParsedExpression.pop(stack);
        Object a = ParsedExpression.pop(stack);
        Boolean result = a == b || a != null && a.equals(b) ? Boolean.TRUE : Boolean.FALSE;
        ParsedExpression.push(stack, result);
    }

    private static void ne(List stack) {
        Object b = ParsedExpression.pop(stack);
        Object a = ParsedExpression.pop(stack);
        ParsedExpression.push(stack, a == b || a != null && a.equals(b));
    }

    private static void gt(List stack) {
        Comparable b = ParsedExpression.popComparable(stack);
        Comparable a = ParsedExpression.popComparable(stack);
        ParsedExpression.push(stack, a.compareTo(b) > 0);
    }

    private static void lt(List stack) {
        Comparable b = ParsedExpression.popComparable(stack);
        Comparable a = ParsedExpression.popComparable(stack);
        ParsedExpression.push(stack, a.compareTo(b) < 0);
    }

    private static void ge(List stack) {
        Comparable b = ParsedExpression.popComparable(stack);
        Comparable a = ParsedExpression.popComparable(stack);
        ParsedExpression.push(stack, a.compareTo(b) >= 0);
    }

    private static void le(List stack) {
        Comparable b = ParsedExpression.popComparable(stack);
        Comparable a = ParsedExpression.popComparable(stack);
        ParsedExpression.push(stack, a.compareTo(b) <= 0);
    }

    private static void or(List stack) {
        Boolean b = ParsedExpression.popBoolean(stack);
        Boolean a = ParsedExpression.popBoolean(stack);
        ParsedExpression.push(stack, a != false || b != false);
    }

    private static void and(List stack) {
        Boolean b = ParsedExpression.popBoolean(stack);
        Boolean a = ParsedExpression.popBoolean(stack);
        ParsedExpression.push(stack, a != false && b != false);
    }

    private static void not(List stack) {
        Boolean a = ParsedExpression.popBoolean(stack);
        ParsedExpression.push(stack, a == false);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class Op {
        static final Op LOAD = new Op(0);
        static final Op ALOAD = new Op(1);
        static final Op STORE = new Op(2);
        static final Op ADD = new Op(4);
        static final Op SUBTRACT = new Op(5);
        static final Op MULTIPLY = new Op(6);
        static final Op DIVIDE = new Op(7);
        static final Op NEGATE = new Op(8);
        static final Op EQ = new Op(9);
        static final Op NE = new Op(10);
        static final Op GT = new Op(11);
        static final Op LT = new Op(12);
        static final Op GE = new Op(13);
        static final Op LE = new Op(14);
        static final Op OR = new Op(15);
        static final Op AND = new Op(16);
        static final Op NOT = new Op(17);
        int id;

        private Op(int id) {
            this.id = id;
        }
    }
}

