/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.components.propertyeditor;

import edu.uiowa.physics.pw.das.components.propertyeditor.Editable;
import edu.uiowa.physics.pw.das.components.propertyeditor.IndexedPropertyTreeNode;
import edu.uiowa.physics.pw.das.components.treetable.TreeTableNode;
import edu.uiowa.physics.pw.das.util.DasExceptionHandler;
import java.beans.BeanInfo;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.swing.tree.TreeNode;

class PropertyTreeNode
implements TreeNode,
TreeTableNode {
    protected static final Object[] NULL_ARGS;
    protected List children;
    protected PropertyTreeNode parent;
    protected PropertyDescriptor propertyDescriptor;
    protected Object value;
    protected boolean dirty;
    protected boolean childDirty;
    static /* synthetic */ Class class$edu$uiowa$physics$pw$das$components$propertyeditor$Editable;
    static /* synthetic */ Class class$java$lang$Object;

    PropertyTreeNode(Object value) {
        this.value = value;
    }

    PropertyTreeNode(PropertyTreeNode parent, PropertyDescriptor propertyDescriptor) throws InvocationTargetException {
        this.parent = parent;
        this.propertyDescriptor = propertyDescriptor;
        try {
            this.value = propertyDescriptor.getReadMethod().invoke(parent.value, NULL_ARGS);
        }
        catch (IllegalAccessException iae) {
            throw new RuntimeException(iae);
        }
    }

    public Enumeration children() {
        this.maybeLoadChildren();
        return Collections.enumeration(this.children);
    }

    public boolean getAllowsChildren() {
        return this.value instanceof Editable;
    }

    public TreeNode getChildAt(int childIndex) {
        this.maybeLoadChildren();
        return (TreeNode)this.children.get(childIndex);
    }

    public int getChildCount() {
        this.maybeLoadChildren();
        return this.children.size();
    }

    public int getIndex(TreeNode node) {
        this.maybeLoadChildren();
        return this.children.indexOf(node);
    }

    public TreeNode getParent() {
        return this.parent;
    }

    public boolean isLeaf() {
        this.maybeLoadChildren();
        return this.children.isEmpty();
    }

    PropertyDescriptor getPropertyDescriptor() {
        return this.propertyDescriptor;
    }

    protected void maybeLoadChildren() {
        if (this.children == null) {
            this.children = new ArrayList();
            if (this.value instanceof Editable) {
                try {
                    BeanInfo info = Introspector.getBeanInfo(this.value.getClass());
                    PropertyDescriptor[] properties = info.getPropertyDescriptors();
                    for (int i = 0; i < properties.length; ++i) {
                        if (properties[i].getReadMethod() == null) continue;
                        if (properties[i] instanceof IndexedPropertyDescriptor) {
                            this.children.add(new IndexedPropertyTreeNode(this, (IndexedPropertyDescriptor)properties[i]));
                            continue;
                        }
                        this.children.add(new PropertyTreeNode(this, properties[i]));
                    }
                }
                catch (IntrospectionException ie) {
                    throw new RuntimeException(ie);
                }
                catch (InvocationTargetException ite) {
                    DasExceptionHandler.handle(ite.getCause());
                }
            }
        }
    }

    Object getValue() {
        return this.value;
    }

    Object getDisplayValue() {
        if (this.getAllowsChildren()) {
            return "Click to expand/collapse";
        }
        return this.value;
    }

    String getDisplayName() {
        if (this.propertyDescriptor == null) {
            return "root";
        }
        return this.propertyDescriptor.getName();
    }

    void setValue(Object obj) {
        if (obj == this.value) {
            return;
        }
        if (obj != null && obj.equals(this.value)) {
            return;
        }
        this.value = obj;
        this.setDirty();
    }

    void flush() throws InvocationTargetException {
        try {
            if (this.dirty) {
                Method writeMethod = this.propertyDescriptor.getWriteMethod();
                writeMethod.invoke(this.parent.value, this.value);
                this.dirty = false;
            }
            if (this.childDirty) {
                Iterator i = this.children.iterator();
                while (i.hasNext()) {
                    PropertyTreeNode child = (PropertyTreeNode)i.next();
                    child.flush();
                }
                this.childDirty = false;
            }
        }
        catch (IllegalAccessException iae) {
            throw new RuntimeException(iae);
        }
    }

    private void setDirty() {
        this.dirty = true;
        if (this.parent != null) {
            this.parent.setChildDirty();
        }
    }

    public boolean isDirty() {
        return this.dirty || this.childDirty;
    }

    private void setChildDirty() {
        this.childDirty = true;
        if (this.parent != null) {
            this.parent.setChildDirty();
        }
    }

    public Object getValueAt(int column) {
        switch (column) {
            case 0: {
                return this.getDisplayName();
            }
            case 1: {
                return this.getDisplayValue();
            }
        }
        throw new IllegalArgumentException("No such column: " + column);
    }

    public void setValueAt(Object value, int column) {
        switch (column) {
            case 0: {
                throw new IllegalArgumentException("Cell is not editable");
            }
            case 1: {
                this.setValue(value);
                break;
            }
            default: {
                throw new IllegalArgumentException("No such column: " + column);
            }
        }
    }

    public boolean isCellEditable(int column) {
        if (this.propertyDescriptor instanceof IndexedPropertyDescriptor) {
            IndexedPropertyDescriptor ipd = (IndexedPropertyDescriptor)this.propertyDescriptor;
            return column == 1 && !(class$edu$uiowa$physics$pw$das$components$propertyeditor$Editable == null ? (class$edu$uiowa$physics$pw$das$components$propertyeditor$Editable = PropertyTreeNode.class$("edu.uiowa.physics.pw.das.components.propertyeditor.Editable")) : class$edu$uiowa$physics$pw$das$components$propertyeditor$Editable).isAssignableFrom(ipd.getIndexedPropertyType());
        }
        return column == 1 && !(class$edu$uiowa$physics$pw$das$components$propertyeditor$Editable == null ? (class$edu$uiowa$physics$pw$das$components$propertyeditor$Editable = PropertyTreeNode.class$("edu.uiowa.physics.pw.das.components.propertyeditor.Editable")) : class$edu$uiowa$physics$pw$das$components$propertyeditor$Editable).isAssignableFrom(this.propertyDescriptor.getPropertyType());
    }

    public Class getColumnClass(int columnIndex) {
        return class$java$lang$Object == null ? (class$java$lang$Object = PropertyTreeNode.class$("java.lang.Object")) : class$java$lang$Object;
    }

    public int getColumnCount() {
        return 2;
    }

    public String getColumnName(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return "Propety name";
            }
            case 1: {
                return "Value";
            }
        }
        throw new IllegalArgumentException("No such column: " + columnIndex);
    }

    public String toString() {
        return this.getDisplayName();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        String[] beanInfoSearchPath = new String[]{"edu.uiowa.physics.pw.das.beans", "sun.beans.infos"};
        Introspector.setBeanInfoSearchPath(beanInfoSearchPath);
        NULL_ARGS = new Object[0];
    }
}

