/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.components;

import edu.uiowa.physics.pw.das.dataset.DataSet;
import edu.uiowa.physics.pw.das.dataset.DataSetDescriptor;
import edu.uiowa.physics.pw.das.dataset.DataSetUtil;
import edu.uiowa.physics.pw.das.dataset.TableDataSet;
import edu.uiowa.physics.pw.das.dataset.TableDataSetConsumer;
import edu.uiowa.physics.pw.das.dataset.VectorDataSet;
import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.TimeLocationUnits;
import edu.uiowa.physics.pw.das.datum.format.DatumFormatter;
import edu.uiowa.physics.pw.das.datum.format.TimeDatumFormatter;
import edu.uiowa.physics.pw.das.event.DasUpdateEvent;
import edu.uiowa.physics.pw.das.event.DataPointSelectionEvent;
import edu.uiowa.physics.pw.das.event.DataPointSelectionListener;
import edu.uiowa.physics.pw.das.graph.DasAxis;
import edu.uiowa.physics.pw.das.graph.DasCanvas;
import edu.uiowa.physics.pw.das.graph.DasColumn;
import edu.uiowa.physics.pw.das.graph.DasPlot;
import edu.uiowa.physics.pw.das.graph.DasRow;
import edu.uiowa.physics.pw.das.graph.SymbolLineRenderer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class VerticalSpectrogramSlicer
extends DasPlot
implements DataPointSelectionListener {
    private JDialog popupWindow;
    private DasPlot parentPlot;
    private Datum yValue;
    private int lastTagIndex = 1;
    private long eventBirthMilli;
    private SymbolLineRenderer renderer;

    private VerticalSpectrogramSlicer(DasPlot parent, DasAxis xAxis, DasAxis yAxis) {
        super(xAxis, yAxis);
        this.parentPlot = parent;
        this.renderer = new SymbolLineRenderer((DataSetDescriptor)null);
        this.addRenderer(this.renderer);
    }

    public static VerticalSpectrogramSlicer createSlicer(DasPlot plot, TableDataSetConsumer dataSetConsumer) {
        DasAxis sourceYAxis = plot.getYAxis();
        DasAxis sourceZAxis = dataSetConsumer.getZAxis();
        DasAxis xAxis = sourceYAxis.createAttachedAxis(2);
        DasAxis yAxis = sourceZAxis.createAttachedAxis(3);
        return new VerticalSpectrogramSlicer(plot, xAxis, yAxis);
    }

    public void showPopup() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.showPopupImpl();
        } else {
            Runnable runnable = new Runnable(){

                public void run() {
                    VerticalSpectrogramSlicer.this.showPopupImpl();
                }
            };
        }
    }

    private void showPopupImpl() {
        if (this.popupWindow == null) {
            this.createPopup();
        }
        this.popupWindow.setVisible(true);
    }

    private void createPopup() {
        int width = this.parentPlot.getCanvas().getWidth() / 2;
        int height = this.parentPlot.getCanvas().getHeight() / 2;
        DasCanvas canvas = new DasCanvas(width, height);
        DasRow row = new DasRow(canvas, 0.1, 0.9);
        DasColumn column = new DasColumn(canvas, 0.1, 0.9);
        canvas.add(this, row, column);
        JPanel content = new JPanel(new BorderLayout());
        JPanel buttonPanel = new JPanel();
        BoxLayout buttonLayout = new BoxLayout(buttonPanel, 0);
        JButton close = new JButton("Hide Window");
        close.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                VerticalSpectrogramSlicer.this.popupWindow.setVisible(false);
            }
        });
        buttonPanel.setLayout(buttonLayout);
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(close);
        content.add((Component)canvas, "Center");
        content.add((Component)buttonPanel, "South");
        Window parentWindow = SwingUtilities.getWindowAncestor(this.parentPlot);
        this.popupWindow = parentWindow instanceof Frame ? new JDialog((Frame)parentWindow) : (parentWindow instanceof Dialog ? new JDialog((Dialog)parentWindow) : new JDialog());
        this.popupWindow.setTitle("Vertical Slicer");
        this.popupWindow.setDefaultCloseOperation(2);
        this.popupWindow.setContentPane(content);
        this.popupWindow.pack();
        Point parentLocation = new Point();
        SwingUtilities.convertPointToScreen(parentLocation, this.parentPlot.getCanvas());
        this.popupWindow.setLocation(parentLocation.x + this.parentPlot.getCanvas().getWidth(), parentLocation.y);
    }

    protected void drawContent(Graphics2D g) {
        long x = System.currentTimeMillis() - this.eventBirthMilli;
        int ix = (int)this.getXAxis().transform(this.yValue);
        DasRow row = this.getRow();
        int iy0 = row.getDMinimum();
        int iy1 = row.getDMaximum();
        g.drawLine(ix + 3, iy0, ix, iy0 + 3);
        g.drawLine(ix - 3, iy0, ix, iy0 + 3);
        g.drawLine(ix + 3, iy1, ix, iy1 - 3);
        g.drawLine(ix - 3, iy1, ix, iy1 - 3);
        g.setColor(new Color(230, 230, 230));
        g.drawLine(ix, iy0 + 4, ix, iy1 - 4);
        super.drawContent(g);
        x = System.currentTimeMillis() - this.eventBirthMilli;
    }

    public void DataPointSelected(DataPointSelectionEvent e) {
        long[] xxx = new long[]{0L, 0L, 0L, 0L};
        xxx[0] = System.currentTimeMillis() - e.birthMilli;
        DataSet ds = e.getDataSet();
        if (ds == null || !(ds instanceof TableDataSet)) {
            return;
        }
        TableDataSet tds = (TableDataSet)ds;
        VectorDataSet sliceDataSet = tds.getXSlice(DataSetUtil.closestColumn(tds, e.getX()));
        this.renderer.setDataSet(sliceDataSet);
        if (this.popupWindow != null && !this.popupWindow.isVisible() || this.getCanvas() == null) {
            this.showPopup();
        }
        this.yValue = e.getY();
        Datum xValue = e.getX();
        DatumFormatter formatter = xValue.getUnits() instanceof TimeLocationUnits ? TimeDatumFormatter.DEFAULT : xValue.getFormatter();
        this.setTitle("x: " + formatter.format(xValue) + " y: " + this.yValue);
        this.eventBirthMilli = e.birthMilli;
    }

    protected void uninstallComponent() {
        super.uninstallComponent();
    }

    protected void installComponent() {
        super.installComponent();
        this.getCanvas().getGlassPane().setVisible(false);
    }

    protected void processDasUpdateEvent(DasUpdateEvent e) {
        if (this.isDisplayable()) {
            this.updateImmediately();
            this.resize();
        }
    }
}

